/*!
	ONSIDE-JS SIDEBAR v1.0.0 (http://getonside-js.com)
 	Copyright (c) 2016 STÜBER SYSTEMS GmbH, http://www.stueber.de

	Enbrea-JS is free software: you can redistribute it and/or modify
	it under the terms of the GNU Affero General Public License as
	published by the Free Software Foundation, either version 3 of the
	License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Affero General Public License for more details.

	You should have received a copy of the GNU Affero General Public License
	along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

// ONSIDE namespace
var ONSIDE = ONSIDE || {};

ONSIDE.markActiveItemPath = function (menu) {
    var activeItem = menu.find(".sidebar-active-item");
    if (activeItem.length > 0)
        activeItem.parentsUntil(".onside-menu-page").filter("li").addClass("sidebar-active-item");
    //    else 
    //        $(".onside-menu > .onside-menu-slider > .onside-menu-page > ul > li:first-child").addClass("sidebar-active-item");
    return activeItem;
};


ONSIDE.expandActiveItemPath = function (node) {
    if (node.children("ul").length > 0) {
        var newPage = ONSIDE.expandSidebarNode.call(node);
        ONSIDE.expandActiveItemPath(newPage.children("ul").children(".sidebar-active-item"));
    }
};

ONSIDE.animateSidebarSlider = function (newPage, level) {
    var objSlider = newPage.closest(".onside-menu-slider");
    var currentLevel = parseInt(objSlider.attr("data-level") || 0);

    var h = 0;
    newPage.children().each(function () {
        h = h + $(this).outerHeight(true);
    });

    if (h > objSlider.height())
        objSlider
            .addClass("onside-menu-slider-grow")
            .css("height", h + "px")
            .attr("data-level", currentLevel + level);
    else
        objSlider
            .removeClass("onside-menu-slider-grow")
            .attr("data-level", currentLevel + level)
            .css("height", h + "px");
};


ONSIDE.expandSidebarNode = function () {
    $(this).parents(".onside-menu-page").nextAll(".onside-menu-page").remove();
    var newPage = $("<div class=\"onside-menu-page\"></div>")
        .append($(this).children().clone(true, true).wrapAll("<ul></ul>"))
        .attr("data-index", $(this).index());

    newPage.appendTo($(this).closest(".onside-menu-slider"));
    ONSIDE.animateSidebarSlider(newPage, +1);// by param

    return newPage;
};


ONSIDE.markAfiliatedNodesSelected = function (page, indexes) {
    if (page.length > 0) {
        // mark the item in the page
        var point = page;
        for (var i = 0; i < indexes.length; i++)
            point = point.children("ul").children("li").eq(indexes[indexes.length - i - 1]);
        point.addClass("sidebar-selected");

        // do the same for the prev page
        indexes.push(page.attr("data-index"));
        ONSIDE.markAfiliatedNodesSelected(page.prev(), indexes);
    }
};

ONSIDE.onSidebarNodeClick = function (e) {
    if ($(this).parent().hasClass("onside-menu-page")) { // page title click
        var newPage = $(this).closest(".onside-menu-page").prev(".onside-menu-page");
        if (newPage.length > 0) { // not the first level
            // notify app  
            $(this).closest(".onside-menu").trigger($.Event("onside-menu", { originalEvent: e }), { node: $(this), eventType: "collapse" });

            ONSIDE.animateSidebarSlider(newPage, -1);
        }
    } else if ($(this).siblings("ul").length > 0) { // there are sub nodes
        // notify app  
        $(this).closest(".onside-menu").trigger($.Event("onside-menu", { originalEvent: e }), { node: $(this), eventType: "expand" });

        // expand next level page
        ONSIDE.expandSidebarNode.call($(this).closest("li"));
    } else {
        // notify app  
        $(this).closest(".onside-menu").trigger($.Event("onside-menu", { originalEvent: e }), { node: $(this), eventType: "item" });

        $(".sidebar-selected").removeClass("sidebar-selected");

        ONSIDE.markAfiliatedNodesSelected($(this).closest(".onside-menu-page"), [$(this).closest("li").index()]);

        //if ($(window).width() < 768) 
        //	showSidebar(false);
    }
};



// public. scoped?
function fixSidebarHeight(slider) {
    var h = 0;

    slider.find(".onside-menu-page:last-child > *").each(function () {
        h = h + $(this).outerHeight(true);
    });
    slider.css("height", h + "px");
}

function initSidebar(menu) {
    if (arguments.length == 0) {
        $(".onside-menu").each(function () {
            initSidebar($(this));
        });
    } else {
        menu.off("click", "a");
        menu.on("click", "a", ONSIDE.onSidebarNodeClick);


        var activeItem = ONSIDE.markActiveItemPath(menu);
        if (activeItem.length > 0) {
            activeItem.addClass("sidebar-selected");
            ONSIDE.expandActiveItemPath(menu.find(".onside-menu-slider > .onside-menu-page > ul > li.sidebar-active-item"));
            menu.find(".sidebar-active-item").removeClass("sidebar-active-item");
        }

        var slider = menu.find(".onside-menu-slider");
        fixSidebarHeight(slider);

        slider.addClass("sidebar-animated");
    }
}


function showSidebar(show) {
  if(typeof show === "boolean") {
	  if (show && !$(".onside-menu-container").hasClass("onside-menu-state-show")) {
		$(".onside-menu-container").addClass("onside-menu-state-show");
	  } else if (!show && $(".onside-menu-container").hasClass("onside-menu-state-show")){
		$(".onside-menu-container").removeClass("onside-menu-state-show");
	  }
  } else {
	$(".onside-menu-container").toggleClass("onside-menu-state-show");
  }
}


