﻿$.fn.flipRows = function (params) {
    function onFlipRows(e) {
        with (e.data) {
            if (rowCount > pageSize) {

                tableRows.slice(startNo, endNo).fadeOut(500);

                // set new values for startNo and endNo
                if (endNo >= rowCount) {
                    startNo = 0;
                    endNo = pageSize;
                    pageNo = 1;
                } else {
                    startNo = endNo;
                    if ((endNo + pageSize) > rowCount) endNo = rowCount;
                    else endNo += pageSize;
                    pageNo++;
                }

                $(this).trigger("fliprowsnotify", e.data);

                // next startNo...endNo show with fadeIn
                if (!tableReloadPending) {
                    tableRows
                        .slice(startNo, endNo)
                        .delay(500)
                        .fadeIn(500);
                }
            } else {
                $(this).trigger("fliprowsnotify", e.data);
            }
        }
    };

    $(this).off("fliprows");

    var tableRows = $(this).children();
    var o = {
        tableRows: tableRows,
        rowCount: tableRows.length,
        pageNo: 1,
        pageCount: Math.ceil(tableRows.length / params.pageSize),
        startNo: 0,
        endNo: params.pageSize,
        tableReloadPending: false,
    };

    if (o.rowCount > params.pageSize) {
        tableRows.slice(0).hide();
        tableRows.slice(o.startNo, o.endNo).fadeIn();
    }

    $.extend(true, params, o);

    $(this).trigger("fliprowsnotify", $.extend({}, params, {init: true}));
    $(this).on("fliprows", params, onFlipRows);
};