/*!
  	ONTIME-JS SCHEDULER v1.0.0 (http://getontime-js.com)
 	Copyright (c) 2014 STÜBER SYSTEMS GmbH, http://www.stueber.de

	Enbrea-JS is free software: you can redistribute it and/or modify
	it under the terms of the GNU Affero General Public License as
	published by the Free Software Foundation, either version 3 of the
	License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Affero General Public License for more details.

	You should have received a copy of the GNU Affero General Public License
	along with this program. If not, see <http://www.gnu.org/licenses/>.
*/


// ONTIME namespace 
var ONTIME = window.ONTIME || (window.ONTIME = {});

// SchedulerLayer class
ONTIME.SchedulerLayer = function (params) {
    this.filterParams = {};
	this.items = [];
	this.itemBuilderCallbacks = [];
	this.el = null;
	this.scheduler = null;
	this.visible = true;
    this.maxParallelItems = 10;
	
	$.extend(this, params);
	
	this.$el = $(this.el);
};

ONTIME.SchedulerLayer.NodeTemplate = '<div id="0" class="ontime-scheduler-item ontime-scheduler-dataitem" data-xi="1" data-yi="1" data-xs="1" data-ys="1"><div class="ontime-scheduler-itemsharedpart"><div class="ontime-scheduler-itemcontent"><div class="ontime-scheduler-itemcontentdata"></div></div></div></div>';

ONTIME.SchedulerLayer.prototype.getMaxParallelItems = function () {
    return this.maxParallelItems;
};


ONTIME.SchedulerLayer.prototype.clear = function(e) {
	this.items = [];

	while (this.$el[0].firstChild) 
	    this.$el[0].removeChild(this.$el[0].firstChild);
};

ONTIME.SchedulerLayer.prototype.getItems = function() {
	return [];
};

ONTIME.SchedulerLayer.prototype.filterItem = function(item, filterParams, stage) {
	return true;
};

ONTIME.SchedulerLayer.prototype.ungroupItem = function(item) {
	return [item];
};

ONTIME.SchedulerLayer.prototype.buildItem = function(item, itemNode) {
	for(var j=0; j<this.itemBuilderCallbacks.length; j++) 
		this.itemBuilderCallbacks[j].call(this, item, itemNode);
};

ONTIME.SchedulerLayer.prototype.refresh = function() {
	this.refresh1();
	this.refresh2();
	
	this.refresh3(true);
	
	if (this.r2.length>0) {
		this.refresh3(false);
		//setTimeout($.proxy(this.refresh3, this, false), 10);
	} else
		this.assignWeightAndIndex();
	
}

ONTIME.SchedulerLayer.prototype.refresh2 = function () {
    this.scheduler.userFlags = {
        "max-data-ys": 0,
        "offset-data-ys": false,
    };

	this.r1 = [];
	this.r2 = [];
	
	var itemNodeMaster = $(ONTIME.SchedulerLayer.NodeTemplate);
	
	for(var i=0; i<this.items.length; i++) {
		var itemNode = itemNodeMaster.clone();
			
		itemNode.attr("id", i);

		if (typeof this.items[i]._i === "number")
		    itemNode.attr("data-i", this.items[i]._i);

		this.buildItem(this.items[i], itemNode);
			
		var xi = parseInt(itemNode.attr("data-xi"));
		var yi = parseInt(itemNode.attr("data-yi"));
		var xs = parseInt(itemNode.attr("data-xs"));
		var ys = parseInt(itemNode.attr("data-ys"));
		var layoutStyle = {};
		ONTIME.Scheduler.CellLayout.h.getCellStyleSize(layoutStyle, this.scheduler.topHeader.items.length, xi, xs, this.scheduler.topHeader.fixedSize);
		ONTIME.Scheduler.CellLayout.v.getCellStyleSize(layoutStyle, this.scheduler.leftHeader.items.length, yi, ys, this.scheduler.leftHeader.fixedSize);
			
		for(var xx in layoutStyle)
			itemNode[0].style[xx] = layoutStyle[xx];
			
		if (itemNode.attr("data-xi") != "0") {
			if (parseInt(itemNode.attr("data-xi")) < 20) 
				this.r1.push(itemNode);
			else
				this.r2.push(itemNode);
		}
	}
}

ONTIME.SchedulerLayer.prototype.refresh3 = function(a) {
	if(a)
		this.$el.append(this.r1);
	else {
		this.$el.append(this.r2);
		this.assignWeightAndIndex();
	}
}

ONTIME.SchedulerLayer.prototype.refresh1 = function() {
	var items = this.getItems();
	if((typeof items === "object") && (typeof items.length !=="undefined")) {
		for(var i=0; i<items.length; i++) {
			if(this.filterItem(items[i], this.scheduler.filterParams, 1)) {
				var uItems = this.ungroupItem(items[i]);
				for(var j=0; j<uItems.length; j++) {
					if(uItems.length == 1 || this.filterItem(uItems[j], this.scheduler.filterParams, 2)) {
						this.items.push(uItems[j]);
					}
				}
			}
		}
	}
};



ONTIME.SchedulerLayer.prototype.slideItemPre = function() {
		var xindex = $(this).attr("data-xi");
		var yindex = $(this).attr("data-yi");
	
		$('.ontime-scheduler-dataitem[data-xi="' + xindex + '"][data-yi="' + yindex + '"]').each(function() {
			var w = parseInt($(this).attr("data-w"));
			if (w>1) {
			  var v = parseInt($(this).attr("data-vi"));
			  var c = parseInt($(this).attr("data-ci"));
			  
			  // make sure next item is at the right and ready to slide in
			  if (v<w) {
				$(this).attr("data-vi", v+1);
				if (c==(v+1))
				  $(this).attr("data-sp", "right");
			  } else {
				$(this).attr("data-vi", 1);
				if (c==1)
				  $(this).attr("data-sp", "right");
			  }
			}			
		});
};

ONTIME.SchedulerLayer.prototype.slideItemPost = function() {
		var xindex = $(this).attr("data-xi");
		var yindex = $(this).attr("data-yi");
	
		$('.ontime-scheduler-dataitem[data-xi="' + xindex + '"][data-yi="' + yindex + '"]').each(function() {
			var w = parseInt($(this).attr("data-w"));
			if (w>1) {
			  var v = parseInt($(this).attr("data-vi"));
			  var c = parseInt($(this).attr("data-ci"));
			  
			  if (v==c) { 
				$(this).attr("data-sp", "current");
			  } else /*if ((v==(c+1)) || ( v==1 && c==w) ) */{
				$(this).attr("data-sp", "left");
			  }
			}			
		});
};

ONTIME.SchedulerLayer.prototype.startSliding = function(item) {
	var self = this;
	item
		//.delay(3000 + Math.floor((Math.random() * 1000)))
		.delay(3000)
		.queue(function () {
		    var xindex = $(this).attr("data-xi");
		    var yindex = $(this).attr("data-yi");

		    var currentItem = $('.ontime-scheduler-dataitem[data-xi="' + xindex + '"][data-yi="' + yindex + '"][data-sp="current"]');
		    var isHover = ((currentItem.length > 0) && currentItem.is(":hover"));

		    if (!isHover && $(this).parents(".ontime-scheduler-allow-slide").length > 0) {
				var w = parseInt($(this).attr("data-w"));
				if(w > self.getMaxParallelItems() || (w>1 && $(this).parents(".ontime-scheduler-parallel").length==0)) {
					self.slideItemPre.call(this);
					setTimeout($.proxy(self.slideItemPost, this), 100);
				}
			}
			$(this).dequeue();
			self.startSliding(item);
	});
};

ONTIME.SchedulerLayer.prototype.itemsCompareInternal = function (i1, i2) {
    return this.itemsCompare(i1, i2);
}


ONTIME.SchedulerLayer.prototype.itemsCompare = function(i1,i2) {
    var r = i1.domElement.id - i2.domElement.id;
    return r;
}

ONTIME.SchedulerLayer.prototype.assignWeightAndIndex = function() {
  // cellWeight -> itemWeight -> cellWeight2 -> itemWeight2

  // pass 0
  // build js array for dom elements
  var mX = 0;
  var mY = 0;
  var dataItems = [];

  this.$el.children().each(function() {
    if (!this.classList.contains('ontime-scheduler-sametarget')) {
		var o = {
			domElement: this,
			xindex: parseInt(this.getAttribute("data-xi")),
			yindex: parseInt(this.getAttribute("data-yi")),
			xspan: parseInt(this.getAttribute("data-xs")),
            yspan: parseInt(this.getAttribute("data-ys")),
            i: parseInt(this.getAttribute("data-i")),
            id: parseInt(this.id),
			weight: 0,
			cindex: 0,
			weight2: 0
		};
		dataItems.push(o);
	
		if (mX < (o.xindex+o.xspan)) 
			mX = (o.xindex+o.xspan);
		if (mY < (o.yindex+o.yspan)) 
			mY = (o.yindex+o.yspan);
	}
  });

  // sort it
  dataItems.sort($.proxy(this.itemsCompareInternal, this));
  
  // preallocate cell weight arrays 

  var cellDef = new Array(mY);
  for (var i = 0; i < mY; i++) {
      cellDef[i] = new Array(mX);
      for (var j = 0; j < mX; j++) {
          cellDef[i][j] = {
              weight: 0,
              weight2: 0,
              highestIndex: 0,
              items: [],
          };
      }
  }

  // pass 1
  // calculate cell weight -> cellWeight
  // cell weight = number of items sharing the cell
  for(var i=0; i < dataItems.length; i++) {
	for(var sx=0; sx < dataItems[i].xspan; sx++) {
	    for (var sy = 0; sy < dataItems[i].yspan; sy++) {
	        cellDef[dataItems[i].yindex + sy][dataItems[i].xindex + sx].weight++;
	        cellDef[dataItems[i].yindex + sy][dataItems[i].xindex + sx].items.push(i);
		}
	}    
  }

  // pass 2
  // calculate item weight -> itemWeight
  // item weight is largest weight among covered cells
  for(var i=0; i < dataItems.length; i++) {
	for(var sx=0; sx < dataItems[i].xspan; sx++) {
	    for (var sy = 0; sy < dataItems[i].yspan; sy++) {
	        if (dataItems[i].weight < cellDef[dataItems[i].yindex + sy][dataItems[i].xindex + sx].weight) {
	            dataItems[i].weight = cellDef[dataItems[i].yindex + sy][dataItems[i].xindex + sx].weight;
	        }
		}
	}    
  }
	
  // pass 3
  // fix cell weight -> cellWeight2
  // fixed cell weight = max (item weight)
  for(var i=0; i < dataItems.length; i++) {
	for(var sx=0; sx < dataItems[i].xspan; sx++) {
		for(var sy=0; sy < dataItems[i].yspan; sy++) {
			if (cellDef[dataItems[i].yindex+sy][dataItems[i].xindex+sx].weight2 < dataItems[i].weight) {
				cellDef[dataItems[i].yindex+sy][dataItems[i].xindex+sx].weight2 = dataItems[i].weight;
			}
		}
	}    
  }
  
  // pass 4
  // fix item weight -> itemWeight2
  // fixed item weight = max (cell weight2)
  for(var i=0; i < dataItems.length; i++) {
	for(var sx=0; sx < dataItems[i].xspan; sx++) {
		for(var sy=0; sy < dataItems[i].yspan; sy++) {
			if (dataItems[i].weight2 < cellDef[dataItems[i].yindex+sy][dataItems[i].xindex+sx].weight2) {
				dataItems[i].weight2 = cellDef[dataItems[i].yindex+sy][dataItems[i].xindex+sx].weight2;
			}
		}
	}    
  }

  
  // pass 5
  // calculate item index
  // -> cellHighestIndex
  for(var i=0; i < dataItems.length; i++) {
	// find highest (already used) index in the cells which this item covers
	var maxCellIndex = 0;
	for(var sx=0; sx < dataItems[i].xspan; sx++) {
		for(var sy=0; sy < dataItems[i].yspan; sy++) {
			if (maxCellIndex < cellDef[dataItems[i].yindex+sy][dataItems[i].xindex+sx].highestIndex) {
				maxCellIndex = cellDef[dataItems[i].yindex+sy][dataItems[i].xindex+sx].highestIndex;
			}
		}
	}    

	// allocate the next one
	maxCellIndex ++;
	
	dataItems[i].cindex = maxCellIndex;
	
    // mark the cells, which this item covers, with the new highest index
	for(var sx=0; sx < dataItems[i].xspan; sx++) {
		for(var sy=0; sy < dataItems[i].yspan; sy++) {
		    cellDef[dataItems[i].yindex + sy][dataItems[i].xindex + sx].highestIndex = maxCellIndex;
		}
	}
  }


    // pass 5a
  var mark0 = false;
  for (var i = 0; i < mY; i++) {
      for (var j = 0; j < mX; j++) {
          if (cellDef[i][j].weight2 < cellDef[i][j].highestIndex) {
              cellDef[i][j].weight2 = cellDef[i][j].highestIndex;
              mark0 = true;
          }
      }
  }

  while (mark0) {
      var mark1 = false;
      for (var i = 0; i < dataItems.length; i++) {
          for (var sx = 0; sx < dataItems[i].xspan; sx++) {
              for (var sy = 0; sy < dataItems[i].yspan; sy++) {
                  if (dataItems[i].weight2 < cellDef[dataItems[i].yindex + sy][dataItems[i].xindex + sx].weight2) {
                      dataItems[i].weight2 = cellDef[dataItems[i].yindex + sy][dataItems[i].xindex + sx].weight2;
                      mark1 = true;
                  }
              }
          }
      }
      if (!mark1)
          break;

      var mark2 = false;
      for (var i = 0; i < dataItems.length; i++) {
          for (var sx = 0; sx < dataItems[i].xspan; sx++) {
              for (var sy = 0; sy < dataItems[i].yspan; sy++) {
                  if (cellDef[dataItems[i].yindex + sy][dataItems[i].xindex + sx].weight2 < dataItems[i].weight2) {
                      cellDef[dataItems[i].yindex + sy][dataItems[i].xindex + sx].weight2 = dataItems[i].weight2;
                      mark2 = true;
                  }
              }
          }
      }
      if (!mark2)
          break;
  }


  var buttonIndexTemplate = $(".ontime-scheduler > .ontime-scheduler-slideindextemplate");

  // pass 6
  // apply calculated attributes to dom elements
  for(var i=0; i < dataItems.length; i++) {
	  dataItems[i].domElement.setAttribute("data-w", dataItems[i].weight2);
	  dataItems[i].domElement.setAttribute("data-ci", dataItems[i].cindex);
	  dataItems[i].domElement.setAttribute("data-vi", 1);
	  
	  if (dataItems[i].cindex == 1 && dataItems[i].weight2 > 1)
	      dataItems[i].domElement.classList.add("ontime-serial-1");

	  dataItems[i].domElement.setAttribute("data-sp", 
		((dataItems[i].cindex>1) && (dataItems[i].weight2>1))?"right":"current");

      if (dataItems[i].weight2 > this.getMaxParallelItems()) 
		dataItems[i].domElement.setAttribute("data-co", "m"); // many
	  else if (dataItems[i].weight2 > 1) 
		dataItems[i].domElement.setAttribute("data-co", "f"); // few
	  else 
		dataItems[i].domElement.setAttribute("data-co", "s"); // single
	  
	  if (dataItems[i].cindex == dataItems[i].weight2) {
		dataItems[i].domElement.setAttribute("data-li", dataItems[i].weight2);
	  } else {
	    dataItems[i].domElement.removeAttribute("data-li");
	  }
	  
	  
	  if (dataItems[i].cindex == 1 && this.scheduler.$el.hasClass("ontime-scheduler-allow-slide") && !this.scheduler.userFlags["offset-data-ys"]) {
	      if (dataItems[i].weight2 > 1) {
              if (dataItems[i].weight2 > this.getMaxParallelItems()) {
                  // candidate to slide, check if consistent with other items

	              var canSlide = true;
	              for (var sx = 0; sx < dataItems[i].xspan; sx++) {
	                  for (var sy = 0; sy < dataItems[i].yspan; sy++) {
	                      for (var sz = 0; sz < cellDef[dataItems[i].yindex + sy][dataItems[i].xindex + sx].items.length; sz++) {
	                          // check dataItems[  cellDef[dataItems[i].yindex + sy][dataItems[i].xindex + sx].items[sz]  ].
	                          if(!(
                                  dataItems[  cellDef[dataItems[i].yindex + sy][dataItems[i].xindex + sx].items[sz]  ].xindex == dataItems[i].xindex &&
                                  dataItems[  cellDef[dataItems[i].yindex + sy][dataItems[i].xindex + sx].items[sz]  ].yindex == dataItems[i].yindex &&
                                  dataItems[  cellDef[dataItems[i].yindex + sy][dataItems[i].xindex + sx].items[sz]  ].xspan == dataItems[i].xspan &&
                                  dataItems[  cellDef[dataItems[i].yindex + sy][dataItems[i].xindex + sx].items[sz]  ].yspan == dataItems[i].yspan
                                  )) {
	                              canSlide = false;
	                              break;
	                          }
	                      } // sz
	                      if (!canSlide)
	                          break;
	                  } // sy
	                  if (!canSlide)
	                      break;
	              }

	              if (canSlide) {
	                  for (var sx = 0; sx < dataItems[i].xspan; sx++) {
	                      for (var sy = 0; sy < dataItems[i].yspan; sy++) {
	                          for (var sz = 0; sz < cellDef[dataItems[i].yindex + sy][dataItems[i].xindex + sx].items.length; sz++) {
	                              dataItems[cellDef[dataItems[i].yindex + sy][dataItems[i].xindex + sx].items[sz]].domElement.classList.add("ontime-scheduler-slide");
	                          } // sz
	                      } // sy
	                  } // sx
	              }

	              if (canSlide) {
	                  var buttonIndex = buttonIndexTemplate.clone();
	                  var buttonIndexItem = buttonIndex.children();

	                  for (var j = 1; j < dataItems[i].weight2; j++)
	                      buttonIndex.append(buttonIndexItem.clone());

	                  var o = $(dataItems[i].domElement);
	                  o.append(buttonIndex);
	                  this.startSliding(o);
	              }
	          }
		  }
	  }
  }
};



// Scheduler class
ONTIME.Scheduler = function (params) {
	this.busy = false;
	this.el = null;
	this.layers = [];
	this.leftHeader = {
		items: [],
		builderCallback: null,
		fixedSize: false
	};
	this.topHeader = {
		items: [],
		builderCallback: null,
		fixedSize: false
	};
	

	$.extend(this, params);
	
	this.$el = $(this.el);
	  
	// TODO: redesign: drag - drop is a Layer based
    this.$el
        .on("click", "[data-linkparam]", $.proxy(this.linkClickInternal, this));	

    this.$el
        .on("mouseenter", "[data-linkparam]", $.proxy(this.linkEnterInternal, this));

    this.$el
        .on("click", ".ontime-scheduler-dataitem", $.proxy(this.itemClickInternal, this));


    this.$el.find(".ontime-scheduler-pane").on("scroll", $.proxy(this.handleScroll, this));

	this.$el.attr("data-layouttype", this.layoutType);

	this.timeoutHandleResize = 0;
	$(window).on("resize", $.proxy(this.handleResize, this));
};


ONTIME.Scheduler.prototype.linkClick = function (e) {
};

ONTIME.Scheduler.prototype.linkEnter = function (e) {
};

ONTIME.Scheduler.prototype.itemClick = function (e) {
};

ONTIME.Scheduler.prototype.linkClickInternal = function (e) {
    this.linkClick(e);
};

ONTIME.Scheduler.prototype.linkEnterInternal = function (e) {
    this.linkEnter(e);
};

ONTIME.Scheduler.prototype.itemClickInternal = function (e) {
    this.itemClick(e);
};


ONTIME.Scheduler.prototype.handleScroll = function(e) {
  this.$el.find(".ontime-scheduler-topheader").scrollLeft(
	$(e.currentTarget).scrollLeft());
  this.$el.find(".ontime-scheduler-leftheader").scrollTop(
	$(e.currentTarget).scrollTop());
};

ONTIME.Scheduler.prototype.handleResize = function () {
	if(this.timeoutHandleResize != 0) 
		clearTimeout(this.timeoutHandleResize);
	this.timeoutHandleResize = setTimeout($.proxy(this.handleResizePostpone, this), 100);
};

ONTIME.Scheduler.prototype.handleResizePostpone = function() {
  clearTimeout(this.timeoutHandleResize);
  this.timeoutHandleResize = 0;
  this.resizeAction();
};

ONTIME.Scheduler.prototype.resizeAction = function () {
//	this.resizeAction2();
//	this.resizeAction3();

    this.resizeAction5();


    this.resizeAction4();
    this.resizeAction3();
};


ONTIME.Scheduler.prototype.resizeAction2 = function() {
	if(!this.leftHeader.fixedSize && this.leftHeader.items.length > 0) {
	  var height = this.$el.find(".ontime-scheduler-pane")[0].clientHeight;
	  var heightExtra = height % this.leftHeader.items.length;
	  if(heightExtra  != 0) 
		this.$el.css("bottom", (parseInt(this.$el.css("bottom")) + heightExtra) % this.leftHeader.items.length);
	} else {
	  if (0 != parseInt(this.$el.css("bottom")))
		this.$el.css("bottom", 0);
	}

	if(!this.topHeader.fixedSize && this.topHeader.items.length > 0) {
	  var width = this.$el.find(".ontime-scheduler-pane")[0].clientWidth;
	  var widthExtra = width % this.topHeader.items.length;
	  if(widthExtra  != 0) 
		this.$el.css("right", (parseInt(this.$el.css("right")) + widthExtra) % this.topHeader.items.length);
	} else {
	  if (0 != parseInt(this.$el.css("right")))
		this.$el.css("right", 0);
	}
	
};

ONTIME.Scheduler.prototype.resizeAction3 = function () {
    var paneHeight = this.$el.find(".ontime-scheduler-pane").height();
    var gridHeight = this.$el.find(".ontime-scheduler-cellsgrid").height();
    this.$el.find(".ontime-scheduler-leftheader").css("bottom", (paneHeight - gridHeight));

    //var paneWidth = this.$el.find(".ontime-scheduler-pane").width();
    //var gridWidth = this.$el.find(".ontime-scheduler-cellsgrid").width();
    //this.$el.find(".ontime-scheduler-topheader").css("right", (paneWidth - gridWidth));
};


ONTIME.Scheduler.prototype.resizeAction5 = function () {
    if (window.innerWidth > window.innerHeight)
        this.$el.addClass("o-landscape").removeClass("o-portrait");
    else
        this.$el.addClass("o-portrait").removeClass("o-landscape");
};

ONTIME.Scheduler.prototype.resizeAction4 = function () {
    var epcw = 1; // elements per cell width

    if (!this.leftHeader.fixedSize && this.leftHeader.items.length > 0) {
        var height = this.$el.height();
        if (height > 0) {
            var heightHeader = this.$el.find(".ontime-scheduler-topheader").height();
            var heightExtra = (height - heightHeader) % this.leftHeader.items.length;
            var heightCell = ((height - heightHeader - heightExtra) / this.leftHeader.items.length) - 1; // cell includes border

            if (height > 0 && heightExtra >= 0) {
                this.$el.find(".ontime-scheduler-pane").css("margin-top", heightExtra + "px");
                this.$el.find(".ontime-scheduler-leftheader").css("margin-top", heightExtra + "px");
                this.$el.find(".ontime-scheduler-topheader").css("padding-bottom", heightExtra + "px");
                this.$el.find(".ontime-scheduler-corner").css("padding-bottom", heightExtra + "px");
            }

            if (!this.$el.find(".ontime-scheduler-pane").hasClass("layout-lock")) {
                var heightLine = this.$el.find(".ontime-text-measure")[0].offsetHeight - 1;
                var linesCount = (heightCell + 2) / heightLine; // include average padding

                var reservedLinesCount = 0;

                if (!this.$el.hasClass("ontime-no-caption-line") && this.$el.find(".aCaption").length > 0)
                    reservedLinesCount ++;

                if (this.$el.find(".aRemark").length > 0)
                    reservedLinesCount ++;

                if (linesCount >= (4 + reservedLinesCount)) { //4 lines + reserved caption
                    epcw = 1;
                    this.$el.find(".ontime-scheduler-pane")
                        .removeClass("layout-l1 layout-l2 layout-l3")
                        .addClass("layout-l4");
                } else if (linesCount >= (2 + reservedLinesCount)) { // 2 lines + reserved caption
                    epcw = 2;
                    this.$el.find(".ontime-scheduler-pane")
                        .removeClass("layout-l1 layout-l3 layout-l4")
                        .addClass("layout-l2");
                } else {
                    epcw = 4;
                    this.$el.find(".ontime-scheduler-pane")
                        .removeClass("layout-l2 layout-l3 layout-l4")
                        .addClass("layout-l1");
                }
            }
        }
    } else {
        this.$el.find(".ontime-scheduler-pane").css("margin-top", "0");
        this.$el.find(".ontime-scheduler-leftheader").css("margin-top", "0");
        this.$el.find(".ontime-scheduler-topheader").css("padding-bottom", "0");
        this.$el.find(".ontime-scheduler-corner").css("padding-bottom", "0");

        if (!this.$el.find(".ontime-scheduler-pane").hasClass("layout-lock")) {
            this.$el.find(".ontime-scheduler-pane")
            .removeClass("layout-l1 layout-l3 layout-l4")
            .addClass("layout-l2");
        }
    }

    var cwCss = ["layout-c0", "layout-c1", "layout-c2", "layout-c3", "layout-c4", "layout-c5", "layout-c6", "layout-c7", "layout-c8", "layout-c9"];
    var minElementWidth = this.$el.find(".ontime-text-measure").width() + 6;

    if (!this.topHeader.fixedSize && this.topHeader.items.length > 0) {

        var width = this.$el.width();
        if (width > 0) {
            var widthHeader = this.$el.find(".ontime-scheduler-leftheader").width();
            var widthExtra = ((width - widthHeader) % this.topHeader.items.length);
            var widthCell = ((width - widthHeader - widthExtra) / this.topHeader.items.length) - 1; // cell includes border


            if (width > 0 && widthExtra >= 0) {
                this.$el.find(".ontime-scheduler-pane").css("margin-left", widthExtra + "px");
                this.$el.find(".ontime-scheduler-topheader").css("margin-left", widthExtra + "px");
                this.$el.find(".ontime-scheduler-leftheader").css("padding-right", widthExtra + "px");
                this.$el.find(".ontime-scheduler-corner").css("padding-right", widthExtra + "px");
            }

            if (!this.$el.find(".ontime-scheduler-pane").hasClass("layout-lock")) {
                var cw = Math.floor(widthCell / (epcw * minElementWidth));

                if (cw > 9) cw = 9;
                if (cw < 1) cw = 1;


                var cwCssA = cwCss.slice(2, cw + 1);
                var cwCssR = cwCss.slice(cw + 1);

                this.$el.find(".ontime-scheduler-pane")
                    .removeClass(cwCssR.join(" "))
                    .addClass(cwCssA.join(" "));
            }
        }
    } else {
        this.$el.find(".ontime-scheduler-pane").css("margin-left", "0");
        this.$el.find(".ontime-scheduler-topheader").css("margin-left", "0");
        this.$el.find(".ontime-scheduler-leftheader").css("padding-right", "0");
        this.$el.find(".ontime-scheduler-corner").css("padding-right", "0");

        if (!this.$el.find(".ontime-scheduler-pane").hasClass("layout-lock")) {
            var cw = Math.floor(200 / (epcw * minElementWidth));

            if (cw > 9) cw = 9;
            if (cw < 1) cw = 1;

            var cwCssA = cwCss.slice(2, cw + 1);
            var cwCssR = cwCss.slice(cw + 1);

            this.$el.find(".ontime-scheduler-pane")
                .removeClass(cwCssR.join(" "))
                .addClass(cwCssA.join(" "));
        }
    }
}

ONTIME.Scheduler.prototype.clear = function() {
    for(var i=0; i<this.layers.length; i++) 
        this.layers[i].clear();
};



ONTIME.Scheduler.prototype.refresh = function() {
    this.clear();

    //this.$el.find(".ontime-scheduler-pane").scrollTop(0).scrollLeft(0);

    this.drawHeaders();
	
	for(var i=0; i<this.layers.length; i++) 
	    this.layers[i].refresh();
};

//ONTIME.Scheduler.CellLayout.h.getCellStyleSize
//ONTIME.Scheduler.CellLayout.v.getCellStyleSize

ONTIME.Scheduler.CellLayout = {
    h: {
        offsetCss: "left",
        sizeCss: "width",
        fixedSize: 200,
        getCellStyleSize: function (layoutStyle, c, i, s, f) {
            ONTIME.Scheduler.CellLayout.getCellStyleSizeCommon(layoutStyle, c, i, s, f, this);
        },
    },

    v: {
        offsetCss: "top",
        sizeCss: "height",
        fixedSize: 40,
        getCellStyleSize: function (layoutStyle, c, i, s, f) {
            ONTIME.Scheduler.CellLayout.getCellStyleSizeCommon(layoutStyle, c, i, s, f, this);
        },
    },

    getCellStyleSizeCommon: function (layoutStyle, c, i, s, f, hv) {
        if (f) {
            layoutStyle[hv.offsetCss] = ((i - 1) * hv.fixedSize) + "px";
            layoutStyle[hv.sizeCss] = (s * hv.fixedSize) + "px"
        } else {
            layoutStyle[hv.offsetCss] = ((i - 1) * 100 / c) + "%";
            layoutStyle[hv.sizeCss] = (s * 100 / c) + "%"
        }
    },
};

ONTIME.Scheduler.prototype.defaultHeaderBuilder = function(params, item, $header) {
    item.append('<span data-linkparam="' + params[1] + '">' + params[1] + '</span>');
  
    if($header.hasClass("ontime-scheduler-leftheader")) 
        item.attr("data-yi", params[0]);
    else if($header.hasClass("ontime-scheduler-topheader")) 
        item.attr("data-xi", params[0]);
};


ONTIME.Scheduler.prototype.drawHeaders = function () {
    var needResize = false;
    //needResize = true; // force to call resize handler

    //if (this.busy) return;
    this.busy = true;

    var $leftHeader = $(".ontime-scheduler-leftheader");
    var $topHeader = $(".ontime-scheduler-topheader");

    var leftHeaderItems = $leftHeader.find(".ontime-scheduler-headeritem");
    if (leftHeaderItems.length != this.leftHeader.items.length) {
        needResize = true;
    } else if (this.leftHeader.fixedSize == this.$el[0].hasAttribute("data-rc")) {
        needResize = true;  
    }


    var topHeaderItems = $topHeader.find(".ontime-scheduler-headeritem");
    if (topHeaderItems.length != this.topHeader.items.length) {
        needResize = true;
    } else if (this.topHeader.fixedSize == this.$el[0].hasAttribute("data-cc")) {
        needResize = true;
    }


    var masterItem = document.createElement("div");
    masterItem.classList.add("ontime-scheduler-headeritem");

    leftHeaderItems = [];
    for (var i = 0; i < this.leftHeader.items.length; i++) {
        var item = $(masterItem.cloneNode(false));

        // TODO: redesign
        this.leftHeader.builderCallback != null
          ? this.leftHeader.builderCallback.call(this, this.leftHeader.items[i], item, $leftHeader)
          : this.defaultHeaderBuilder.call(this, this.leftHeader.items[i], item, $leftHeader);

        var layoutStyle = {};
        ONTIME.Scheduler.CellLayout.v.getCellStyleSize(layoutStyle, this.leftHeader.items.length, this.leftHeader.items[i][0], 1, this.leftHeader.fixedSize);
        for (var xx in layoutStyle)
            item[0].style[xx] = layoutStyle[xx];

        leftHeaderItems.push(item);
    }



    topHeaderItems = [];

    for (var i = 0; i < this.topHeader.items.length; i++) {
        var item = $(masterItem.cloneNode(false));

        this.topHeader.builderCallback != null
          ? this.topHeader.builderCallback.call(this, this.topHeader.items[i], item, $topHeader)
          : this.defaultHeaderBuilder.call(this, this.topHeader.items[i], item, $topHeader);

        var layoutStyle = {};
        ONTIME.Scheduler.CellLayout.h.getCellStyleSize(layoutStyle, this.topHeader.items.length, this.topHeader.items[i][0], 1, this.topHeader.fixedSize);
        for (var xx in layoutStyle)
            item[0].style[xx] = layoutStyle[xx];

        topHeaderItems.push(item);
    }


    while ($leftHeader[0] && $leftHeader[0].firstChild)
        $leftHeader[0].removeChild($leftHeader[0].firstChild);
    while ($topHeader[0] && $topHeader[0].firstChild)
        $topHeader[0].removeChild($topHeader[0].firstChild);


    if (this.leftHeader.fixedSize) {
        this.$el.removeAttr("data-rc");
    } else {
        this.$el.css("height", "");
        this.$el.attr("data-rc", this.leftHeader.items.length);
    }

    if (this.topHeader.fixedSize) {
        this.$el.removeAttr("data-cc");
    } else {
        this.$el.css("width", "");
        this.$el.attr("data-cc", this.topHeader.items.length);
    }

    // TODO: optimize
    //if(needResize)
    //    ONTIME.Scheduler.prototype.handleResize.call(this);
    $topHeader.append(topHeaderItems);
    $leftHeader.append(leftHeaderItems);

    if (needResize)
        this.resizeAction();

    this.defineCells();

    this.busy = false;
};


ONTIME.Scheduler.prototype.cellBuilderCallback = function(x, y, item) {
};

ONTIME.Scheduler.prototype.clearCells = function () {
    var cellsGrid = this.$el.find(".ontime-scheduler-cellsgrid");
    while (cellsGrid[0].firstChild)
        cellsGrid[0].removeChild(cellsGrid[0].firstChild);
}

ONTIME.Scheduler.prototype.defineCells = function() {
    var cellsGrid = this.$el.find(".ontime-scheduler-cellsgrid");

    this.clearCells();
	var r = [];

    // TODO: R*C cells are simulated with crossing R horizontal + C vertical stripes with borders
	for (var x = 0; x < this.topHeader.items.length; x++) {
	    var layoutStyle = {};
	    ONTIME.Scheduler.CellLayout.h.getCellStyleSize(layoutStyle, this.topHeader.items.length, this.topHeader.items[x][0], 1, this.topHeader.fixedSize);

	    var borderStyle = "";
	    if (typeof this.topHeader.items[x][2] === "object" && typeof this.topHeader.items[x][2].color !== "undefined" && this.topHeader.items[x][2].color != "#FFFFFF") {
	        borderStyle = "border-right-color: " + this.topHeader.items[x][2].color + "; ";
	    }

	    r.push(('<div class="ontime-scheduler-item cellsgrig-v" \
            data-xi="' + this.topHeader.items[x][0] + '" \
            data-yi="1" \
            style="' + borderStyle + 'left: ' + layoutStyle["left"] + '; width: ' + layoutStyle["width"] + '; top: 0; height: 100%;" \
            ></div>'));
	}

	for (var y = 0; y < this.leftHeader.items.length; y++) {
	    var layoutStyle = {};
	    ONTIME.Scheduler.CellLayout.v.getCellStyleSize(layoutStyle, this.leftHeader.items.length, this.leftHeader.items[y][0], 1, this.leftHeader.fixedSize);
	    ONTIME.Scheduler.CellLayout.h.getCellStyleSize(layoutStyle, this.topHeader.items.length, this.topHeader.items[0][0], this.topHeader.items.length, this.topHeader.fixedSize);

	    var borderStyle = "";
	    if (typeof this.leftHeader.items[y][2] === "object" && typeof this.leftHeader.items[y][2].color !== "undefined" && this.leftHeader.items[y][2].color != "#FFFFFF") {
	        borderStyle = "border-bottom-color: " + this.leftHeader.items[y][2].color + "; ";
	    }

	    r.push(('<div class="ontime-scheduler-item cellsgrig-h" \
            data-xi="1" \
            data-yi="' + this.leftHeader.items[y][0] + '" \
            style="' + borderStyle + 'left: 0; width: ' + layoutStyle["width"] + '; top: ' + layoutStyle["top"] + '; height: ' + layoutStyle["height"] + ';" \
            ></div>'));
    }

	cellsGrid.append(r.join(""));
};


ONTIME.SchedulerInteractive = function (params) {
    ONTIME.Scheduler.call(this, params);

    this.$el
        .on("touchstart", ".klDropCell", $.proxy(this.handleTouchStart, this))
        .on("touchmove", ".klDropCell", $.proxy(this.handleTouchMove, this))
        .on("touchend", ".klDropCell", $.proxy(this.handleTouchEnd, this))
    ;

    this.$el
        .on("mousedown", ".klDropCell", $.proxy(this.handleTouchStart, this))
        .on("mousemove", ".klDropCell", $.proxy(this.handleTouchMove, this))
        .on("mouseup", ".klDropCell", $.proxy(this.handleTouchEnd, this))
    ;
};

// inherits
ONTIME.SchedulerInteractive.prototype = new ONTIME.Scheduler();

// overrides
ONTIME.SchedulerInteractive.prototype.clearCells = function () {
    ONTIME.Scheduler.prototype.clearCells.apply(this);

    var cellsGrid = this.$el.find(".ontime-scheduler-cells");
    while (cellsGrid[0].firstChild)
        cellsGrid[0].removeChild(cellsGrid[0].firstChild);
}

ONTIME.SchedulerInteractive.prototype.defineCells = function () {
    ONTIME.Scheduler.prototype.defineCells.apply(this);

    for (var x = 0; x < this.topHeader.items.length; x++) {
        for (var y = 0; y < this.leftHeader.items.length; y++) {
            var layoutStyle = {};
            ONTIME.Scheduler.CellLayout.h.getCellStyleSize(layoutStyle, this.topHeader.items.length, this.topHeader.items[x][0], 1, this.topHeader.fixedSize);
            ONTIME.Scheduler.CellLayout.v.getCellStyleSize(layoutStyle, this.leftHeader.items.length, this.leftHeader.items[y][0], 1, this.leftHeader.fixedSize);

            var itemFunc = $('<div class="ontime-scheduler-cell klDropCell" draggable_="true"></div>')
            itemFunc
                .css({
                    left: layoutStyle["left"],
                    width: layoutStyle["width"],
                    top: layoutStyle["top"],
                    height: layoutStyle["height"],
                })
                .attr("data-xi", this.topHeader.items[x][0])
                .attr("data-yi", this.leftHeader.items[y][0]);

            itemFunc.appendTo(this.$el.find(".ontime-scheduler-cells"));
        }
    }
};

ONTIME.SchedulerInteractive.prototype.assignWeightAndIndex = function () {
    for (var i = 0; i < this.layers.length; i++)
        this.layers[i].assignWeightAndIndex();
};

// implementation

// touch / mouse events handlers
ONTIME.SchedulerInteractive.prototype.handleTouchStart = function (e) {
    e.preventDefault();

    this.removeGhost();

    var dragStartCell = $(e.currentTarget);

    var o_xindex = parseInt(dragStartCell.attr("data-xi"));
    var o_yindex = parseInt(dragStartCell.attr("data-yi"));

    var coord = ONTIME.SchedulerInteractive.mapCoord(e.clientX, e.clientY, e.currentTarget, this.$el[0]);

    var dataItem = this.getDataItem({
        xindex: o_xindex,
        yindex: o_yindex,
        posx: coord.x,
        posy: coord.y,
        cell: e.currentTarget
    });

    if (dataItem.valid) {
        // mark cell started to drag
        dragStartCell.addClass("dragItem");
        dragStartCell.attr("data-id", dataItem.target.id);
        this.setGhostPos(o_xindex, o_yindex);
    }
};

ONTIME.SchedulerInteractive.prototype.handleTouchMove = function (e) {
    e.preventDefault();

    var coord = ONTIME.SchedulerInteractive.mapCoord(e.clientX, e.clientY, this.$el.find(".ontime-scheduler-cells")[0], this.$el[0]);
    var target = this.resolveDropCell(coord.x, coord.y);

    if (target.length > 0) {
        var t_xindex = parseInt(target.attr("data-xi"));
        var t_yindex = parseInt(target.attr("data-yi"));

        this.setGhostPos(t_xindex, t_yindex);
    }
};

ONTIME.SchedulerInteractive.prototype.handleTouchEnd = function (e) {
    e.preventDefault();

    var coord = ONTIME.SchedulerInteractive.mapCoord(e.clientX, e.clientY, this.$el.find(".ontime-scheduler-cells")[0], this.$el[0]);
    var foundDropCell = this.resolveDropCell(coord.x, coord.y);

    if (foundDropCell.length > 0) {
        var target = foundDropCell.first();
        var t_xindex = parseInt(target.attr("data-xi"));
        var t_yindex = parseInt(target.attr("data-yi"));

        var dragStartCell = $(".dragItem");
        if (dragStartCell.length > 0) {
            var id = dragStartCell.attr("data-id");

            if ((typeof id === "string") && id.length > 0) {
                var originalItem = $("#" + id + ":not(.ontime-scheduler-ghost)");
                if (this.onItemMove({
                    item: originalItem,
                    x: t_xindex,
                    y: t_yindex,
                })) {
                    this.removeGhost();
                    this.setItemPos(originalItem, t_xindex, t_yindex);
                }
            }
            $(".dragItem").removeClass("dragItem");
        } else {
            var dragStartSubject = $(".dragSubjectItem");
            if (dragStartSubject.length > 0) {
                if (!this.onItemAdd({
                    srcItem: dragStartSubject,
                    x: t_xindex,
                    y: t_yindex,
                })) {
                    this.removeGhost();
                }
            }

            $(".dragSubjectItem").removeClass("dragSubjectItem");
            this.setItemPos(this.getGhost().removeClass("ontime-scheduler-ghost mode-add mode-move"), t_xindex, t_yindex);
        }
    }
};

// external callbacks
ONTIME.SchedulerInteractive.prototype.onItemMove = function (e) {
    return true;
};

ONTIME.SchedulerInteractive.prototype.onItemAdd = function (e) {
    return true;
};

ONTIME.SchedulerInteractive.prototype.builtDragGhostItem = function (itemNode) {
    return false;
};



// mapping cell - data items
ONTIME.SchedulerInteractive.prototype.getDataItem = function (request) {
    var res = {
        valid: false,
        border: ""
    };

    var refItem = $('.ontime-scheduler-dataitem').filter(function (index, element) {
        var s_attr_yindex = parseInt(element.getAttribute("data-yi"));
        var s_attr_yspan = parseInt(element.getAttribute("data-ys"));
        var s_attr_xindex = parseInt(element.getAttribute("data-xi"));
        var s_attr_xspan = parseInt(element.getAttribute("data-xs"));

        return (
			s_attr_yindex <= request.yindex && (s_attr_yindex + s_attr_yspan) > request.yindex &&
			s_attr_xindex <= request.xindex && (s_attr_xindex + s_attr_xspan) > request.xindex);
    });

    for (var i = 0; i < refItem.length; i++) {
        var sharedPart = $(refItem[i]).children(".ontime-scheduler-itemsharedpart");
        var itemContent = sharedPart.children(".ontime-scheduler-itemcontent");
        var rc = {
            l: sharedPart[0].offsetLeft + itemContent[0].offsetLeft,
            t: sharedPart[0].offsetTop + itemContent[0].offsetTop,
            r: sharedPart[0].offsetLeft + itemContent[0].offsetLeft + itemContent[0].offsetWidth,
            b: sharedPart[0].offsetTop + itemContent[0].offsetTop + itemContent[0].offsetHeight
        };

        if (request.posx >= rc.l && request.posx < rc.r && request.posy >= rc.t && request.posy < rc.b) {
            res.valid = true;
            res.target = refItem[i];
            break;
        }
    }
    return res;
};

ONTIME.SchedulerInteractive.prototype.resolveDropCell = function (x, y) {
    var refItem = $(".klDropCell").filter(function (index, element) {
        return (
            element.offsetLeft < x && (element.offsetLeft + element.offsetWidth) >= x &&
            element.offsetTop < y && (element.offsetTop + element.offsetHeight) >= y
        );
    });

    return refItem.first();
}


// pointer position manipulation
ONTIME.SchedulerInteractive.getElementOffset = function (e) {
    var r = {
        x: 0,
        y: 0,
    };

    for (var el = e; el; el = el.offsetParent) {
        r.x += el.offsetLeft;
        r.y += el.offsetTop;
    }

    return r;
};

ONTIME.SchedulerInteractive.mapCoord = function (x, y, te, se) {
    var to = ONTIME.SchedulerInteractive.getElementOffset(te);
    var so = ONTIME.SchedulerInteractive.getElementOffset(se);

    var r = {
        x: x + so.x - to.x,
        y: y + so.y - to.y,
    };

    return r;
};


// ghost manipulation
ONTIME.SchedulerInteractive.prototype.createDragGhost = function () {
    var dragStartCell = $(".dragItem");
    if (dragStartCell.length > 0) {
        var id = dragStartCell.attr("data-id");
        var originalItem = $("#" + id + ".ontime-scheduler-dataitem");
        var ghost = originalItem.clone().addClass("ontime-scheduler-ghost mode-move ontime-scheduler-sametarget");

        this.$el.find(".ontime-scheduler-items-lessons").append(ghost);
        return ghost;
    } else {
        var ghost = $(ONTIME.SchedulerLayer.NodeTemplate);
        if (this.builtDragGhostItem(ghost)) {
            ghost.attr("id", this.layers[0].$el.children().length);
            ghost.addClass("ontime-scheduler-ghost mode-add");

            this.$el.find(".ontime-scheduler-items-lessons").append(ghost);
            return ghost;
        }
    }

    return null;
};

ONTIME.SchedulerInteractive.prototype.getGhost = function () {
    return this.$el.find(".ontime-scheduler-ghost");
};

ONTIME.SchedulerInteractive.prototype.removeGhost = function () {
    this.getGhost().remove();
    this.assignWeightAndIndex();
};

ONTIME.SchedulerInteractive.prototype.setItemPos = function (item, t_xindex, t_yindex) {
    var o_xspan = parseInt(item.attr("data-xs"));
    var o_yspan = parseInt(item.attr("data-ys"));

    var layoutStyle = {};
    ONTIME.Scheduler.CellLayout.h.getCellStyleSize(layoutStyle, this.topHeader.items.length, t_xindex, o_xspan, this.topHeader.fixedSize);
    ONTIME.Scheduler.CellLayout.v.getCellStyleSize(layoutStyle, this.leftHeader.items.length, t_yindex, o_xspan, this.leftHeader.fixedSize);

    item
        .attr({
            "data-xi": t_xindex,
            "data-yi": t_yindex,
        })
        .css({
            left: layoutStyle["left"],
            width: layoutStyle["width"],
            top: layoutStyle["top"],
            height: layoutStyle["height"],
        })
    ;

    this.assignWeightAndIndex();
};

ONTIME.SchedulerInteractive.prototype.setGhostPos = function (t_xindex, t_yindex) {
// TODO: ignore repeating calls with same params
    var ghost = this.getGhost();
    if (ghost.length == 0)
        ghost = this.createDragGhost();

    if (ghost !== null && ghost.length > 0) {

        var id = ghost.attr("id");

        var originalItem = $("#" + id + ".ontime-scheduler-dataitem:not(.ontime-scheduler-ghost)");
        if (originalItem.length > 0) {
            var o_xindex = parseInt(originalItem.attr("data-xi"));
            var o_yindex = parseInt(originalItem.attr("data-yi"));

            if (o_xindex == t_xindex && o_yindex == t_yindex)
                ghost.addClass("ontime-scheduler-sametarget");
            else
                ghost.removeClass("ontime-scheduler-sametarget");
        }

        this.setItemPos(ghost, t_xindex, t_yindex)
    }
};






