﻿// ONTIME namespace 
var ONTIME = ONTIME || {};

ONTIME.Profile = function () {
    this.callbacks = $.Callbacks("unique");

    this.order = [];
    this.src = [];

    // data is union/merge/override of src items using the order
    this.data = {};
};

ONTIME.Profile.prototype.setOrder = function (newOrder) {
    this.order = newOrder;

    this._sort();
    this._build();
};

ONTIME.Profile.prototype.getOrder = function () {
    return this.order;
};

ONTIME.Profile.prototype._notify = function () {
    this.callbacks.fire();
};

ONTIME.Profile.prototype._compareFunction = function (a, b) {
    return this.order.indexOf(a.k) - this.order.indexOf(b.k);
};

ONTIME.Profile.prototype._sort = function () {
    if(this.order.length > 0)
        this.src.sort($.proxy(this._compareFunction, this));
};

ONTIME.Profile.prototype._build = function () {
    this.data = {};

    for (var i = 0; i < this.src.length; i++) {
        var o = ((typeof this.src[i].v === "function") ? this.src[i].v() : this.src[i].v);
        jQuery.extend(true, this.data, o);
        if (typeof o._build === "function")
            jQuery.extend(true, this.data, o._build());
    }

    this._notify();
};

ONTIME.Profile.prototype.clear = function () {
    var _k = null;
    if (arguments.length > 0) {
        _k = arguments[0];
    }

    for (var i = 0; i < this.src.length; i++) {
        if (this.src[i].k === _k) {
            this.src.splice(i, 1);
            this._build();
            break;
        }
    }
};


ONTIME.Profile.prototype.replace = function (_k, _v) {
    var done = false;

    for (var i = 0; i < this.src.length; i++) {
        if (this.src[i].k === _k) {
            if (_v === null)
                this.src[i].v = _v;
            else {
                this.src[i].v = _v;
            }

            done = true;
            break;
        }
    }

    if (!done) {
        _v._p = this;
        this.src.push({
            k: _k,
            v: _v,
        });
        this._sort();
    }

    this._build();
};


ONTIME.Profile.prototype.set = function () {
    if (arguments.length > 0) {
        var done = false, _k = null, _v = null;

        if (arguments.length > 1) {
            _k = arguments[0];
            _v = arguments[1];
        } else {
            _v = arguments[0];
        }

        for (var i = 0; i < this.src.length; i++) {
            if (this.src[i].k === _k) {
                if (_v === null)
                    this.src[i].v = _v;
                else {
                    if (this.src[i].v === null)
                        this.src[i].v = {};

                    jQuery.extend(true, this.src[i].v, _v);
                }

                done = true;
                break;
            }
        }

        if (!done) {
            _v._p = this;
            this.src.push({
                k: _k,
                v: _v,
            });
            this._sort();
        }

        this._build();
    }
};

ONTIME.Profile.prototype.get = function (_k) {
    for (var i = 0; i < this.src.length; i++) {
        if (this.src[i].k === _k) {
            return this.src[i].v;
        }
    }
};

ONTIME.Profile.fromUri = function () {
    var r = {};

    var params = window.location.search.substr(1).split('&');

    for (var i = 0; i < params.length; i++) {
        var p = params[i].split('=');
        var k = p[0];
        var v = decodeURIComponent(p[1]);

        var ka = k.split(".");
        var va = v.split("|");
        if (va.length == 1)
            va = va[0];

        var x = r;
        for (var j = 0; j < ka.length; j++) {
            if ((j + 1) < ka.length && typeof x[ka[j]] !== "object")
                x[ka[j]] = {};
            else if ((j + 1) == ka.length)
                x[ka[j]] = va;

            x = x[ka[j]];
        }
    }

    return r;
};
