// ONTIME namespace 
var ONTIME = ONTIME || {};


// Floorplan collects floors, buildings,etc
ONTIME.Floorplan = function(params) {
	this.items = [];
	this.filterParams = {};
	
	this.floors = [];
	
	$.extend(this, params);
};


ONTIME.Floorplan.prototype.clearGraphics = function () {
    for(var i=0; i<this.floors.length; i++) 
        this.floors[i].clearGraphics();
};

ONTIME.Floorplan.prototype.drawGraphics = function () {
    for(var i=0; i<this.floors.length; i++) 
        this.floors[i].drawGraphics();
};

ONTIME.Floorplan.prototype.assignFillColor = function (rooms) {
    for (var i = 0; i < this.floors.length; i++)
        this.floors[i].assignFillColor(rooms);
};

ONTIME.Floorplan.prototype.getItems = function() {
	return [];
};

ONTIME.Floorplan.prototype.filterItem = function(item, filterParams, stage) {
	return true;
};

ONTIME.Floorplan.prototype.translateItem = function(item, translatedItem) {
	return false;
};


ONTIME.Floorplan.prototype.ungroupItem = function(item) {
	return [item];
};

ONTIME.Floorplan.prototype.roomClick = function (e) {
}

ONTIME.Floorplan.prototype.refresh = function () {
	this.items = [];
	var items = this.getItems();
	if((typeof items === "object") && (typeof items.length !=="undefined")) {
		for(var i=0; i<items.length; i++) {
			if(this.filterItem(items[i], this.filterParams, 1)) {
				var uItems = this.ungroupItem(items[i]);
				for(var j=0; j<uItems.length; j++) {
					if(uItems.length == 1 || this.filterItem(uItems[j], this.filterParams, 2)) {
						this.items.push(uItems[j]);
					}
				}
			}
		}
	}
}


// Floor class
ONTIME.Floor = function(params) {
	this.index = -1;
	this.el = null;
	this.plan = null;
	this.svgDoc = null;
	
	$.extend(this, params);
	
	this.$el = $(this.el);
	
	this.$el.on("click", "text, path", $.proxy(this.roomClick, this));
	
	$.ajax({
		url: this.src,
		dataType: "text",
		cache: true,
	}).done($.proxy(this.onLoad, this));
};

ONTIME.Floor.prototype.onLoad = function (data) {
    var svgDoc = $(data).filter("svg");
    var definedLevel = svgDoc.find((this.definition || {}).selector || ('g[inkscape\\:label="' + this.index + '"]'));
    svgDoc.children('g').not(definedLevel).empty();

	svgDoc.find('#floorIdLabel tspan').text(this.title || "");
	svgDoc.find('path[inkscape\\:label^="Room\\:"]')
    .css({
	    "fill": "",
	    "stroke": "", 
	    "stroke-width": "",
	    "stroke-miterlimit": "",
	    "stroke-dasharray": "",
        "stroke-dashoffset": "",
	    "stroke-opacity": ""
        }).removeAttr("inkscape:connector-curvature sodipodi:nodetypes");

    definedLevel.css("opacity", 1).show();
    this.svgDoc = svgDoc[0];
    //this.$el.append($('<div class="floorplan-svg-container"></div>').append(svgDoc));
    this.$el.append(svgDoc);
}


ONTIME.Floor.prototype.clearGraphics = function () {
	this.setRoomText("Room:", [], false);
	this.setRoomFlag("Room:", 0, false);
}

ONTIME.Floor.prototype.drawGraphics = function() {
	for(var i=0; i<this.plan.items.length; i++) {
	    if(this.plan.filterItem(this.plan.items[i], this.plan.filterParams, 3)) {
	        // TODO: pass floor as param to filter callback
	        var translatedItem = {};
	        
	        if(this.plan.translateItem(this.plan.items[i], translatedItem)) {
				this.setRoomFlag("Room:" + translatedItem.room, translatedItem.flag, true);
				this.setRoomText("Room:" + translatedItem.room, translatedItem.text, true);
			}
	    }
	}
}

ONTIME.Floor.prototype.assignFillColor = function (rooms) {
    for(var i=0; i<rooms.length; i++) {
        if (rooms[i].color !== undefined) {
            this.setRoomColor("Room:" + rooms[i].code, rooms[i].color);
        }
    };
}


ONTIME.Floor.prototype.roomClick = function (e) {
	var label = e.target.getAttribute("inkscape:label");
	if(typeof label === "string" && label.search("Room:")>=0) 
		this.plan.roomClick.call(this, e);
}


ONTIME.Floor.prototype.setNodeFlag = function (p, f) {
	p.setAttribute("data-occupied", f);
}

ONTIME.Floor.prototype.setRoomFlag = function (r, f, m) {
	if (this.svgDoc == null) return;
	
	var coll = this.svgDoc.getElementsByTagName("text");
	for(var i=0; i<coll.length; i++) {
		var label = coll[i].getAttribute("inkscape:label");
		if(label != null && label.indexOf("Room:")>=0 && (label.indexOf(r)>=0 && (!m || label == r))) 
			this.setNodeFlag(coll[i], f);
	}
	coll = this.svgDoc.getElementsByTagName("path");
	for(var i=0; i<coll.length; i++) {
		var label = coll[i].getAttribute("inkscape:label");
		if(label != null && label.indexOf("Room:")>=0 && (label.indexOf(r)>=0 && (!m || label == r))) 
			this.setNodeFlag(coll[i], f);
	}
}

ONTIME.Floor.prototype.setRoomColor = function (r, c) {
    if (this.svgDoc == null) return;

    var coll = this.svgDoc.getElementsByTagName("path");
    for (var i = 0; i < coll.length; i++) {
        var label = coll[i].getAttribute("inkscape:label");
        if (label != null && label.indexOf("Room:") >= 0 && (label.indexOf(r) >= 0 && (label == r)))
            coll[i].style["fill"] = c;
    }
}




ONTIME.Floor.prototype.setNodeText = function (p, t) {
	if(p.childNodes.length>0) {    
		// remove extra spans    
	    for(var j=p.childNodes.length-1; j>0; j--) 
	      p.removeChild(p.childNodes[j]);
	    
		if(t.length>0) {    
		    var n = p.childNodes[0];
		    n.setAttribute("x", p.getAttribute("x"));
		    
		    
		    if(t.length>0) {    
			    // use the first span as template
			    var c = n.cloneNode();
			    c.removeAttribute("y");
			    c.setAttribute("dy", "1.2em");
		    
				for(var j=0; j<t.length; j++) {
					var c1 = c.cloneNode();
				    c1.textContent = t[j];
				    p.appendChild(c1);
				}
			}
		}
	}
}

ONTIME.Floor.prototype.setRoomText = function (r, t, m) {
	if (this.svgDoc == null) return;
	
	var coll = this.svgDoc.getElementsByTagName("text");
	for(var i=0; i<coll.length; i++) {
		var label = coll[i].getAttribute("inkscape:label");
		if(label != null && label.indexOf("Room:")>=0 && (label.indexOf(r)>=0 && (!m || label == r))) {
			this.setNodeText(coll[i], t);
		}
	}
}