﻿$.fn.flipFlexItems = function (params) {
    function onFlipItems(e) {
        with (e.data) {
            if (itemCount > pageSize) {

                flexItems.slice(startNo, endNo).fadeOut(500);

                // set new values for startNo and endNo
                if (endNo >= itemCount) {
                    startNo = 0;
                    endNo = pageSize;
                    pageNo = 1;
                } else {
                    startNo = endNo;
                    if ((endNo + pageSize) > itemCount) endNo = itemCount;
                    else endNo += pageSize;
                    pageNo++;
                }

                $(this).trigger("flipitemsnotify", e.data);

                // next startNo...endNo show with fadeIn
                if (!contentReloadPending) {
                    flexItems
                        .slice(startNo, endNo)
                        .delay(500)
                        .fadeIn(500);
                }
            } else {
                $(this).trigger("flipitemsnotify", e.data);
            }
        }
    };

    $(this).off("flipitems");

    var flexItems = $(this).children();
    var o = {
        flexItems: flexItems,
        itemCount: flexItems.length,
        pageNo: 1,
        pageCount: Math.ceil(flexItems.length / params.pageSize),
        startNo: 0,
        endNo: params.pageSize,
        contentReloadPending: false,
    };

    if (o.itemCount > params.pageSize) {
        flexItems.slice(0).hide();
        flexItems.slice(o.startNo, o.endNo).fadeIn();
    }

    $.extend(true, params, o);

    $(this).trigger("flipitemsnotify", $.extend({}, params, {init: true}));
    $(this).on("flipitems", params, onFlipItems);
};