// ONTIME namespace 
var ONTIME = window.ONTIME || (window.ONTIME = {});



// DateTime class
ONTIME.Date = function() {
	this.base = new (Date.bind.apply(Date, [Date].concat(Array.prototype.slice.call(arguments, 0))))();
	
	if(typeof ONTIME.Date.prototype["proto_cloned"] === "undefined") {
		ONTIME.Date.prototype["proto_cloned"] = true;
		
		var getMethods = [
			"getDate",
			"getDay",
			"getFullYear",
			"getHours",
			"getMilliseconds",
			"getMinutes",
			"getMonth",
			"getSeconds",
			"getTime",
			"getTimezoneOffset",
			"getUTCDate",
			"getUTCDay",
			"getUTCFullYear",
			"getUTCHours",
			"getUTCMilliseconds",
			"getUTCMinutes",
			"getUTCMonth",
			"getUTCSeconds",
			"getYear",
			"UTC",
			
			"toDateString",
			"toGMTString",
			"toISOString",
			"toJSON",
			"toLocaleDateString",
			"toLocaleTimeString",
			"toLocaleString",
			"toString",
			"toTimeString",
			"toUTCString",
			"valueOf",
		];
		
		var setMethods = [
			"setDate",
			"setFullYear",
			"setHours",
			"setMilliseconds",
			"setMinutes",
			"setMonth",
			"setSeconds",
			"setTime",
			"setUTCDate",
			"setUTCFullYear",
			"setUTCHours",
			"setUTCMilliseconds",
			"setUTCMinutes",
			"setUTCMonth",
			"setUTCSeconds",
			"setYear",
		];
		
		getMethods.forEach(function (e, i, a){
			ONTIME.Date.prototype[e] = function() {
				return this.base[e]();
			}
		});
		setMethods.forEach(function (e, i, a){
			ONTIME.Date.prototype[e] = function(p) {
				return this.base[e](p);
			}
		});
	}
	
};


ONTIME.Date.UTC = function() {
	return Date.UTC.apply(null, arguments);
}

ONTIME.Date.parse = function(s) {
	var r = null;
	
	if (arguments.length==2) {
		var fmt = arguments[1];
		if (fmt.toUpperCase() == "YYYYMMDDHHMMSS") {
			r = new ONTIME.Date(
				s.substr(0, 4),
				parseInt(s.substr(4, 2))-1,
				s.substr(6, 2),
				s.substr(8, 2), 
				s.substr(10, 2), 
				s.substr(12, 2), 
				0
			);
		} else if (fmt.toUpperCase() == "YYYYMMDDHHMM") {
			r = new ONTIME.Date(
				s.substr(0, 4),
				parseInt(s.substr(4, 2))-1,
				s.substr(6, 2),
				s.substr(8, 2), 
				s.substr(10, 2), 
				0, 0
			);
		} else if (fmt.toUpperCase() == "YYYYMMDD") {
			r = new ONTIME.Date(
				s.substr(0, 4),
				parseInt(s.substr(4, 2))-1,
				s.substr(6, 2),
				0, 0, 0, 0
			);
		} else if (fmt.toUpperCase() == "HHMM") {
			r = new ONTIME.Date();
			r.setHours(s.substr(0, 2));
			r.setMinutes(s.substr(2, 2));
			r.setSeconds(0);
		}
	}
	
	if (r == null && arguments.length==1 && typeof s !== "undefined" && s.length==8)
		r = ONTIME.Date.parse(s, "YYYYMMDD");
	
	if (r == null && arguments.length==1)
		r = Date.parse(s);
	
	return r;
}

ONTIME.Date.diff = function(d1, d2, fmt) {
	if(typeof fmt === "undefined") 
		fmt = "YYYYMMDD";
	if(typeof d1 === "string")
		d1 = ONTIME.Date.parse(d1, fmt);
	if(typeof d2 === "string")
		d2 = ONTIME.Date.parse(d2, fmt);
		
	return Math.ceil((d2.getTime()-d1.getTime()) / (1000 * 60 * 60 * 24));
}


ONTIME.Date._formatPostprocessFunctions = {
    _pad2: function (i) {
        var r = i.toString();
        if (r.length<2) 
            r = ("00").substr(2-r.length) + r;
        return r;
    },
    _h12: function (i) {
        return (i == 0 || i == 12)
            ? 12
            : (i%12);
    },
    _inc: function (i) {
        return i+1;
    },
    _cut2: function (i) {
        var r = i.toString();
        if (r.length > 2)
            r = r.substr(r.length-2);
        return r;
    }
};

ONTIME.Date._formatTokens = [
		[["HH"], "getHours", ONTIME.Date._formatPostprocessFunctions._pad2],
		[["H"], "getHours"],
		[["hh"], "getHours", ONTIME.Date._formatPostprocessFunctions._h12, ONTIME.Date._formatPostprocessFunctions._pad2],
		[["h"], "getHours", ONTIME.Date._formatPostprocessFunctions._h12],
		[["mm"], "getMinutes", ONTIME.Date._formatPostprocessFunctions._pad2],
		[["m"], "getMinutes"],
		[["ss", "SS"], "getSeconds", ONTIME.Date._formatPostprocessFunctions._pad2],
		[["s", "S"], "getSeconds"],
		[["MM"], "getMonth", ONTIME.Date._formatPostprocessFunctions._inc, ONTIME.Date._formatPostprocessFunctions._pad2],
		[["M"], "getMonth", ONTIME.Date._formatPostprocessFunctions._inc],
		[["DD", "dd"], "getDate", ONTIME.Date._formatPostprocessFunctions._pad2],
		[["D", "d"], "getDate"],
		[["YYYY", "yyyy"], "getFullYear"],
		[["WYYY", "wyyy"], "getWeekNumberYear"],
		[["YY", "yy"], "getFullYear", ONTIME.Date._formatPostprocessFunctions._cut2],
		[["WY", "wy"], "getWeekNumberYear", ONTIME.Date._formatPostprocessFunctions._cut2],
		[["WW", "ww"], "getWeekNumber", ONTIME.Date._formatPostprocessFunctions._pad2],
		[["W", "w"], "getWeekNumber"],
];

ONTIME.Date.prototype.qformatYYYYMMDD = function () {
    var y = String(this.getFullYear());

    var m = this.getMonth() + 1;
    if (m < 10)
        m = "0" + m;
    var d = this.getDate();
    if (d < 10)
        d = "0" + d;
    return y + m + d;
}
ONTIME.Date.prototype.qformatYYYY = function () {
    return String(this.getFullYear());
}

ONTIME.Date.prototype.format = function(fmt) {
    if (typeof fmt === "undefined" || fmt == "YYYYMMDD") {
        return this.qformatYYYYMMDD();
    } else if (fmt == "YYYY" || fmt == "yyyy") {
        return this.qformatYYYY();
    } else {
        var r = fmt;

        for (var i = 0; i < ONTIME.Date._formatTokens.length; i++) {
            for (var j = 0; j < ONTIME.Date._formatTokens[i][0].length; j++) {
                while (r.search(ONTIME.Date._formatTokens[i][0][j]) >= 0) {
                    var s = this[ONTIME.Date._formatTokens[i][1]]();
                    for (var k = 2; k < ONTIME.Date._formatTokens[i].length; k++)
                        s = ONTIME.Date._formatTokens[i][k](s);
                    r = r.replace(ONTIME.Date._formatTokens[i][0][j], s);
                }
            }
        }

        return r;
    }
};

ONTIME.Date.BEGIN_OF_PERIOD = ["D", "W", "Q", "M", "Y"];
ONTIME.Date.prototype.getBeginOf = function(beginOfPeriod) {
	var r = new ONTIME.Date();
	r.setTime(this.getTime());
	
	switch (ONTIME.Date.BEGIN_OF_PERIOD.indexOf(beginOfPeriod.toUpperCase())) {
	    case 0:
	        r.setHours(0);
	        r.setMinutes(0);
	        r.setSeconds(0);
	        r.setMilliseconds(0);
	        break;
	    case 1:
			var day = r.getDay();
			if(day == 0) day = 7;
			r.setDate(r.getDate()+1-day);
			break;
	    case 2:
	        var m = r.getMonth();
	        m = m - m % 3;
	        r.setDate(1);
	        r.setMonth(m);
	        break;
	    case 3:
			r.setDate(1);
			break;
		case 4:
			r.setDate(1);
			r.setMonth(0);
			break;
	}
	return r;
}

ONTIME.Date.prototype.getWeekNumber = function () {// ISO 8601 WkNo. 
    var ms1d = 864e5, ms7d = 7 * ms1d
    var DC3 = Date.UTC(this.getFullYear(), this.getMonth(), this.getDate() + 3) / ms1d // an Absolute Day Number
    var AWN = Math.floor(DC3 / 7) // an Absolute Week Number
    var Wyr = new Date(AWN * ms7d).getUTCFullYear()
    return AWN - Math.floor(Date.UTC(Wyr, 0, 7) / ms7d) + 1;
}

ONTIME.Date.prototype.getWeekNumberYear = function () {// ISO 8601 WkNo. Year for WeekNumber
    var ms1d = 864e5, ms7d = 7 * ms1d
    var DC3 = Date.UTC(this.getFullYear(), this.getMonth(), this.getDate() + 3) / ms1d // an Absolute Day Number
    var AWN = Math.floor(DC3 / 7) // an Absolute Week Number
    var Wyr = new Date(AWN * ms7d).getUTCFullYear()
    return Wyr;
}


ONTIME.Date.OFFSET_PERIOD = ["D", "M", "Q", "Y", "H", "MI", "S", "MS"];
ONTIME.Date.prototype.offset = function(c, p) {
	if(typeof p === "undefined")
		p = "d";
	switch (ONTIME.Date.OFFSET_PERIOD.indexOf(p.toUpperCase())) {
		case 0: // D
			this.setDate(this.getDate()+c);
			break;
		case 1: // M
			this.setMonth(this.getMonth()+c);
			break;
	    case 2: // M
	        this.setMonth(this.getMonth() + c*3);
	        break;
	    case 3: // Y
			this.setFullYear(this.getFullYear()+c);
			break;
	    case 4: // H
	        this.setHours(this.getHours() + c);
	        break;
	    case 5: // MI
	        this.setMinutes(this.getMinutes() + c);
	        break;
	    case 6: // S
	        this.setSeconds(this.getSeconds() + c);
	        break;
	    case 7: // MS
	        this.setMilliseconds(this.getMilliseconds() + c);
	        break;
	}
	return this;
}


ONTIME.Date.prototype.clone = function() {
	var r = new ONTIME.Date();
	r.setTime(this.getTime());
	return r;
}

