﻿// ONTIME namespace 
var ONTIME = ONTIME || {};

ONTIME.CalendarMonth = function (params) {
    this.el = null;

    this.rangeBegin = (new ONTIME.Date()).getBeginOf("M");
    this.rangeEnd = this.rangeBegin.clone().offset(1, "M").offset(-1, "D");

    $.extend(this, params);

    this.$el = $(this.el);

    this.$el.on("click", ".cal-body .cal-day", $.proxy(this.dayClickInternal, this))
    this.$el.on("click", ".cal-monthheader, .cal-body", $.proxy(this.monthClickInternal, this))

    this.drawHeader();
    this.refresh();
};

ONTIME.CalendarMonth.MONTH_TEMPLATE = '<div class="cal-month"><div class="cal-monthheader"></div><div class="cal-header"></div><div class="cal-body"></div></div>';
ONTIME.CalendarMonth.WEEK_TEMPLATE = '<div class="cal-week"></div>';
ONTIME.CalendarMonth.DAY_TEMPLATE = '<div class="cal-day"><div class="cal-daypad"><div class="cal-content"></div></div></div>';
ONTIME.CalendarMonth.DAY_TEMPLATE_OUT_OF_RANGE = '<div class="cal-day date-range="out"><div class="cal-daypad"><div class="cal-content"></div></div></div>';

ONTIME.CalendarMonth.createRuntime = function (params) {
    var el = ONTIME.CalendarMonth.generateDomNode();
    el.attr(params.attr);

    var p = {};
    $.extend(true, p, params);
    p.el = el;

    return new ONTIME.CalendarMonth(p);
};

ONTIME.CalendarMonth.generateDomNode = function () {
    return $(ONTIME.CalendarMonth.MONTH_TEMPLATE);
};

ONTIME.CalendarMonth.prototype.dayClickInternal = function (e) {
    this.dayClick(e);
};
ONTIME.CalendarMonth.prototype.dayClick = function (e) {
};

ONTIME.CalendarMonth.prototype.monthClickInternal = function (e) {
    this.monthClick(e);
};
ONTIME.CalendarMonth.prototype.monthClick = function (e) {
};

ONTIME.CalendarMonth.prototype.drawHeader = function () {
    var wh = this.$el.find('.cal-header');
    wh.empty();
    var whw = $(ONTIME.CalendarMonth.WEEK_TEMPLATE);
    [1, 2, 3, 4, 5, 6, 0].forEach(function (e) {
        var r = $(ONTIME.CalendarMonth.DAY_TEMPLATE);
        r.attr("data-wday", e);
        whw.append(r);
    });
    wh.append(whw);

    var mh = this.$el.find('.cal-monthheader');
    mh.attr({
        "data-y": this.rangeBegin.getFullYear(),
        "data-m": this.rangeBegin.getMonth(),
    });

    this.setTitleContent(mh);
};

ONTIME.CalendarMonth.prototype.clear = function () {
    this.$el.find('.cal-body').empty();
};

ONTIME.CalendarMonth.prototype.refresh = function () {
    this.clear();
    this.processRange();
};

ONTIME.CalendarMonth.prototype.setTitleContent = function (mh) {
    var title = this.getTitleText();
    if (typeof title === "string" && title != "") {
        mh
            .attr("data-customcontent", "")
            .text(title);
    }
};

ONTIME.CalendarMonth.prototype.getTitleText = function () {
    //return this.rangeBegin.format("M 'YYYY")
    return "";
};

ONTIME.CalendarMonth.prototype.getRange = function () {
    return {
        rangeBegin: this.rangeBegin,
        rangeEnd: this.rangeEnd
    };
};

ONTIME.CalendarMonth.prototype.getExtendedRange = function () {
    var range = this.getRange();

    return {
        rangeBegin: range.rangeBegin.getBeginOf("W"),
        rangeEnd: range.rangeEnd.getBeginOf("W").offset(7, "D")
    };
};

ONTIME.CalendarMonth.prototype.processRange = function (range) {
    var range = this.getRange();
    var extendedRange = this.getExtendedRange();
    var today = (new ONTIME.Date()).format("YYYYMMDD");

    var item = extendedRange.rangeBegin;

    var weekDomItems = [];

    for (var i = 0; i < 6; i++) {
        var weekAttr = {
            "data-wn": item.format("W"),
            "data-wb": item.format("YYYYMMDD"),
        };

        var dayDomNodes = [];
        for (j = 0; j < 7; j++) {
            var inRange = (item.getTime() >= range.rangeBegin.getTime() && item.getTime() <= range.rangeEnd.getTime());
            dayDomNodes.push(this.buildItem(item, inRange, today));
            item.offset(1, "D");
        }

        weekDomItems[i] = 
            $(ONTIME.CalendarMonth.WEEK_TEMPLATE)
                .attr(weekAttr)
                .append(dayDomNodes);
            
    }

    this.$el.find('.cal-body').append(weekDomItems);
};

ONTIME.CalendarMonth.prototype.processRangeItem = function (item, inRange, today, weekDomItem) {
    this.pushItem(this.buildItem(item, inRange, today), item, weekDomItem);
};



ONTIME.CalendarMonth.prototype.buildItem = function (item, inRange, today) {
    var r = $(ONTIME.CalendarMonth.DAY_TEMPLATE);

    var day = item.format();

    r.attr({
        "data-wday": item.getDay(),
        "data-date": day,
        "data-range": inRange?"in":"out",
    });

    this.setItemContent(r, item, inRange, today);

    return r;
};

ONTIME.CalendarMonth.markDayAsPastTodayFuture = function () {
    var today = (new ONTIME.Date()).format();

    $(".cal-day").each(function () {
        var d = $(this).attr("data-date");
        if(d<today)
            $(this)
                .attr("data-past", "")
                .removeAttr("data-today")
                .removeAttr("data-future")
            ;
        else if(d>today)
            $(this)
                .attr("data-future", "")
                .removeAttr("data-today")
                .removeAttr("data-past")
            ;
        else 
            $(this)
                .attr("data-today", "")
                .removeAttr("data-past")
                .removeAttr("data-future")
            ;
    });
}

ONTIME.CalendarMonth.prototype.setItemContent = function (domItem, item, inRange, today) {
    domItem.find(".cal-content").attr("data-day", item.getDate());

    var title = this.getItemText(item, inRange, today);
    if (typeof title === "string" && title != "")
        domItem.find(".cal-content")
            .attr("data-customcontent", "")
            .text(title);
}

ONTIME.CalendarMonth.prototype.getItemText = function (item, inRange, today) {
    //return item.format("DD");
    return "";
};

ONTIME.CalendarMonth.prototype.pushItem = function (dayDomItem, item, weekDomItem) {
    weekDomItem.append(dayDomItem);
    //var wb = item.getBeginOf("W").format("YYYYMMDD");
    //this.$el.find('.cal-body .cal-week[data-wb="' + wb + '"]').append(dayDomItem);
};