﻿// ONTIME namespace 
// requires: enbrea.fs.js
var ONTIME = ONTIME || {};

ONTIME.StorageItem = function (params, flags) {
    this.callbacks = $.Callbacks(flags || "unique");

    this.name = "";
    this.data = {};

    $.extend(this, params);
};

ONTIME.StorageItem.prototype.parse = JSON.parse;
ONTIME.StorageItem.prototype.serialize = JSON.stringify;

ONTIME.StorageItem.prototype.convert = function (dfd) {
    var self = this;

    var Fs = new ONTIME.Fs();
    Fs.init()
        .done(function () {
            Fs.fs.root.getFile(self.name, {},
                function (fileEntry) {
                    fileEntry.file(
                        function (file) {
                            (new ONTIME.FsReader())
                                .readAsText(file)
                                .done(function (data) {
                                    console.log("read old succeeded: " + (fileEntry.nativeURL) + self.name);

                                    // relocate to new
                                    self.data = self.parse(data);
                                    self.save();

                                    self.notify();
                                    dfd.resolve();

                                    fileEntry.remove();
                                })
                                .fail(function (error) {
                                    dfd.reject(error);
                                });
                        },
                        function (error) {
                            dfd.reject(error);
                        }
                    );
                },
                function (e) {
                    dfd.reject(e);
                }
            );
        })
        .fail(function () {
            dfd.reject(e);
        });

        
    return dfd;
}

ONTIME.StorageItem.prototype.load = function () {
    var self = this;
    var dfd = new jQuery.Deferred();

    console.log("reading: " + (this.path || "") + this.name);

    ONTIME.Fs.readFile((this.path || ""), this.name)
        .done(function (data) {
            console.log("read succeeded: " + (self.path || "") + self.name);
            self.data = self.parse(data);
            self.notify();
            dfd.resolve();
        })
        .fail(function (e) {
            //console.log("read failed: " + (self.path || "") + self.name);
            //self.notify();
            //dfd.reject(e);

            // try to read from old location

            
            self.convert(dfd)
                .fail(function () {
                    console.log("read failed: " + (self.path || "") + self.name);
                    self.notify();
                });
            
        });

    return dfd.promise();
};

ONTIME.StorageItem.prototype.save = function (data) {
    var self = this;
    console.log("writing: " + (this.path || "") + this.name);
    return (ONTIME.Fs.writeFile((this.path || ""), this.name, this.serialize(data || this.data))
        .done(function () {
            console.log("write succeeded: " + (self.path || "") + self.name);
        })
        .fail(function () {
            console.log("write failed: " + (self.path || "") + self.name);
        }));
};

ONTIME.StorageItem.prototype.notify = function () {
    this.callbacks.fire();
};

