﻿function getNowData(refDate, refTime, targetGroup, pageSize) {
    var r = [];
    var dataNow = [];

    var lessonCriteriaMap = {
        "classes": "classCodes",
        "teachers": "teacherCodes",
        "rooms": "roomCodes"
    };

    var lessonCriteria = lessonCriteriaMap[targetGroup] || "";

    with (data.result.displaySchedule) {
        if (lessonCriteria != "" && typeof lessonTimes === "object" && typeof data.result[targetGroup] === "object") {
            for (var i = 0; i < lessonTimes.length; i++) {
                if (
                    lessonTimes[i].endTime >= refTime &&
                    typeof lessonTimes[i].dates === "object" && lessonTimes[i].dates.length > 0 && lessonTimes[i].dates.indexOf(refDate) >= 0 &&
                    typeof lessonTimes[i][lessonCriteria] === "object" 
                    && checkDataItemProperty(lessonTimes[i].buildingCodes, currentProfile.data.filter.bu, 1)
                    && checkDataItemProperty(lessonTimes[i].teacherCodes, currentProfile.data.filter.te, 1)
                    && checkDataItemProperty(lessonTimes[i].classCodes, currentProfile.data.filter.cl, 1)
                    && checkDataItemProperty(lessonTimes[i].roomCodes, currentProfile.data.filter.ro, 1)
                    && checkDataItemProperty(lessonTimes[i].teamCodes, currentProfile.data.filter.team, 1)
                ) {
                    for (var j = 0; j < lessonTimes[i][lessonCriteria].length; j++) {
                        var k = arrayLookup(data.result[targetGroup], lessonTimes[i][lessonCriteria][j], "code");
                        if (k != -1) {

                            if (typeof dataNow[k] !== "object")
                                dataNow[k] = [i];
                            else {
                                var skip = false;
								if(currentProfile.data.nowScope === "actual") {
									for (var l = dataNow[k].length - 1; l >= 0 ; l--) {
										if (lessonTimes[i].startTime > lessonTimes[dataNow[k][l]].startTime) {
											// there are better candidates already saved
											skip = true;
											break;
										} else if (
											lessonTimes[dataNow[k][l]].startTime > refTime && // saved candidate is not yet started
											lessonTimes[i].startTime < lessonTimes[dataNow[k][l]].startTime // new candidate is earlier that saved one => better
											) {
											dataNow[k].splice(l, 1);
										}
									}
								}
                                if(!skip)
                                    dataNow[k].push(i);
                            }
                        }
                    }
                }
            }

            for (var i = 0; i < data.result[targetGroup].length; i++) {
                if (typeof dataNow[i] === "object") {
					dataNow[i].sort(function(a,b){
						return lessonTimes[a].startTime.localeCompare(lessonTimes[b].startTime);
					});
                    for (var j = 0; j < dataNow[i].length; j++) {
                        var o = {};
                        $.extend(true, o, lessonTimes[dataNow[i][j]]);
                        o[lessonCriteria] = [data.result[targetGroup][i].code];
                        
                        r.push(o);
                    }
                }
            }
        } else {
            // no target group specified - sort by time
            for (var i = 0; i < lessonTimes.length; i++) {
                if (
                    lessonTimes[i].endTime >= refTime &&
                    typeof lessonTimes[i].dates === "object" && lessonTimes[i].dates.length > 0 && lessonTimes[i].dates.indexOf(refDate) >= 0 
                    && checkDataItemProperty(lessonTimes[i].buildingCodes, currentProfile.data.filter.bu, 1)
                    && checkDataItemProperty(lessonTimes[i].teacherCodes, currentProfile.data.filter.te, 1)
                    && checkDataItemProperty(lessonTimes[i].classCodes, currentProfile.data.filter.cl, 1)
                    && checkDataItemProperty(lessonTimes[i].roomCodes, currentProfile.data.filter.ro, 1)
                    && checkDataItemProperty(lessonTimes[i].teamCodes, currentProfile.data.filter.team, 1)
                ) {
                    if (currentProfile.data.nowScope === "day" || lessonTimes[i].startTime <= refTime) {
                        r.push(lessonTimes[i]);
                    }
                }
            }

            r.sort(function (a, b) {
                return a.startTime.localeCompare(b.startTime);
            });
        }
    }


    // r contains lessonTimes, sorted by targetGroup

    return r;
}