var fnGetSubstitutionsHeaderParts = {
    get: function (k) {
        if (typeof k === "string" && k != "" && typeof this[k] !== "undefined")
            return this[k];
        else
            return this["default"];
    },

    "default": function () {
        if (typeof currentProfile.data.substHeader === "string" && currentProfile.data.substHeader.length > 0)
            return [currentProfile.data.substHeader];
        else if (typeof currentProfile.data.substHeader === "object" && currentProfile.data.substHeader.length > 0)
            return currentProfile.data.substHeader;
        else
            return ["teacher", "class"];
    },

    "class": function () {
        if (typeof currentProfile.data.substHeader === "string" && currentProfile.data.substHeader.length > 0)
            return [currentProfile.data.substHeader];
        else if (typeof currentProfile.data.substHeader === "object" && currentProfile.data.substHeader.length > 0)
            return currentProfile.data.substHeader;
        else
            return [];
    },

    "teacher": function () {
        if (typeof currentProfile.data.substHeader === "string" && currentProfile.data.substHeader.length > 0)
            return [currentProfile.data.substHeader];
        else if (typeof currentProfile.data.substHeader === "object" && currentProfile.data.substHeader.length > 0)
            return currentProfile.data.substHeader;
        else
            return [];
    },
};

var fnGetSubstitutionsColumns = {
    get: function (k) {
        if (typeof k === "string" && k != "" && typeof this[k] !== "undefined")
            return this[k];
        else
            return this["default"];
    },

    "default": function () {
        if (typeof currentProfile.data.substCols === "object" && currentProfile.data.substCols.length > 0)
            return currentProfile.data.substCols;
        else
            return ["date", "weekDay", "pos", "time", "teacher", "subject", "room", "class", "steacher", "caption", "info", "message"];
    },

    "class": function () {
        if (typeof currentProfile.data.substCols === "object" && currentProfile.data.substCols.length > 0)
            return currentProfile.data.substCols;
        else
            return ["class", "date", "weekDay", "pos", "time", "teacher", "subject", "room", "steacher", "caption", "info", "message"];
    },

    "teacher": function () {
        if (typeof currentProfile.data.substCols === "object" && currentProfile.data.substCols.length > 0)
            return currentProfile.data.substCols;
        else
            return ["rteacher", "date", "weekDay", "pos", "time", "steacher", "teacher", "subject", "room", "class", "caption", "info", "message"];
    },
};


var fnMapSubstitutionsColumns = {
    get: function (k) {
        if (typeof k === "string" && k != "" && typeof this[k] !== "undefined")
            return this[k];
        else
            return this["default"];
    },

    "default": function (c, o) {
        var r = "";
        if (typeof c === "object") {
            c.forEach(function (e) {
                if (typeof o[e] !== "undefined") {
                    if (e == "weekDay") {
                        r = r + '<td data-c="' + e + '" data-weekday="' + ((o["sameDay"] && !o["pageTop"])?"":o[e]) + '"></td>';
                    } else if (e == "date") {
                        r = r + '<td data-c="' + e + '">' + ((o["sameDay"] && !o["pageTop"])
                            ? ""
                            : (
                                '<span class="INTLDATE INTLDATE-DELIM DD LE">' + o.date_dd +
                                '</span><span class="INTLDATE INTLDATE-DELIM MM LE">' + o.date_mm +
                                '</span><span class="INTLDATE INTLDATE-DELIM YYYY">' + o.date_yyyy +
                                '</span><span class="INTLDATE INTLDATE-DELIM MM BE">' + o.date_mm +
                                '</span><span class="INTLDATE INTLDATE-DELIM DD BE">' + o.date_dd +
                                '</span>')
                            ) +
                        '</td>';
                    } else if (e == "lessonTime") {
                        r = r + '<td data-c="' + e + '">' + ((o["sameLessonBlock"] && !o["pageTop"])?"":o[e]) + '</td>';
                    } else if (e == "time" || e == "pos") {
                        r = r + '<td data-c="' + e + '">' + (o["isMessageDay"] ? "" : o[e]) + '</td>';
                    } else if (e == "message") {
                        if (data.result.displaySchedule.display.publishSubstMessage === true) {
                            r = r + '<td data-c="message">' + (o["message"] || "") + '</td>';
                        }
                    } else {
                        r = r + '<td data-c="' + e + '">' + o[e] + '</td>';
                    }
                } else {
                    r = r + '<td data-c="' + e + '"></td>';
                }
            });
        }
        return r;
    },
};

var fnSortSubstitutions = {
    get: function (k) {
        if (typeof k === "string" && k != "" && typeof this[k] !== "undefined")
            return this[k];
        else 
            return this["default"];
    },

    "default": function (a, b) {
        if (a.dates[0] == b.dates[0]) {
            //var al = data.result.timeframes[a._timeframeIndex].timeslots[a._timeslotIndex].startTime;
            //var bl = data.result.timeframes[b._timeframeIndex].timeslots[b._timeslotIndex].startTime;
            var al = a.startTime;
            var bl = b.startTime;

            if (al == bl) {
                if (a._i == b._i) {
                    return (a._timeslotIndex < b._timeslotIndex ? -1 : (a._timeslotIndex > b._timeslotIndex ? 1 : 0));
                } else
                    return (a._i < b._i ? -1 : 1);
            } else 
                return (al < bl ? -1 : 1);
            
        } else
            return ((a.dates[0] < b.dates[0]) ? -1 : +1);
    },

    "class": function (a, b) {
        if (a.dates[0] == b.dates[0]) {

            var ac = "";
            if (typeof a.classCodes === "object")
                ac = a.classCodes.join();

            var bc = "";
            if (typeof b.classCodes === "object")
                bc = b.classCodes.join();
            
            var c = ac.localeCompare(bc, undefined, { numeric: true, sensitivity: 'base' })
            if (c > 0)
                return +1;
            else if (c < 0)
                return -1;

            var al = a.startTime;
            var bl = b.startTime;
            return (al < bl ? -1 : (al > bl ? 1 : 0));
        } else
            return ((a.dates[0] < b.dates[0]) ? -1 : +1);
    },

    "classkey": function (a, b) {
        var ac = "";
        if (typeof a.classCodes === "object") 
            ac = a.classCodes[0];

        var bc = "";
        if (typeof b.classCodes === "object")
            bc = b.classCodes.join();

        var c = ac.localeCompare(bc, undefined, { numeric: true, sensitivity: 'base' })
        if (c > 0)
            return +1;
        else if (c < 0)
            return -1;

        if (a.dates[0] == b.dates[0]) {
            var al = a.startTime;
            var bl = b.startTime;
            return (al < bl ? -1 : (al > bl ? 1 : 0));
        } else
            return ((a.dates[0] < b.dates[0]) ? -1 : +1);
    },

    "teacher": function (a, b) {
        if (a.dates[0] == b.dates[0]) {

            if (a._rteacherCode < b._rteacherCode)
                return -1;
            else if (a._rteacherCode > b._rteacherCode)
                return +1;

            //var al = data.result.timeframes[a._timeframeIndex].timeslots[a._timeslotIndex].startTime;
            //var bl = data.result.timeframes[b._timeframeIndex].timeslots[b._timeslotIndex].startTime;
            var al = a.startTime;
            var bl = b.startTime;
            return (al < bl ? -1 : (al > bl ? 1 : 0));
        } else
            return ((a.dates[0] < b.dates[0]) ? -1 : +1);
    },

    "teacherkey": function (a, b) {
        if (a._rteacherCode < b._rteacherCode)
            return -1;
        else if (a._rteacherCode > b._rteacherCode)
            return +1;

        if (a.dates[0] == b.dates[0]) {
            var al = a.startTime;
            var bl = b.startTime;
            return (al < bl ? -1 : (al > bl ? 1 : 0));
        } else
            return ((a.dates[0] < b.dates[0]) ? -1 : +1);
    },
};

var fnSpitLesson = {
    get: function (k) {
        if (typeof k === "string" && k != "" && typeof this[k] !== "undefined")
            return this[k];
        else
            return this["default"];
    },

    "default": function (a) {
        return [a];
    },

    "class": function (a) {
        var r = [];

        if (typeof a.classCodes === "object" && a.classCodes.length >= 1) {
            for (var i = 0; i < a.classCodes.length; i++) {
                var o = {};
                $.extend(true, o, a);
                o.classCodes = [a.classCodes[i]];
                if (o.changes !== undefined && o.changes.absentClassCodes !== undefined && o.changes.absentClassCodes.length > 1) {
                    if (o.changes.absentClassCodes.indexOf(a.classCodes[i]) !== -1)
                        o.changes.absentClassCodes = [a.classCodes[i]];
                }
                r.push(o);
            }
        } else if (typeof a.changes === "object" && a.changes.changeType == 4) {
            var o = {};
            $.extend(true, o, a);
            o.classCodes = [];
            r.push(o);
        }

        return r;
    },

    "teacher": function (a) {
        var teacherCodes = [];
        var absentTeacherCodes = [];

        if (typeof a.changes === "object" && typeof a.changes.absentTeacherCodes === "object")
            absentTeacherCodes = a.changes.absentTeacherCodes;

        if (typeof a.teacherCodes === "object") { 
            Array.prototype.push.apply(
                teacherCodes,
                a.teacherCodes.filter(
                    function (e) {
                        return (absentTeacherCodes.indexOf(e) == -1);
                    }
                )
            );
        }

        if (typeof a.changes === "object" && typeof a.changes.newTeacherCodes === "object") {
            Array.prototype.push.apply(
                teacherCodes,
                a.changes.newTeacherCodes.filter(
                    function (e) {
                        return ((absentTeacherCodes.indexOf(e) == -1) && (teacherCodes.indexOf(e) == -1));
                    }
                )
            );
        }

        var r = [];
        if (teacherCodes.length >= 1) {
            for (var i = 0; i < teacherCodes.length; i++) {
                var o = {};
                $.extend(true, o, a);
                o._rteacherCode = [teacherCodes[i]];
                r.push(o);
            }
        } else if (typeof a.changes === "object" && a.changes.changeType == 4) {
            var o = {};
            $.extend(true, o, a);
            o._rteacherCode = "";
            r.push(o);
        }
        return r;

    },

};

function getSubstitutionsData(
    refDate,
    refTime,
    showExtraPage, showExtraAll, refDateEnd, pageSize
) {
    var dataChanges = [];

    var refFilter;
    if (currentProfile.data.filterSubst === "my") {
        refFilter = currentProfile.data.profileFilter;
    } else if (currentProfile.data.filterSubst === "all") {
        refFilter = {};
    } else {
        refFilter = currentProfile.data.filter;
    }

    var refToday = (new ONTIME.Date()).format();

    with (data.result.displaySchedule) {
        if (typeof lessonTimes === "object" && typeof _lessonTimesChanges === "object") {
            for (var i = 0; i < _lessonTimesChanges.length; i++) {
                if (
                    currentProfile.data.filterSubst === "all" ||
                    (
                        checkDataItemProperty(lessonTimes[_lessonTimesChanges[i]].buildingCodes, refFilter.bu, 1) &&
                        checkDataItemProperty(lessonTimes[_lessonTimesChanges[i]].teacherCodes, refFilter.te, 1) &&
                        checkDataItemProperty(lessonTimes[_lessonTimesChanges[i]].classCodes, refFilter.cl, 1) &&
                        checkDataItemProperty(lessonTimes[_lessonTimesChanges[i]].roomCodes, refFilter.ro, 1) &&
                        checkDataItemProperty(lessonTimes[_lessonTimesChanges[i]].teamCodes, refFilter.team, 1)
                    )
                ) {
                    if (
                        (lessonTimes[_lessonTimesChanges[i]].dates[0] == refDate) ||
                        ((showExtraPage || showExtraAll) && ((lessonTimes[_lessonTimesChanges[i]].dates[0] > refDate) && (typeof refDateEnd === "undefined" || (lessonTimes[_lessonTimesChanges[i]].dates[0] <= refDateEnd))))
                    )
                    {
                        if (
                            (currentProfile.data.showPastSubst == "true") ||
                            ((lessonTimes[_lessonTimesChanges[i]].dates[0] === refDate) && (refDate != refToday || lessonTimes[_lessonTimesChanges[i]].endTime >= refTime)) ||
                            (lessonTimes[_lessonTimesChanges[i]].dates[0] > refDate)
                        ) {
                            if (
                                typeof lessonTimes[_lessonTimesChanges[i]].changes === "object" &&
                                typeof lessonTimes[_lessonTimesChanges[i]].changes.absentTeacherCodes === "object" &&
                                lessonTimes[_lessonTimesChanges[i]].changes.absentTeacherCodes.indexOf(refFilter.te) >= 0
                            ) {
                                // teacher appears in absentTeacher - do not show
                            } else {
                                Array.prototype.push.apply(dataChanges, fnSpitLesson.get(currentProfile.data.substKey)(lessonTimes[_lessonTimesChanges[i]]));
                            }
                        }
                    }
                }
            }
        }


        if (
            currentProfile.data.substKey == "teacher" || // always on for "teacher" view
            (currentProfile.data.substKey != "class" && currentProfile.data.substitutionShowSupervision == "true") || // explicit "true" - for "time" view
            (data.user.profile != "class" && data.user.profile != "student" && currentProfile.data.substitutionShowSupervision != "false") // not explicit "false" - when profile is not student related
            ) {
            if (typeof supervisionTimes === "object" && typeof _supervisionTimes === "object") {
                for (var i = 0; i < _supervisionTimes.length; i++) {
                    if (
                        currentProfile.data.filterSubst === "all" ||
                        (
                            checkDataItemProperty(supervisionTimes[_supervisionTimes[i]].teacherCodes, refFilter.te, 1) &&
                            checkDataItemProperty(supervisionTimes[_supervisionTimes[i]].roomCodes, refFilter.ro, 1) &&
                            checkDataItemProperty(supervisionTimes[_supervisionTimes[i]].teamCodes, refFilter.team, 1)
                        )
                    ) {
                        if (
                            (supervisionTimes[_supervisionTimes[i]].dates[0] == refDate) ||
                            ((showExtraPage || showExtraAll) && ((supervisionTimes[_supervisionTimes[i]].dates[0] > refDate) && (typeof refDateEnd === "undefined" || (supervisionTimes[_supervisionTimes[i]].dates[0] <= refDateEnd))))
                        ) {
                            if (
                                (currentProfile.data.showPastSubst == "true") ||
                                ((supervisionTimes[_supervisionTimes[i]].dates[0] === refDate) && (refDate != refToday || supervisionTimes[_supervisionTimes[i]].endTime >= refTime)) ||
                                (supervisionTimes[_supervisionTimes[i]].dates[0] > refDate)
                            ) {
                                Array.prototype.push.apply(dataChanges, fnSpitLesson.get(currentProfile.data.substKey)(supervisionTimes[_supervisionTimes[i]]));
                            }
                        }
                    }
                }
            }
        }
    }

    var dataChanges2 = [];
    for (var i = 0; i < dataChanges.length; i++) {

        // lookup timeframe index
        if (typeof dataChanges[i]._timeframeIndex !== "number") {
            dataChanges[i]._timeframeIndex = lookupTimeframeIndex(dataChanges[i]);
        }

        // lookup timeslots indexes
        if (typeof dataChanges[i]._timeslots !== "object") {
            dataChanges[i]._timeslots = [];

            var b = 0;
            if (dataChanges[i].startTime !== "0000")
                b = lookupTimeslotIndex(dataChanges[i].startTime, dataChanges[i]._timeframeIndex, true, false, data.result.timeframes);

            var e = data.result.timeframes[dataChanges[i]._timeframeIndex].timeslots.length ? data.result.timeframes[dataChanges[i]._timeframeIndex].timeslots.length - 1 : 0;
            if (dataChanges[i].endTime != "0000")
                e = lookupTimeslotIndex(dataChanges[i].endTime, dataChanges[i]._timeframeIndex, false, true, data.result.timeframes);

            for (var j = b; j <= e; j++) {
                dataChanges[i]._timeslots.push(j);
            }
        }

        // TODO: split or keep agregated - as a parameter
        if (dataChanges[i]._timeslots.length > 0) {
            for (var j = 0; j < dataChanges[i]._timeslots.length; j++) {
                var clonedItem = jQuery.extend(true, {}, dataChanges[i]);
                clonedItem._timeslotIndex = dataChanges[i]._timeslots[j];
                dataChanges2.push(clonedItem);
            }
        } else {
            var clonedItem = jQuery.extend(true, {}, dataChanges[i]);
            clonedItem._timeslotIndex = dataChanges[i]._timeslots[0];
            dataChanges2.push(clonedItem);
        }
    }
    dataChanges = dataChanges2;


    dataChanges.sort(fnSortSubstitutions.get(currentProfile.data.substKey + (currentProfile.data.substSort || "")));


    if (showExtraPage && pageSize > 0) {
        for (var i = 0; i < dataChanges.length; i++) {
            if (i >= pageSize && dataChanges[i].dates[0] > dataChanges[0].dates[0]) {
                // if additional date appears on 2+ page ...
                var s = dataChanges[i].dates[0];
                // ... remove
                dataChanges.splice(i, dataChanges.length);

                // if that date was also on the first page - remove (assume sorted by date)
                for (j = 0; j < pageSize; j++) {
                    if (dataChanges[j].dates[0] == s) {
                        dataChanges.splice(j, dataChanges.length);
                        break;
                    }
                }

                break;
            }
        }
    }

    return dataChanges;
}

function buildChangeItem(item, normalProperty, newProperty, absProperty) {
    var r = "";

    if (typeof item.changes !== "undefined" && typeof item.changes[newProperty] !== "undefined")
        r = '<span class="aNewItem">' + item.changes[newProperty].join(", ") + '</span>';
    if (typeof item.changes !== "undefined" && typeof item.changes[absProperty] !== "undefined")
        r = r + ' <span class="aAbsItem">' + item.changes[absProperty].join(", ") + '</span>';
    if (r.length == 0 && typeof item[normalProperty] === "string")
        r = '<span>' + item[normalProperty] + '</span>';
    if (r.length == 0 && typeof item[normalProperty] === "object")
        r = '<span>' + item[normalProperty].join(", ") + '</span>';

    return r;
}


function getLessonTime(item, j) {
    //var startTime = ((j == 0 || typeof item._timeslots !== "object")
    //    ? item.startTime
    //    : data.result
    //        .timeframes[item._timeframeIndex]
    //            .timeslots[j]
    //                .startTime
    //);

    /*
    var endTime = ((j = (item._timeslots.length - 1))
        ? item.endTime
        : data.result
            .timeframes[item._timeframeIndex]
            .timeslots[item._timeslots[j]]
            .endTime);
    */

    //return startTime.replace(/(\d\d)(\d\d)/, "$1:$2") + " - " + endTime.replace(/(\d\d)(\d\d)/, "$1:$2");
    // return startTime.replace(/(\d\d)(\d\d)/, "$1:$2");

    return item.startTime.replace(/(\d\d)(\d\d)/, "$1:$2");
}


function getLessonPos(item, j) {
    return ((typeof item._timeslots !== "object")
        ? ""
        : data.result
            .timeframes[item._timeframeIndex]
                .timeslots[j]
                    .label
    );
}


function getPageSize(tbody) {
    var r = 0;
    var oHeight = tbody.parentElement.parentElement.getBoundingClientRect().height;
    var hHeight = tbody.previousElementSibling.getBoundingClientRect().height;

    if (hHeight > 0 && oHeight > hHeight)
        r = Math.floor((oHeight - hHeight) / hHeight);
    
    if (r < 1)
        r = 1;

    return r;
}