/* control the layout: define headers, set items resolvers */

// TODO: move to more general part, as filter isn't limited to scheduler
function getProfileFilter() {
    var filter = {
        cl: null,
        te: null,
        ro: null,
    };

    if (typeof data.user.homeType === "string") {
        var homeCollectionRef = "";
        var filterRef = "";

        if (data.user.homeType == "class") {
            homeCollectionRef = "classes";
            filterRef = "cl";
        } else if (data.user.homeType == "teacher" /*&& data.user.profile == "teacher"*/) {
            homeCollectionRef = "teachers";
            filterRef = "te";
        }

        if (homeCollectionRef != "") {
            var homeCollection = data.result[homeCollectionRef];
            if (typeof homeCollection === "object" && homeCollection.length > 0) {

                var index = 0;

                if (typeof data.user.homeId === "string") {
                    for (var i = 0; i < homeCollection.length; i++) {
                        if (homeCollection[i].id == data.user.homeId) {
                            index = i;
                            break;
                        }
                    }
                }

                filter[filterRef] = homeCollection[index].code;
            }
        }
    }

    return filter;
}

function useColorsFromServer() {
    try {
        var colorMapper = {

            // supervisionColor,
            // supervisionChangeColor
            "supervisionColor": function (color) {
                var textColor = "black";
                if (isColorDark(color))
                    textColor = "white";

                var rgb = parseInt(color.slice(1), 16);
                if (rgb >= 0 && rgb <= 0xFFFFFF) {
                    var r = (rgb & 0xFF0000) >> 16;
                    var g = (rgb & 0x00FF00) >> 8;
                    var b = (rgb & 0x0000FF);
                }

                $("style.ext-colors").append(
                    '.scheme-davinci .ontime-scheduler-pane .ontime-scheduler-items-supervision .ontime-scheduler-dataitem .ontime-scheduler-itemcontentdata' + '{background-color:rgba(' + r + ',' + g + ',' + b + ',0.75);color:' + textColor + '}' +
                    '.scheme-davinci .ontime-scheduler-pane .ontime-scheduler-items-supervision .ontime-scheduler-dataitem .ontime-scheduler-itemcontentdata:hover' + '{background-color:rgba(' + r + ',' + g + ',' + b + ',1);}'
                );
            },

            // messageColor
            "messageColor": function (color) {
                var textColor = "black";
                if (isColorDark(color))
                    textColor = "white";

                $("style.ext-colors").append(
                    '.scheme-davinci .ontime-scheduler-items-lessons .ontime-scheduler-itemcontent.item-whole-day-message,' +
                    '.scheme-davinci .ontime-scheduler-items-lessons .ontime-scheduler-itemcontent.item-regular-message,' +
                    '.scheme-davinci  .item-regular-message .ontime-scheduler-itemcontentdata .aCaption.aMessage,' +
                    '.scheme-davinci .item-whole-day-message .ontime-scheduler-itemcontentdata .aCaption.aMessage' +
                    '{background-color:' + color + '}' + 
                    '.scheme-davinci .item-regular-message .ontime-scheduler-itemcontentdata,' +
                    '.scheme-davinci .item-whole-day-message .ontime-scheduler-itemcontentdata' +
                    '{color:' + textColor + '}'  
                );
            },

            // additionalLessonColor
            "additionalLessonColor": function (color) {
                var textColor = "black";
                if (isColorDark(color))
                    textColor = "white";

                $("style.ext-colors").append(
                    '.scheme-davinci .has-changes[data-change-type="3"] .ontime-scheduler-itemcontentdata .aCaption {background-color:' + color + '}' +
                    '.scheme-davinci .has-changes[data-change-type="3"] .ontime-scheduler-itemcontentdata .aCaption {color:' + textColor + '}'
                );
            },

            // lessonChangeColor - how to apply it? conflict with additionalLessonColor, roomChangeColor, lessonColor
            "lessonChangeColor": function (color) {
                var textColor = "black";
                if (isColorDark(color))
                    textColor = "white";

                $("style.ext-colors").append(
                    '.scheme-davinci .ontime-scheduler-itemcontentdata .aCaption {background-color:' + color + '}' + 
                    '.scheme-davinci .ontime-scheduler-itemcontentdata .aCaption {color:' + textColor + '}'  
                );
            },

            // roomChangeColor - when, where and how to apply this? conflict with lessonChangeColor
            "roomChangeColor": function (color) {
                var textColor = "black";
                if (isColorDark(color))
                    textColor = "white";

                $("style.ext-colors").append(
                    '.scheme-davinci .has-room-changes .ontime-scheduler-itemcontentdata .aCaption {background-color:' + color + '}' +
                    '.scheme-davinci .has-room-changes .ontime-scheduler-itemcontentdata .aCaption {color:' + textColor + '}'
                );
            },

            // backgroundColor - only background is not enough: borders, grid lines color, headers color, hover effect?
            "backgroundColor": function (color) {
                var textColor = "black";
                if (isColorDark(color))
                    textColor = "white";

                $("style.ext-colors").append(
                    '.scheme-davinci .ontime-scheduler-pane {background-color:' + color + '}' 
                );
            },

            //// lessonColor - when, how? is it for all lessons which have no color?
            //"lessonColor": function (color) {
            //    var textColor = "black";
            //    if (isColorDark(color))
            //        textColor = "white";

            //    $("style.ext-colors").append(
            //        '.scheme-davinci .ontime-scheduler-items-lessons .ontime-scheduler-itemcontent {background-color:' + color + '}' 
            //    );
            //},

            // lessonAbsentColor - same color as lessonChangeColor, is it not a mistake?
            "lessonAbsentColor": function (color) {
                var textColor = "black";
                if (isColorDark(color))
                    textColor = "white";

                $("style.ext-colors").append(
                    '.scheme-davinci .ontime-scheduler-items-lessons .is-cancelled .ontime-scheduler-itemcontent {background-color:' + color + '}'
                );
            },

            
            // absenceColor - where and how to apply it?
        };

        $("style.ext-colors").empty();
        Object.keys(colorMapper).forEach(function (k) {
            if (typeof data.result.displaySchedule.display[k] === "string" && data.result.displaySchedule.display[k].length == 7 && data.result.displaySchedule.display[k].charAt(0) == "#") {
                colorMapper[k](data.result.displaySchedule.display[k]);
            }
        });

    } catch (e) { }
    
}

// TODO: move to more general part, as sidebar doesn't limited to scheduler
function fillDavinciSidebar() {

    $(".profile-extraplan").remove();

    if (typeof data.result === "object") {

        // show/hide my-plan sidebar item  depending on profile and homeType/homeId or first profile - treat it as primary.
        $(".profile-myplan").css("display", (
            ["master", "default", "class", "student", "staff", "teacher", "team", "teammaster"].indexOf(data.users[0].profile) >= 0 &&
            typeof data.users[0].homeType === "string" && data.users[0].homeType != "" &&
            typeof data.users[0].homeId === "string" && data.users[0].homeId != ""
            ) ? "" : "none");

        // calculate classes/teachers/room menu items
        var showClassesMenu = false;
        var showTeachersMenu = false;
        var showRoomsMenu = false;
        var allowTeachersForGuest = false;

        for (var pi = 0; pi < data.users.length; pi++) {
            if (["teammaster", "master", "default"].indexOf(data.users[pi].profile) >= 0) {
                showClassesMenu = true;
                showTeachersMenu = true;
                showRoomsMenu = true;
                break;
            }
            else if (["teacher", "team", "staff"].indexOf(data.users[pi].profile) >= 0) {
                showClassesMenu = true;
                showRoomsMenu = true;
            }
            else if ("guest" === data.users[pi].profile) {
                showClassesMenu = showClassesMenu || ([12, 13].indexOf(data.users[pi].policy) >= 0);
                showTeachersMenu = showTeachersMenu || (13 === data.users[pi].policy);
                showRoomsMenu = showRoomsMenu || ([2, 11, 12, 13].indexOf(data.users[pi].policy) >= 0);
                allowTeachersForGuest = allowTeachersForGuest || (13 === data.users[pi].policy);
            }
        }

        [
            ["#dv-classes", data.result.classes, showClassesMenu, ".profile-classes"],
            ["#dv-teachers", data.result.teachers, showTeachersMenu, ".profile-teachers"],
            ["#dv-rooms", data.result.rooms, showRoomsMenu, ".profile-rooms"],
        ].forEach(function (e) {
            $(e[0]).empty();

            if (e[2]) // enable "all items" if category is alowed by profile
                $(e[0]).append('<li><a data-label="all"></a></li>');

            var n = 0;

            if (typeof e[1] === "object") {
                for (var i = 0; i < e[1].length || 0; i++) {
                    if (e[1][i]._allow === true || allowTeachersForGuest) {
                        $(e[0]).append("<li><a>" + e[1][i].code + "</a></li>");
                        n++;
                    }
                }
            }

            // show category if allowed by profile 
            $(e[3]).css("display", (e[2]) ? "" : "none");
        });
    }


    // "My Plan" references users[0] profile if applicable. Generate "Another Plan" for subsequent profiles...
    if (typeof data.users === "object" && data.users.length > 1) {
        for (var i = 1; i < data.users.length; i++) {
            if (typeof data.users[i] === "object") {
                if (typeof data.users[i].homeId === "string" && data.users[i].homeId != "" &&
                    typeof data.users[i].homeType === "string" && data.users[i].homeType != ""
                    ) {
                    var title = i;
                    // class / teacher code can be used as title. 
                    // TBD: student title? name is too long
                    if (typeof data.users[i].code === "string" && data.users[i].code != "")
                        title = data.users[i].code;
                    else if (data.users[i].homeType == "student")
                        title = (data.users[i].name || "");
                    $(".profile-myplan").parent().append('<li class="profile-extraplan" data-i="' + i + '"><a>Plan: ' + title + '</a></li>');
                }
            }
        }
    }
}

function offsetTimePeriod(steps) {
    var wd = currentProfile.data.wd;
    do {
        currentProfile.data.offsetDate(steps);
    } while (wd != currentProfile.data.wd && (currentProfile.data.wd < data.result.displaySchedule.weekspan.weekdayStart || currentProfile.data.wd > (data.result.displaySchedule.weekspan.weekdayEnd||7)));
}

// TODO: move to more general davinci-shared.js
function getCurrentTimeslotIndex() {
    return getTimeslotIndex((
        //new ONTIME.Date()
        currentProfile.data.refTime()
    ).format("HHmm"), 0);
}

function getTimeslotIndex(ts, timeframeIndex) {
    if (timeframeIndex < data.result.timeframes.length) {
        with (data.result.timeframes[timeframeIndex]) {
            var l = timeslots.length;
            if (l > 0) {
                if (ts > timeslots[l - 1].endTime) {
                    return {
                        index: l - 1,
                        match: 1
                    };
                } else {
                    for (var i = 0; i < l; i++) {
                        if (ts < timeslots[i].endTime) {
                            return {
                                index: i,
                                match: ((ts >= timeslots[i].startTime) ? 0 : -1),
                            };
                        }
                    }
                }
            }
        }
    }

    return {
        index: -1,
        match: -1
    };
}


var timeoutMarkCurrentTimeslot = 0;

function markCurrentTimeslot(k) {
    clearTimeout(timeoutMarkCurrentTimeslot);
    timeoutMarkCurrentTimeslot = 0;

    if (typeof k === "object" && k !== null && typeof data.result === "object") {
        var i = 1+getCurrentTimeslotIndex().index;

        $("[data-current-ts]").removeAttr("data-current-ts");
        k.$el.find('.ontime-scheduler-headeritem[data-yi="' + i + '"]').attr("data-current-ts", 0);
		k.$el.trigger("davinci_markcurrenttimeslot");
    }

    timeoutMarkCurrentTimeslot = setTimeout(function () {
        markCurrentTimeslot(k);
    }, 30 * 1000);
}


function goPrevTimePeriod() {
    offsetTimePeriod(-1);

    defineLayout();
    k.$el.attr("data-periodanimate", "right");
    k.refresh();
    setTimeout(function () {
        k.$el.attr("data-periodanimate", "-");
    }, 50);
}


function goNextTimePeriod() {
    offsetTimePeriod(+1);

    defineLayout();
    k.$el.attr("data-periodanimate", "left");
    k.refresh();
    setTimeout(function () {
        k.$el.attr("data-periodanimate", "-");
    }, 50);
}

function goCurrentTimePeriod() {
    var dd = currentProfile.data.dd;
    currentProfile.set("dateFilter", {
        dd: null,
    });

    if (dd.format() != currentProfile.data.dd.format())
    {
        defineLayout();
        k.refresh();
        return true;
    }

    return false;
}

function applySchedulerFilter(attr, value) {
    var f = {
        profileIndex: 0,
        te: null,
        cl: null,
        ro: null
    };

    f[attr] = value;

    if (currentProfile.data.filter.profileIndex > 0)
        currentProfile.replace("objectFilter", {
            filter: f
        });
    else
        currentProfile.set("objectFilter", {
            filter: f
        });
}

function set1Day(b, today) {
    if (b) {
        if (typeof today !== "object")
            today = null;

        currentProfile.set("dateFilter", {
            dd: today,
            offsetStep: 1,
        });
    } else {
        currentProfile.set("dateFilter", {
            dd: today,
            offsetStep: 7,
        });
    }

    k.dayView = b;
}

function arrayLookup(arr, value, attr) {
    if (arr !== undefined) {
        for (var i = 0; i < arr.length; i++) {
            if (arr[i][attr] === value)
                return i;
        }
    }
    return -1;
}

function getCurrentTimeframeIndex() {
    var r = 0;
    
    if (typeof currentProfile.data.filter.cl === "string") {
        var i = arrayLookup(data.result.classes, currentProfile.data.filter.cl, "code");
        if (i >= 0)
            r = (data.result.classes[i]._timeframeIndex || 0);
    } else if (typeof currentProfile.data.filter.te === "string") {
        var i = arrayLookup(data.result.teachers, currentProfile.data.filter.te, "code");
        if (i >= 0)
            r = (data.result.teachers[i]._timeframeIndex || 0);
    } else if (typeof currentProfile.data.filter.ro === "string") {
        var i = arrayLookup(data.result.rooms, currentProfile.data.filter.ro, "code");
        if (i >= 0)
            r = (data.result.rooms[i]._timeframeIndex || 0);
    }

    return r;
}

function defineLayout() {
  if (k.layoutType == "date") {
	k.layers[0].itemBuilderCallbacks = [resolveDayWeekToX, resolveTimeToY, resolveTitle];
	if(k.layers.length>=3) {
		k.layers[1].itemBuilderCallbacks = [resolveEventDateToX, resolveEventTimeToY, resolveEventTitle];
		k.layers[2].itemBuilderCallbacks = [resolveDayWeekToX, resolveSupervisionTimeToY, resolveSupervisionTitle];
	}

	if (k.layers.length >= 4) {
	    k.layers[3].itemBuilderCallbacks = [resolveDayWeekToX, resolveTimeToY, resolveAbsenceTitle];
	}

	k.leftHeader = {
	  items: getTimeframe(getCurrentTimeframeIndex()),
	  builderCallback: resolveTimeToHeader,
	  fixedSize: false
	};
	k.topHeader = {
	  items: getWeekDays(true),
	  builderCallback: resolveWeekDayX,
	  fixedSize: false
	};

  } else if (k.layoutType == "class") {
	k.layers[0].itemBuilderCallbacks = [resolveClassToX, resolveTimeToY, resolveTitle];
	if (k.layers.length >= 4) {
	    k.layers[3].itemBuilderCallbacks = [resolveClassToX, resolveTimeToY, resolveAbsenceTitle];
	}

	k.leftHeader = {
	  items: getTimeframe(0),
	  builderCallback: resolveTimeToHeader,
	  fixedSize: false
	};
	k.topHeader = {
	  items: buildHeaderItems(data.result.classes),
	  builderCallback: resolveClassX,
	  fixedSize: true
	};

  } else if (k.layoutType == "teacher") {
	k.layers[0].itemBuilderCallbacks = [resolveTeacherToX, resolveTimeToY, resolveTitle];
	if (k.layers.length >= 3) {
	    k.layers[1].itemBuilderCallbacks = [resolveEventDateToX, resolveEventTimeToY, resolveEventTitle];
	    k.layers[2].itemBuilderCallbacks = [resolveTeacherToX, resolveSupervisionTimeToY, resolveSupervisionTitle];
	}

	if (k.layers.length >= 4) {
	    k.layers[3].itemBuilderCallbacks = [resolveTeacherToX, resolveTimeToY, resolveAbsenceTitle];
	}

	k.leftHeader = {
	  items: getTimeframe(0),
	  builderCallback: resolveTimeToHeader,
	  fixedSize: false
	};
	k.topHeader = {
	  items: buildHeaderItems(data.result.teachers),
	  builderCallback: resolveTeacherX,
	  fixedSize: true
	};

  } else if (k.layoutType == "room") {
	k.layers[0].itemBuilderCallbacks = [resolveRoomToX, resolveTimeToY, resolveTitle];

	k.leftHeader = {
	  items: getTimeframe(0),
	  builderCallback: resolveTimeToHeader,
	  fixedSize: false
	};
	k.topHeader = {
	  items: getHeaderItems(data.result.rooms),
	  builderCallback: resolveRoomX,
	  fixedSize: true
	};
  }
}

/* headers definition */
function getTimeframe(timeframeIndex) {
    var r = [];

    timeframeIndex = timeframeIndex || 0;

    if (timeframeIndex < data.result.timeframes.length) {
        for (var i = 0; i < data.result.timeframes[timeframeIndex].timeslots.length; i++) {
            r.push([
                i + 1,
                data.result.timeframes[timeframeIndex].timeslots[i].label,
                data.result.timeframes[timeframeIndex].timeslots[i]]);
        }
    }

    return r;
}
function getHeaderItems(coll) {
    var r = [];

    var d = ONTIME.Date.parse(currentProfile.data.d);

    for (var i = 0; i < coll.length; i++) {
        r.push([
            i + 1,
            coll[i].code,
		    d.getDay(),
		    d.format("D.M."),
            d.format("D"),
            d.format("M"),
        ]);
    }
  
    return r;
}

function buildHeaderItems(coll) {
	var r = [];

	var d = ONTIME.Date.parse(currentProfile.data.d);

	if(k.layoutType === "class") {
		if(data.result.displaySchedule.lessonTimes.some(function(e) {
			if(e.changes && e.changes.changeType === 4 && e.classCodes === undefined && e.dates.indexOf(currentProfile.data.d) >= 0)
				return true;
			else
				return false;
		}))
			r.push([
				0,
				"Mitteilungen",
				undefined,
				undefined,
				undefined,
				undefined,
				true
			]);
	} else if(k.layoutType === "teacher") {
		if(data.result.displaySchedule.lessonTimes.some(function(e) {
			if(e.changes && e.changes.changeType === 4 && e.teacherCodes === undefined && e.dates.indexOf(currentProfile.data.d) >= 0)
				return true;
			else
				return false;
		}))
			r.push([
				0,
				"Mitteilungen",
				undefined,
				undefined,
				undefined,
				undefined,
				true
			]);
	} 

	for (var i = 0; i < coll.length; i++) {
        r.push([
			0,
            coll[i].code
        ]);
    }
	
	r.forEach(function(e, i) {
		e[0] = i + 1;
		e[2] = d.getDay();
		e[3] = d.format("D.M.");
        e[4] = d.format("D");
        e[5] = d.format("M");
	});
	
	return r;
}

function getWeekDays(isHorizontal) {
  var r = [];
  
  var d = ONTIME.Date.parse(currentProfile.data.d);
  var daysCount = 1;
  if (!k.dayView) {
      d = ONTIME.Date.parse(currentProfile.data.d1);
      daysCount = k.getDaysCount()
  }
  
  for(var i=0; i<daysCount; i++) {
    var d1 = new ONTIME.Date();
    var tf = d1.format();
    d1 = d.clone();
    d1.offset(i);
    var df = d1.format();
	r.push([
		i+1, 
		d1.getDay(),
		d1.format("D.M."),
		df,
		tf == df,
        d1.getFullYear(),
        d1.format("D"),
        d1.format("M"),
	]);
  }
  return r;
}



/* items data flow: filter, ungroup */
function filterSupervisionItems(itemParams, filterParams, stage) {
  if (this.scheduler.layoutType !== "date" && this.scheduler.layoutType !== "teacher")
    return false;
  
  if (typeof itemParams.dates !== "object")
      return false;
  else if (itemParams.dates.length == 1) {
      if (
        (itemParams.dates[0] < ((k.dayView || this.scheduler.layoutType == "teacher") ? filterParams.profile.data.d : filterParams.profile.data.d1)) ||
        (itemParams.dates[0] > ((k.dayView || this.scheduler.layoutType == "teacher") ? filterParams.profile.data.d : filterParams.profile.data.d2))
      )
          return false;
  }

  if (
      typeof itemParams.teacherCodes === "object" && // supervison must be bound to teacher
      (
        this.scheduler.layoutType == "teacher" ||  // allow for teacher timetable format
        itemParams.teacherCodes.indexOf(filterParams.profile.data.filter.te) >= 0 // teacher code must appear in filter
      )
  )
      return true;

  return false; 
}


function ungroupSupervisionItem(itemParams) {
    var r = [itemParams];

    // produce combinations of given ...
    var coll = [
		"dates",
        "teacherCodes"
    ];

    for (var c = 0; c < coll.length; c++) {
        if ((typeof itemParams[coll[c]] === "object") && (itemParams[coll[c]].length > 1)) {
            var r1 = [];
            for (var i = 0; i < r.length; i++) {
                for (var j = 0; j < itemParams[coll[c]].length; j++) {
                    var o = jQuery.extend(true, {}, r[i]);
                    o[coll[c]] = [itemParams[coll[c]][j]];
                    r1.push(o);
                }
            }
            r = r1;
        }
    }

    return r;
}

function filterAbsenceItems(itemParams, filterParams, stage) {
    if (k.layoutType == "room" && typeof itemParams.roomCodes !== "object")
        return false;

    // check teacher
    if (k.layoutType == "teacher" && typeof itemParams.teacherCodes !== "object")
        return false;

    // check class
    if (k.layoutType == "class" && typeof itemParams.classCodes !== "object")
        return false;

    // at least one filter (teacher or class) is required and data must fit to the filter
    if (
        (k.layoutType == "teacher" ||
        typeof filterParams.profile.data.filter.te === "object" && filterParams.profile.data.filter.te !== null ||
         typeof filterParams.profile.data.filter.te === "string" && filterParams.profile.data.filter.te !== "") &&
        checkDataItemProperty(itemParams.teacherCodes, filterParams.profile.data.filter.te, stage)
        ||
        (k.layoutType == "class" ||
         typeof filterParams.profile.data.filter.cl === "object" && filterParams.profile.data.filter.cl !== null ||
         typeof filterParams.profile.data.filter.cl === "string" && filterParams.profile.data.filter.cl !== "") &&
        checkDataItemProperty(itemParams.classCodes, filterParams.profile.data.filter.cl, stage)
        ||
        (k.layoutType == "room" ||
         typeof filterParams.profile.data.filter.ro === "object" && filterParams.profile.data.filter.ro !== null ||
         typeof filterParams.profile.data.filter.ro === "string" && filterParams.profile.data.filter.ro !== "") &&
        checkDataItemProperty(itemParams.roomCodes, filterParams.profile.data.filter.ro, stage)
    )
    {
        
    } else {
        return false;
    }
    


    // check dates range
    if (k.dayView || k.layoutType != "date") {
        if (itemParams.dates.indexOf(filterParams.profile.data.d) == -1)
            return false;
    } else {
        if (
			!itemParams.dates.some(function(e) {
				return e >= ((k.layoutType == "date" && !k.dayView) ? filterParams.profile.data.d1 : filterParams.profile.data.d) &&
				e <= ((k.layoutType == "date" && !k.dayView) ? filterParams.profile.data.d2 : filterParams.profile.data.d);
			})
        )
            return false;
    }  


    return true;
}

function ungroupAbsenceItem(itemParams) {
    var r = [itemParams];

    // produce combinations of given ...
    var coll = [
		"dates",
    ];

    for (var c = 0; c < coll.length; c++) {
        if ((typeof itemParams[coll[c]] === "object") && (itemParams[coll[c]].length > 1)) {
            var r1 = [];
            for (var i = 0; i < r.length; i++) {
                for (var j = 0; j < itemParams[coll[c]].length; j++) {
                    if (j === (itemParams[coll[c]].length - 1) && r[i].endTime === "0000") {
                    } else {
                        var o = jQuery.extend(true, {}, r[i]);
                        o[coll[c]] = [itemParams[coll[c]][j]];
                        if (j > 0)
                            o.startTime = "0000";
                        if (j < itemParams[coll[c]].length - 1)
                            o.endTime = "2359";

                        r1.push(o);
                    }
                }
            }
            r = r1;
        }
    }

    return r;
}


function filterEventItems(itemParams, filterParams, stage) {
    if(this.scheduler.layoutType !== "date") 
        return false;

    if (
        itemParams.startDate <= ((this.scheduler.layoutType == "date" && !k.dayView) ? filterParams.profile.data.d2 : filterParams.profile.data.d) &&
        itemParams.endDate > ((this.scheduler.layoutType == "date" && !k.dayView) ? filterParams.profile.data.d1 : filterParams.profile.data.d) &&
        (itemParams.eventType == "local" || itemParams.eventType == "national" ||
            (
            itemParams.participants !== undefined &&
            (filterParams.profile.data.filter.te && itemParams._te !== undefined && itemParams._te.includes(filterParams.profile.data.filter.te)) ||
            (filterParams.profile.data.filter.cl && itemParams._cl !== undefined && itemParams._cl.includes(filterParams.profile.data.filter.cl))
            )
        )
    )
        return true;
    
    
    return false;
}

/*
    stages:
    1 - initial filtering
    2 - after ungroup, only for complex ungrouped items
*/

function filterDataItems(itemParams, filterParams, stage) {
    // either date of weekday must be given
    if (
        (typeof itemParams.dates !== "object" || itemParams.dates.length < 1) &&
        (typeof itemParams.weekday === "undefined")
    )
        return false;

    // check filtered parameters
    // start with class and teacher, as they efficiently lead to early declination AND are easy to calculate AND are most probable single-value
    var profileIndex = (filterParams.profile.data.filter.profileIndex || 0);
    if (
        typeof itemParams._blockInProfile === "object" &&
        profileIndex < data.users.length &&
        data.users[profileIndex].profile == "student" && 
        itemParams._blockInProfile.indexOf(profileIndex) != -1)
        return false;

    if (k.layoutType == "date" && (itemParams.teacherCodes === undefined && itemParams.classCodes === undefined) && itemParams.changes !== undefined && itemParams.changes.changeType === 4) {
        // pass public messages
    } else {

		if( itemParams.changes !== undefined && itemParams.changes.changeType === 4 &&
			(
				(k.layoutType == "teacher" && itemParams.teacherCodes === undefined) || 
				(k.layoutType == "class" && itemParams.classCodes === undefined)
			)
		)
		{
		// pass public messages
			
		} else {
			// check teacher
			if (k.layoutType == "teacher" && typeof itemParams.teacherCodes !== "object")
				return false;
			if (!checkDataItemProperty( (itemParams.changes !== undefined && itemParams.changes.changeType === 4 && itemParams.teacherCodes === undefined) ? [filterParams.profile.data.filter.te] : itemParams.teacherCodes, filterParams.profile.data.filter.te, stage))
				return false;

			// check class
			if (k.layoutType == "class" && typeof itemParams.classCodes !== "object")
				return false;
			if (!checkDataItemProperty((itemParams.changes !== undefined && itemParams.changes.changeType === 4 && itemParams.classCodes === undefined) ? [filterParams.profile.data.filter.cl] : itemParams.classCodes, filterParams.profile.data.filter.cl, stage))
				return false;

			// check room
			if (k.layoutType == "room" && typeof itemParams.roomCodes !== "object" || !checkDataItemProperty(itemParams.roomCodes, filterParams.profile.data.filter.ro, stage))
				return false;

			// check team
			if (!checkDataItemProperty(itemParams.teamCodes, filterParams.profile.data.filter.team, stage))
				return false;
		}
    }

    // check building
    if (stage == 1 && !checkDataItemProperty(itemParams.buildingCodes, filterParams.profile.data.filter.bu, stage))
        return false;

    // check (optional) date
    if (typeof itemParams.dates === "object") {
        if (itemParams.dates.length == 1) {
            if (
                (itemParams.dates[0] < ((k.layoutType == "date" && !k.dayView) ? filterParams.profile.data.d1 : filterParams.profile.data.d)) ||
                (itemParams.dates[0] > ((k.layoutType == "date" && !k.dayView) ? filterParams.profile.data.d2 : filterParams.profile.data.d))
            )
                return false;

            if (filterParams.profile.data.filter.cl && itemParams._classCodesIndex !== undefined && itemParams._classCodesIndex.length) {
                var cl = itemParams._classCodesIndex
                    .map(function (e) {
                        return data.result.classes[e];
                    })
                    .filter(function (e) {
                        return e.code === filterParams.profile.data.filter.cl && e._ev !== undefined;
                    });

                for (var i = 0; i < cl.length; i++) {
                    var b = cl[i]._ev.some(function (e) {
                        return data.result.displaySchedule.eventTimes[e].noLessons && data.result.displaySchedule.eventTimes[e].wholeDay &&
                            data.result.displaySchedule.eventTimes[e].startDate <= itemParams.dates[0] && data.result.displaySchedule.eventTimes[e].endDate > itemParams.dates[0];
                    });

                    if (b)
                        return false;
                }
            }

            if (filterParams.profile.data.filter.te && itemParams._teacherCodesIndex !== undefined && itemParams._teacherCodesIndex.length) {
                var te = itemParams._teacherCodesIndex
                    .map(function (e) {
                        return data.result.teachers[e];
                    })
                    .filter(function (e) {
                        return e.code === filterParams.profile.data.filter.te && e._ev !== undefined;
                    });

                for (var i = 0; i < te.length; i++) {
                    var b = te[i]._ev.some(function (e) {
                        return data.result.displaySchedule.eventTimes[e].noLessons && data.result.displaySchedule.eventTimes[e].wholeDay &&
                            data.result.displaySchedule.eventTimes[e].startDate <= itemParams.dates[0] && data.result.displaySchedule.eventTimes[e].endDate > itemParams.dates[0];
                    });

                    if (b)
                        return false;
                }
            }
            
        } else if (k.dayView || k.layoutType != "date") {
            if (itemParams.dates.indexOf(filterParams.profile.data.d) == -1)
                return false;
        }
    } else {
        // check (optional) weekday
        if (
            (stage == 1) &&
            (typeof itemParams.weekday !== "undefined") &&
            (
                itemParams.weekday < ((k.layoutType == "date" && !k.dayView) ? filterParams.profile.data.wd1 : filterParams.profile.data.wd) ||
                itemParams.weekday > ((k.layoutType == "date" && !k.dayView) ? filterParams.profile.data.wd2 : filterParams.profile.data.wd)
            )
        )
            return false;
    }


    return true;
}


function checkDataItemProperty(itemProperties, filterProperty, stage) {
    // TBD: stage matters? then optimize

    var filterDefinedString = ((typeof filterProperty === "string") && (filterProperty.length > 0)); // valid string
    var dataDefined = ((typeof itemProperties === "object") && (itemProperties.length > 0)); // valid array

    if (filterDefinedString)
        return (dataDefined && (itemProperties.indexOf(filterProperty) >= 0));

    var filterDefinedArray = ((typeof filterProperty === "object") && (filterProperty != null) && (filterProperty.length > 0)); // valid array

    if (filterDefinedArray) {
        if (!dataDefined)
            return false;

        for (var i = 0; i < filterProperty.length; i++) {
            if (typeof filterProperty[i] === "string" && filterProperty[i].length > 0 && itemProperties.indexOf(filterProperty[i]) >= 0)
                return true;
        }

        return false;
    }

    return true;
}



function ungroupDataItem(itemParams) {
	var r = [itemParams];

	// produce combinations of given ...
	var coll = "dates";
	var teacherIndex = false;
	
    if (k.layoutType == "class")
		coll = "classCodes";
    else if (k.layoutType == "teacher") {
        coll = "teacherCodes";
        teacherIndex = (typeof itemParams._teacherCodesIndex === "object");
    } else if (k.layoutType == "room")
        coll = "roomCodes";
	
	if((typeof itemParams[coll] === "object") && (itemParams[coll].length > 1)) {
		var r1 = [];
		for(var i=0; i<r.length; i++) {
			for(var j=0; j<itemParams[coll].length; j++) {
				var o = jQuery.extend(true, {}, r[i]);
				o[coll] = [itemParams[coll][j]];
				if (teacherIndex)
				    o._teacherCodesIndex = [itemParams._teacherCodesIndex[j]];
				r1.push(o);
			}
		}
		return r1;
	} 
	
	return r;
}

/* items data flow: cells resolver */
function resolveCell(x, y, item) {
	if(typeof this.leftHeader.items[y][2] !== "undefined" && typeof this.leftHeader.items[y][2].color !== "undefined" && this.leftHeader.items[y][2].color != "#FFFFFF") {
		item.css("border-bottom-color", this.leftHeader.items[y][2].color);
	}
	if(typeof this.topHeader.items[x][2] !== "undefined" && typeof this.topHeader.items[x][2].color !== "undefined" && this.topHeader.items[x][2].color != "#FFFFFF") {
		item.css("border-right-color", this.topHeader.items[x][2].color);
	}
}

/* items data flow: position resolvers */
function resolveTimeToHeader(params, item, $header) {
    var d1 = createNode("div", "", "h-content");
    d1.appendChild(createNode("span", params[2].label, "h-label"));

    var s2 = createNode("span", "", "h-time");
    s2.appendChild(createNode("span", params[2].startTime.replace(/(\d\d)(\d\d)/, "$1:$2"), "h-start"));
    s2.appendChild(createNode("span", params[2].endTime.replace(/(\d\d)(\d\d)/, "$1:$2"), "h-end"));
    d1.appendChild(s2);
    item[0].appendChild(d1);


  if ($header.hasClass("ontime-scheduler-leftheader")) {
	item.attr("data-yi", params[0]);
    if(typeof params[2].color !== "undefined" && params[2].color != "#FFFFFF") 
      item.css("border-bottom-color", params[2].color);
  } else if($header.hasClass("ontime-scheduler-topheader")) {
	item.attr("data-xi", params[0]);
    if(typeof params[2].color !== "undefined" && params[2].color != "#FFFFFF") 
      item.css("border-right-color", params[2].color);
  }
}

function resolveWeekDayX(params, item, $header) {
    item.attr({
        "data-xi": params[0],
        "data-linkparam": params[3]
    });

    var node = createNode("span", " ", [], [
        ["data-weekday", params[1]],
        ["data-year", params[5]]
    ]);

    node.appendChild(createNode("span", params[6], ["INTLDATE", "DD", "LE"]));
    node.appendChild(createNode("span", params[7], ["INTLDATE", "MM"]));
    node.appendChild(createNode("span", params[6], ["INTLDATE", "DD", "BE"]));

    item.append(node);

    if (params[3] < data.result.displaySchedule.effectivity.startDate || params[3] > data.result.displaySchedule.effectivity.endDate)
        item.attr("data-out-of-scope", "0");

    if (params[4])
        item.attr("data-today", "0");

}

function resolveClassX(params, item, $header) {
    item.attr({
        "data-xi": params[0],
        "data-linkparam": params[1]
    });

    item.append(createNode("span", params[1]));

    var node = createNode("span", " ", [], [
        ["data-weekday", params[2]],
    ]);
    node.appendChild(createNode("span", params[4], ["INTLDATE", "DD", "LE"]));
    node.appendChild(createNode("span", params[5], ["INTLDATE", "MM"]));
    node.appendChild(createNode("span", params[4], ["INTLDATE", "DD", "BE"]));
   
    item.append(node);
}

function resolveTeacherX(params, item, $header) {
    item.attr({
        "data-xi": params[0],
        "data-linkparam": params[1]
    });

    item.append(createNode("span", params[1]));

    var node = createNode("span", " ", [], [
        ["data-weekday", params[2]],
    ]);

    node.appendChild(createNode("span", params[4], ["INTLDATE", "DD", "LE"]));
    node.appendChild(createNode("span", params[5], ["INTLDATE", "MM"]));
    node.appendChild(createNode("span", params[4], ["INTLDATE", "DD", "BE"]));

    item.append(node);
}

function resolveRoomX(params, item, $header) {
    item.attr({
        "data-xi": params[0],
        "data-linkparam": params[1]
    });

    item.append(createNode("span", params[1]));

    var node = createNode("span", " ", [], [
        ["data-weekday", params[2]],
    ]);

    node.appendChild(createNode("span", params[4], ["INTLDATE", "DD", "LE"]));
    node.appendChild(createNode("span", params[5], ["INTLDATE", "MM"]));
    node.appendChild(createNode("span", params[4], ["INTLDATE", "DD", "BE"]));

    item.append(node);
}


function resolveEventDateToX(params, item) {
	if (this.scheduler.dayView) {
		item.attr("data-xi", 1);
		item.attr("data-xs", 1);
	} else {
		
		var dx = 0;
		var d1 = params.startDate;
		var d2 = params.endDate;

		if (d1 < this.scheduler.topHeader.items[0][3])
			d1 = this.scheduler.topHeader.items[0][3];
		if (d2 > this.scheduler.topHeader.items[this.scheduler.topHeader.items.length-1][3]) {
			d2 = this.scheduler.topHeader.items[this.scheduler.topHeader.items.length-1][3];
			dx = 1;
		}

		var xindex = [7, 1, 2, 3, 4, 5, 6][ONTIME.Date.parse(d1).getDay()];
		item.attr("data-xi", xindex);

		var xs = ONTIME.Date.diff(d1, d2);
		item.attr("data-xs", xs+dx);

    }
}

function resolveDayWeekToX(params, item) {
	var xindex = 1;
	
	if (!this.scheduler.dayView) {
		if (typeof params.weekday !== "undefined")
			xindex = params.weekday;
		else if (typeof params.dates !== "undefined")
			xindex = [7, 1, 2, 3, 4, 5, 6][ONTIME.Date.parse(params.dates[0]).getDay()];
	}
	item.attr("data-xi", xindex);
}




function resolveDayWeekToY(params, item) {
	var xindex = 1;
	
	if (!this.scheduler.dayView) {
		if (typeof params.weekday !== "undefined")
			xindex = params.weekday;
		else if(typeof params.dates !== "undefined")
			xindex = [7, 1, 2, 3, 4, 5, 6][ONTIME.Date.parse(params.dates[0]).getDay()];
	}
	item.attr("data-yi", xindex);
}

function resolveTimeToAxe(params, item, headerItems, indexAttrId, spanAttrId) {
    // TBD: when resolving time to axe, proper timeframe should be considered
    if (true || typeof params._timeslots !== "object") {
        resolveTimeToAxeRaw.call(this, params, item, headerItems, indexAttrId, spanAttrId);
    } else {
        var startIndex = params._timeslots[0];
        var finishIndex = params._timeslots[params._timeslots.length - 1];

        var startOffset = getTimeDiff(params.startTime, headerItems[startIndex][2].startTime);
        var finishOffset = getTimeDiff(headerItems[finishIndex][2].endTime, params.endTime);

        item.attr(indexAttrId, headerItems[startIndex][0]);

        var span = (headerItems[finishIndex][0] - headerItems[startIndex][0]) + 1;
        if (span < 1) span = 1;

        item.attr(spanAttrId, span);

        if (startOffset > 0 || finishOffset > 0) {
            var duration = 0;
            for (var i = startIndex; i <= finishIndex; i++) {
                duration = duration + getTimeDiff(headerItems[i][2].endTime, headerItems[i][2].startTime);
            }

            if (spanAttrId == "data-ys") {
                if (startOffset > 0)
                    item.find(".ontime-scheduler-itemsharedpart").css("top", (startOffset / duration * 100) + "%");
                if (finishOffset > 0)
                    item.find(".ontime-scheduler-itemsharedpart").css("bottom", (finishOffset / duration * 100) + "%");
            } else {
                if (startOffset > 0)
                    item.find(".ontime-scheduler-itemsharedpart").css("left", (startOffset / duration * 100) + "%");
                if (finishOffset > 0)
                    item.find(".ontime-scheduler-itemsharedpart").css("right", (finishOffset / duration * 100) + "%");
            }

            item.find(".ontime-scheduler-itemcontentdata").append(
                '<span class="aTime">' + params.startTime.replace(/(\d\d)(\d\d)/, "$1:$2") + " - " + params.endTime.replace(/(\d\d)(\d\d)/, "$1:$2") + '</span> '
            );
        }
    }
}



function resolveTimeToAxeRaw(params, item, headerItems, indexAttrId, spanAttrId) {
    var timeSlotMismatch = false;

    var startOffset = 0;
    var startIndex = 0;

	if(params.startTime == "0000")
	    startIndex = 0;
	else if (params.startTime < headerItems[0][2].startTime)
		startIndex = 0;
	else if (params.startTime > headerItems[headerItems.length-1][2].endTime)
		startIndex = headerItems.length-1;
	else {
	    for (var i = headerItems.length - 1; i >= 0; i--) {
	        if(headerItems[i][2].endTime > params.startTime) {
	            startIndex = i;
	        } else {
	            break;
	        }
	    }
			
		if(params.startTime > headerItems[startIndex][2].startTime)  {
			startOffset = getTimeDiff(params.startTime, headerItems[startIndex][2].startTime);
        } else if (params.startTime < headerItems[startIndex][2].startTime) {
            timeSlotMismatch = true;
        }
	}

	var finishOffset = 0;
	var finishIndex = startIndex;
	if (params.endTime == "0000")
	    finishIndex = startIndex;
	else if (params.endTime > headerItems[headerItems.length-1][2].endTime)
	  finishIndex = headerItems.length-1;
	else {
	    for (var i = startIndex; i < headerItems.length; i++) {
		    if(headerItems[i][2].startTime < params.endTime) {
		        finishIndex = i;
		    } else {
		        break;
		    }
		}

		if (params.endTime < headerItems[finishIndex][2].endTime) {
		    finishOffset = getTimeDiff(headerItems[finishIndex][2].endTime, params.endTime);
        } else if (params.endTime > headerItems[finishIndex][2].endTime) {
            timeSlotMismatch = true;
        }

	}

	item.attr(indexAttrId, headerItems[startIndex][0]);

	var span = (headerItems[finishIndex][0] - headerItems[startIndex][0]) + 1;
	if (span < 1) span = 1;
	
	item.attr(spanAttrId, span);

	if (typeof this.scheduler.userFlags === "object") {
	    if(span > (this.scheduler.userFlags["max-" + spanAttrId] || 0))
	        this.scheduler.userFlags["max-" + spanAttrId] = span;
	    if (startOffset > 0 || finishOffset > 0)
	        this.scheduler.userFlags["offset-" + +spanAttrId] = true;
	}
	
    if (startOffset > 0 || finishOffset > 0) {
		var duration = 0;
		for(var i=startIndex; i<=finishIndex; i++) {
		  duration = duration + getTimeDiff(headerItems[i][2].endTime, headerItems[i][2].startTime);
		}
		
		if (spanAttrId == "data-ys") {
			if (startOffset > 0)
				item.find(".ontime-scheduler-itemsharedpart").css("top", (startOffset / duration * 100) + "%");
			if (finishOffset > 0)
				item.find(".ontime-scheduler-itemsharedpart").css("bottom", (finishOffset / duration * 100) + "%");
		} else {
			if (startOffset > 0)
				item.find(".ontime-scheduler-itemsharedpart").css("left", (startOffset / duration * 100) + "%");
			if (finishOffset > 0)
				item.find(".ontime-scheduler-itemsharedpart").css("right", (finishOffset / duration * 100) + "%");
		}
    }

    if (startOffset > 0 || finishOffset > 0 || timeSlotMismatch) {
        item.find(".ontime-scheduler-itemcontentdata").append(
            '<span class="aTime">' + params.startTime.replace(/(\d\d)(\d\d)/, "$1:$2") + " - " + params.endTime.replace(/(\d\d)(\d\d)/, "$1:$2") + '</span> '
        );
    }
}
function resolveEventTimeToY(params, item) {
  item.attr("data-yi", 1);
}
function resolveTimeToY(params, item) {
  resolveTimeToAxe.call(this, params, item, this.scheduler.leftHeader.items, "data-yi", "data-ys");
}
function resolveTimeToX(params, item) {
  resolveTimeToAxe.call(this, params, item, this.scheduler.topHeader.items, "data-xi", "data-xs");
}

function resolveSupervisionTimeToY(params, item) {
    var headerItems = this.scheduler.leftHeader.items;

    var startIndex = 0;
    var startOffset = 0;

    if (params.startTime < headerItems[0][2].startTime)
        startIndex = 0;
    else if (params.startTime > headerItems[headerItems.length - 1][2].endTime)
        startIndex = headerItems.length - 1;
    else {
        for (var i = 0; i < headerItems.length; i++) {
            if (params.startTime > headerItems[i][2].startTime) {
                startIndex = i;
                startOffset = getTimeDiff(params.startTime, headerItems[i][2].startTime);
            } else 
                break;
        }
    }

    item.attr("data-yi", headerItems[startIndex][0]);
    item.attr("data-ys", 1);

    if (startOffset > 0) {
        var duration = getTimeDiff(headerItems[startIndex][2].endTime, headerItems[startIndex][2].startTime);
        item.find(".ontime-scheduler-itemsharedpart").css("top", (startOffset / duration * 100) + "%");
    }
}


function resolveClassToX(params, item) {
	var xindex = 0;
	
	if (params.classCodes === undefined)
		xindex = 1;
	else {
		var dd = params.classCodes[0];
		
		for(var i=0; i<this.scheduler.topHeader.items.length; i++) {
		  if(this.scheduler.topHeader.items[i][1]==dd) {
			xindex = this.scheduler.topHeader.items[i][0];
			break;
		  }
		}
	}

	item.attr("data-xi", xindex);
}
function resolveTeacherToX(params, item) {
	var xindex = 0;

	if (params.teacherCodes === undefined)
		xindex = 1;
	else {
		if (typeof params._teacherCodesIndex === "object" && params._teacherCodesIndex[0] >= 0) {
			xindex = 1 + params._teacherCodesIndex[0];
			
			if(this.scheduler.topHeader.items[0][6] === true)
				xindex ++;
		} else {
			var dd = params.teacherCodes[0];

			// if (params.teacherCodes.length == 0)
				// xindex = 1;
			
			for (var i = 0; i < this.scheduler.topHeader.items.length; i++) {
				if (this.scheduler.topHeader.items[i][1] == dd) {
					xindex = this.scheduler.topHeader.items[i][0];
					break;
				}
			}
		}	
	}

	item.attr("data-xi", xindex);
}
function resolveRoomToX(params, item) {
	var xindex = 0;

	var dd = params.roomCodes[0];
	
	for(var i=0; i<this.scheduler.topHeader.items.length; i++) {
	  if(this.scheduler.topHeader.items[i][1]==dd) {
	    xindex = this.scheduler.topHeader.items[i][0];
		break;
	  }
	}

	item.attr("data-xi", xindex);
}

/* items data flow: title/visual resolvers */
// TODO: do not split classes/teachers/room, keep them aggregated for compacter display 
// but make individual class/teacher/room clickable



function createNode(type, text, classes, attributes) {
    var node = document.createElement(type);

    if (typeof classes === "object") {
        classes.forEach(function (e) {
            node.classList.add(e);
        });
    } else if (typeof classes === "string" && classes != "") {
        var classesA = classes.split(" ");
        classesA.forEach(function (e) {
            node.classList.add(e);
        });
    }

    if (typeof attributes === "object") {
        attributes.forEach(function (e) {
            node.setAttribute(e[0], e[1]);
        });
    } 

    if (typeof text === "string" && text != "") {
        node.appendChild(document.createTextNode(text));
    }

    return node;
}

function resolveTitle(params, item) {
    // Order: Subject - Class - Teacher - Room
    // in table-like layout Keep Class under Subject
    var content = item.find(".ontime-scheduler-itemcontentdata");

    if (currentProfile.data.interactive == "url" && typeof params.courseRef === "string" && params.courseRef.length > 0) {
        // TODO: optimize lookup - move to preprocess step
        for (var i = 0; i < data.result.courses.length; i++) {
            if (data.result.courses[i].id == params.courseRef) {
                if (typeof data.result.courses[i].url === "string" && data.result.courses[i].url.length > 0)
                    content.attr("data-linkparam", data.result.courses[i].url);
                break;
            }
        }
    }

    var v = [];
    
    var isMessage = false;


    // caption, if lesson change exists
    if (typeof params.changes === "object") {
        item.addClass("has-changes");
        item.attr("data-change-type", params.changes.changeType);

        if (typeof params.changes.newRoomCodes === "object" || typeof params.changes.absentRoomCodes === "object") {
            item.addClass("has-room-changes");
        }

        if (params.changes.cancelled) {
            item.addClass("is-cancelled");
        }

        var cls = ["davinci-b1"];
        if (params.changes.changeType == 4) {
            isMessage = true;
            cls.push("aMessage");
            item.find(".ontime-scheduler-itemcontent").addClass(((params.startTime === "0000" && params.endTime === "0000")
                ? "item-whole-day-message item-content-bg-light"
                : "item-regular-message item-content-bg-light")
            );

            if (typeof params.changes.caption !== "undefined") {
                content[0].appendChild(createNode("span", params.changes.caption, cls));
            } else {
                if (params.changes.changeType == 0 && typeof currentProfile.data.filter === "object" && typeof currentProfile.data.filter.te === "string" && currentProfile.data.filter.te != "" && typeof params.changes.newTeacherCodes === "object" && params.changes.newTeacherCodes.some(function (ee) { return currentProfile.data.filter.te == ee; }))
                    content[0].appendChild(createNode("span", "", cls, [["data-change-defaultcaption3", ""]]));
                else
                    content[0].appendChild(createNode("span", "", cls, [["data-change-defaultcaption", ""]]));
            }
        } else {
            //cls.push("aCaption");
            var dNode = createNode("div", "", (typeof params.changes.message !== "undefined") ? "aMultiCaption" : "");
            var dNode1 = createNode("div", "", "aCaptionContainer");

            if (typeof params.changes.caption !== "undefined") {
                dNode1.appendChild(createNode("div", params.changes.reasonDescription ? `${params.changes.caption}: ${params.changes.reasonDescription}`: params.changes.caption, "aCaption"));
            } else {
                if (params.changes.changeType == 0 && typeof currentProfile.data.filter === "object" && typeof currentProfile.data.filter.te === "string" && currentProfile.data.filter.te != "" && typeof params.changes.newTeacherCodes === "object" && params.changes.newTeacherCodes.some(function (ee) { return currentProfile.data.filter.te == ee; }))
                    dNode1.appendChild(createNode("div", "", "aCaption", [["data-change-defaultcaption3", ""]]));
                else
                    dNode1.appendChild(createNode("div", "", "aCaption", [["data-change-defaultcaption", ""]]));
            }

            if (typeof params.changes.message !== "undefined") {
                dNode1.appendChild(createNode("div", params.changes.message, "flipMessage"));
            }

            dNode.appendChild(dNode1);
            content[0].appendChild(dNode);
        }
    }

    // ***************
    if (isMessage) {
        var dNode = createNode("div", "", "davinci-b1");
        // text
        dNode.appendChild(createNode("span", params.changes.message || "", ["aMessageText"]));
        content[0].appendChild(dNode);
    } else {

        // cases: l1, l4, l2 (top row)
        var dNode = createNode("div", "", "davinci-b1");
        // subject
        dNode.appendChild(createNode("span", params.courseTitle || "", ["aSubject", "davinci-b2"]));

        // class
        var sNode1 = createNode("span", "", ["aClass", "layout-skip-if-l2", "davinci-b2"]);
        if (typeof params.changes === "object" && (typeof params.changes.newClassCodes === "object" || typeof params.changes.absentClassCodes === "object")) {
            pushCodesDefinition2(sNode1, params.changes.newClassCodes, "aChange aNewItem");
            pushCodesDefinition2(sNode1, params.changes.absentClassCodes, "aChange aAbsItem");
            pushCodesDefinition2(sNode1, (params.classCodes || []).filter(
                function (ee) {
                    return (
                        !(params.changes.newClassCodes || []).some(function (eee) { return (eee == ee); }) &&
                        !(params.changes.absentClassCodes || []).some(function (eee) { return (eee == ee); })
                    );
                }), ""
            );
        } else {
            pushCodesDefinition2(sNode1, params.classCodes, "");
        }
        dNode.appendChild(sNode1);


        // teacher
        var sNode2 = createNode("span", "", ["aTeacher", "content-last", "davinci-b2"]);
        if (typeof params.changes === "object" && (typeof params.changes.newTeacherCodes === "object" || typeof params.changes.absentTeacherCodes === "object")) {
            // show changes
            pushCodesDefinition3(sNode2, params.changes.newTeacherCodes, getTeacherDisplayNames(params.changes.newTeacherCodes), "aChange aNewItem");
            pushCodesDefinition3(sNode2, params.changes.absentTeacherCodes, getTeacherDisplayNames(params.changes.absentTeacherCodes), "aChange aAbsItem");

            var t = (params.teacherCodes || []).filter(
                function (ee) {
                    return (
                        !(params.changes.newTeacherCodes || []).some(function (eee) { return (eee == ee); }) &&
                        !(params.changes.absentTeacherCodes || []).some(function (eee) { return (eee == ee); })
                    );
                });


            pushCodesDefinition3(sNode2, t, getTeacherDisplayNames(t), "");
        } else {
            pushCodesDefinition3(sNode2, params.teacherCodes, getTeacherDisplayNames(params.teacherCodes), "");
        }
        dNode.appendChild(sNode2);


        // room
        var sNode3 = createNode("span", "", ["aRoom", "content-last", "layout-skip-if-l2", "davinci-b2"]);
        if (typeof params.changes === "object" && (typeof params.changes.newRoomCodes === "object" || typeof params.changes.absentRoomCodes === "object")) {
            // show changes
            pushCodesDefinition2(sNode3, params.changes.newRoomCodes, "aChange aNewItem");
            pushCodesDefinition2(sNode3, params.changes.absentRoomCodes, "aChange aAbsItem");
            pushCodesDefinition2(sNode3, (params.roomCodes || []).filter(
                function (ee) {
                    return (
                        !(params.changes.newRoomCodes || []).some(function (eee) { return (eee == ee); }) &&
                        !(params.changes.absentRoomCodes || []).some(function (eee) { return (eee == ee); })
                    );
                }), "");
        } else {
            pushCodesDefinition2(sNode3, params.roomCodes, "");
        }
        dNode.appendChild(sNode3);

        content[0].appendChild(dNode);

        // ***************


        // cases: l2 (bottom row)
        var dNode2 = createNode("div", "", ["layout-skip-if-l1", "layout-skip-if-l4", "davinci-b1"]);

        var sNode4 = createNode("span", "", ["aClass", "davinci-b2"]);
        if (typeof params.changes === "object" && (typeof params.changes.newClassCodes === "object" || typeof params.changes.absentClassCodes === "object")) {
            pushCodesDefinition2(sNode4, params.changes.newClassCodes, "aChange aNewItem");
            pushCodesDefinition2(sNode4, params.changes.absentClassCodes, "aChange aAbsItem");
            pushCodesDefinition2(sNode4, (params.classCodes || []).filter(
                function (ee) {
                    return (
                        !(params.changes.newClassCodes || []).some(function (eee) { return (eee == ee); }) &&
                        !(params.changes.absentClassCodes || []).some(function (eee) { return (eee == ee); })
                    );
                }), ""
            );
        } else {
            pushCodesDefinition2(sNode4, params.classCodes, "");
        }
        dNode2.appendChild(sNode4);

        // room
        var sNode5 = createNode("span", "", ["aRoom", "content-last", "davinci-b2"]);
        if (typeof params.changes === "object" && (typeof params.changes.newRoomCodes === "object" || typeof params.changes.absentRoomCodes === "object")) {
            // show changes
            pushCodesDefinition2(sNode5, params.changes.newRoomCodes, "aChange aNewItem");
            pushCodesDefinition2(sNode5, params.changes.absentRoomCodes, "aChange aAbsItem");
            pushCodesDefinition2(sNode5, (params.roomCodes || []).filter(
                function (ee) {
                    return (
                        !(params.changes.newRoomCodes || []).some(function (eee) { return (eee == ee); }) &&
                        !(params.changes.absentRoomCodes || []).some(function (eee) { return (eee == ee); })
                    );
                }), "");
        } else {
            pushCodesDefinition2(sNode5, params.roomCodes, "");
        }
        dNode2.appendChild(sNode5);

        content[0].appendChild(dNode2);

        var showRemarks = false;
        if (showRemarks && params._courseIndex !== undefined && data.result.courses[params._courseIndex].remarks !== undefined && data.result.courses[params._courseIndex].remarks.length > 0) {
            var dNodeRemarks = createNode("div", "", ["davinci-b1"]);
            var sNodeRemarks = createNode("span", data.result.courses[params._courseIndex].remarks, ["aRemark"]);
            dNodeRemarks.appendChild(sNodeRemarks);
            content[0].appendChild(dNodeRemarks);
        }

        // ***************

        var x = parseInt(item.attr("data-xi")) + parseInt(item.attr("data-xs")) - 2;
        var y = parseInt(item.attr("data-yi")) + parseInt(item.attr("data-ys")) - 2;

        if (typeof this.scheduler.leftHeader.items[y][2] === "object" && typeof this.scheduler.leftHeader.items[y][2].color !== "undefined" && this.scheduler.leftHeader.items[y][2].color != "#FFFFFF") {
            item.css("border-bottom-color", this.scheduler.leftHeader.items[y][2].color);
        }
        if (typeof this.scheduler.topHeader.items[x][2] === "object" && typeof this.scheduler.topHeader.items[x][2].color !== "undefined" && this.scheduler.topHeader.items[x][2].color != "#FFFFFF") {
            item.css("border-right-color", this.scheduler.topHeader.items[x][2].color);
        }


        // TBD: Shadow vs LessonColor/LessonGradient CONFLICT!

        if (typeof params.Shadow !== "undefined")
            item.find(".ontime-scheduler-itemcontent").addClass("itemShadow");

        if (data.result.displaySchedule.display.lessonGradient != 0) {
            var refCollectionProperty = ["", "subjects", "classes", "teachers", "rooms"];
            var refParamProperty = ["", "subjectCode", "classCodes", "teacherCodes", "roomCodes"];

            if (data.result.displaySchedule.display.lessonColor > 0 && data.result.displaySchedule.display.lessonColor <= 4) {
                var refCollection = data.result[refCollectionProperty[data.result.displaySchedule.display.lessonColor]];

                // TODO: optimize lookup performance
                if (typeof params[refParamProperty[data.result.displaySchedule.display.lessonColor]] !== "undefined") {
                    for (var i = 0; i < refCollection.length; i++) {
                        if (
                            data.result.displaySchedule.display.lessonColor == 1
                                ? (params[refParamProperty[data.result.displaySchedule.display.lessonColor]] === refCollection[i].code)
                                : (params[refParamProperty[data.result.displaySchedule.display.lessonColor]].indexOf(refCollection[i].code) >= 0)
                        ) {
                            if (data.result.displaySchedule.display.lessonGradient == 1) {
                                item.find(".ontime-scheduler-itemcontent").css("background-image", "linear-gradient(" + refCollection[i].color + ", " + refCollection[i].color + "), linear-gradient(rgba(0,0,0,0), rgba(0,0,0,0))");
                            } else if (data.result.displaySchedule.display.lessonGradient == 2) {
                                item.find(".ontime-scheduler-itemcontent").css("background-color", refCollection[i].color);
                            }

                            if (typeof params.changes === "object" && typeof params.changes.cancelled !== "undefined") {
                                item.find(".ontime-scheduler-itemcontentdata").addClass("bgHatch");
                            }

                            if (data.result.displaySchedule.display.lessonGradient == 2 && isColorDark(refCollection[i].color))
                                item.find(".ontime-scheduler-itemcontent").addClass("item-content-bg-dark");
                            if (isColorLight(refCollection[i].color))
                                item.find(".ontime-scheduler-itemcontent").addClass("item-content-bg-light");

                            break;
                        }
                    }
                }
            }
        }
    }
}
function pushCodesDefinition(v, codes, cssClass) {
    if (typeof codes === "object")
        for (var i = 0; i < codes.length; i++)
            v.push('<span class="' + cssClass + '" data-linkparam="' + codes[i] + '">' + codes[i] + '</span>');
}

function pushCodesDefinition2(v, codes, cssClass) {
    if (typeof codes === "object")
        for (var i = 0; i < codes.length; i++) {
            v.appendChild(createNode("span", codes[i], cssClass, [["data-linkparam", codes[i]]]));
        }
}

function pushCodesDefinition3(v, codes, names, cssClass) {
    if (typeof codes === "object")
        for (var i = 0; i < codes.length; i++) {
            v.appendChild(createNode("span", names[i], cssClass, [["data-linkparam", codes[i]]]));
        }
}

function resolveSupervisionTitle(params, item) {
    var content = item.find(".ontime-scheduler-itemcontentdata");
    content[0].appendChild(createNode("span", params.supervisionTitle, "aSupervisionCaption"));
    if (params.changes) 
        content[0].classList.add("changes");
}
function resolveEventTitle(params, item) {
  var content = item.find(".ontime-scheduler-itemcontentdata");
  content.append('<span class="aEventCaption">' + params.eventCaption + '</span> ');
}

function resolveAbsenceTitle(params, item) {
    var content = item.find(".ontime-scheduler-itemcontentdata");
    if (params._reasonRefIndex != undefined && params._reasonRefTarget != undefined) {
        content.append('<span class="aCaption">' + data.result[params._reasonRefTarget][params._reasonRefIndex].description + '</span> ');
    } else {
        content.append('<span class="aCaption">' + "Abwesend" + '</span> ');
    }
}



function getTeacherDisplayNames(teacherCodes) {
    if (typeof teacherCodes !== "undefined" && (typeof currentProfile.data.teacherDisplayName === "object" || typeof currentProfile.data.teacherDisplayName === "string")) {
        var r = [];

        // TODO: use _teacherCodesIndex array instead
        teacherCodes.forEach(function (e) {
            var i = getTeacherIndex(e);
            if (i >= 0 && i < data.result.teachers.length) {
                var s = getTeacherDisplayFields(data.result.teachers[i], currentProfile.data.teacherDisplayName).join(" ").trim();
                if (typeof s === "string" && s != "")
                    r.push(s);
                else
                    r.push(e);
            } else
                r.push(e);
        });

        return r;
    } else {
        return teacherCodes;
    }
}
function getTeacherIndex(teacherCode) {
    for(var i=0; i < data.result.teachers.length; i++) {
        if (data.result.teachers[i].code == teacherCode)
            return i;
    }

    return -1;
}
function getTeacherDisplayFields(teacher, fields) {
    var r = [];

    if(typeof fields === "string")
        r.push(teacher[fields]);
    else 
        fields.forEach(function (e) {
            r.push(teacher[e]);
        });

    return r;
}


/* aux functions */
function getTimeDiff(t2, t1) {
    //HHMM expected as string
    if (t1 === t2)
        return 0;
    else
        return parseInt(t2.substr(2, 2)) - parseInt(t1.substr(2, 2)) + 60 * (parseInt(t2.substr(0, 2)) - parseInt(t1.substr(0, 2)))
}

function isColorDark(color) {
    var i = getColorIntensity(color);
    return ((i != -1) && (i < 0x8000));
}
function isColorLight(color) {
    var i = getColorIntensity(color);
    return ((i != -1) && (i >= 0x8000));
}

function getColorIntensity(color) {
    if (typeof color === "string" && color.length == 7 && color.charAt(0) == "#") {
        var rgb = parseInt(color.slice(1), 16);
        if (rgb >= 0 && rgb <= 0xFFFFFF) {
            var r = (rgb & 0xFF0000) >> 16;
            var g = (rgb & 0x00FF00) >> 8;
            var b = (rgb & 0x0000FF);

            return r * 77 + g * 151 + b * 28;
        }
    }
    return -1;
}

function lookupTimeframeIndex(item, d) {
    if (typeof d !== "object")
        d = data;

    var r = 0;

    if (typeof item.supervisionTitle !== "undefined") {
        // find first 
        // TODO: take areaCode for resolving timeframe
        var k = arrayLookup(d.result.timeframes, "Aufsichten", "code");
        if (k >= 0)
            r = k;
    } else {
        // TODO: check not only 0th class
        // TODO: check not only class/room, but also room
        if (typeof item._classCodesIndex === "object" && item._classCodesIndex.length > 0 && item._classCodesIndex[0] >= 0 && item._classCodesIndex[0] < d.result.classes.length) {
            if (typeof d.result.classes[item._classCodesIndex[0]]._timeframeIndex == "number")
                r = d.result.classes[item._classCodesIndex[0]]._timeframeIndex;
        } else if (typeof item._teacherCodesIndex === "object" && item._teacherCodesIndex.length > 0 && item._teacherCodesIndex[0] >= 0 && item._teacherCodesIndex[0] < d.result.teachers.length) {
            if (typeof d.result.teachers[item._teacherCodesIndex[0]]._timeframeIndex == "number")
                r = d.result.teachers[item._teacherCodesIndex[0]]._timeframeIndex;
        }
    }

    return r;
}

function lookupTimeslotIndex(t, timeframeIndex, matchStart, matchEnd, timeframes) {
    var timeslotIndex = 0;
    var e = timeframes[timeframeIndex].timeslots.length - 1;

    if (t < timeframes[timeframeIndex].timeslots[0].endTime)
        timeslotIndex = 0;
    else if (matchEnd && (t == timeframes[timeframeIndex].timeslots[0].endTime))
        timeslotIndex = 0;
    else if (t > timeframes[timeframeIndex].timeslots[e].startTime)
        timeslotIndex = e;
    else if (matchStart && (t == timeframes[timeframeIndex].timeslots[e].startTime))
        timeslotIndex = e;
    else {
        for (var i = 1; i < e; i++) {
            if (
                (
                    (t > timeframes[timeframeIndex].timeslots[i].startTime) || 
                    (matchStart && (t == timeframes[timeframeIndex].timeslots[i].startTime))
                )
                &&
                (
                    (t < timeframes[timeframeIndex].timeslots[i].endTime) ||
                    (matchEnd && (t == timeframes[timeframeIndex].timeslots[i].endTime))
                )
            ) {
                timeslotIndex = i;
                break;
            }
        }
    }

    return timeslotIndex;
}


function davinciDataPreprocess(d) {
    filterProfileData(d);
    buildHelperData(d);
    return d;
}

function checkProfileRights(t, code) {
    // access rights as union of profile's access rights

/*
    policy_Timetable = 'daVinciIS.Timetables';
    policy_Timetable_No = 1;  // no teacher/student timetables
    policy_Timetable_Guest = 2;  // no teacher/student timetables
    policy_Timetable_Student = 3;  // my student timetable
    policy_Timetable_Class = 4;  // the class timetable
    policy_Timetable_Teacher = 5;  // my teacher timetable
    policy_Timetable_Team = 6;  // my team timetables
    policy_Timetable_TeamMaster = 7;  // All team timetables
    policy_Timetable_Staff = 8;  // no teacher timetables
    policy_Timetable_Master = 9;  // all
    policy_Timetable_Subst = 10; // substition list only
    policy_Timetable_Rooms = 11; // substition list and room schedules
    policy_Timetable_Classes = 12; // substition list and room/class schedules
    policy_Timetable_Teachers = 13; // substition list and room/class/teacher schedules
    policy_Timetable_TeacherAllSubst = 14; // ( = policy_Timetable_Teacher = 5 ) + all subst
*/

    var r = false;
    // "master", "default", "class", "student", "teacher", "team", "teammaster","guest", "staff"

    // access to all objects of certain type
    for (var pi = 0; pi < data.users.length; pi++) {
        if (["master", "default"].indexOf(data.users[pi].profile) != -1)
        {
            r = true; // those can access schedule of any object
            break;
        } else if ((t == "cl" || t == "ro") &&
            ["teacher", "staff"].indexOf(data.users[pi].profile) != -1) {
            r = true;
            break;
        } else if ("guest" === data.users[pi].profile) {
            if (t == "cl") {
                r = ([12, 13].indexOf(data.users[pi].policy) >= 0);
                break;
            } else if (t == "ro") {
                r = ([2, 11, 12, 13].indexOf(data.users[pi].policy) >= 0);
                break;
            } else if (t == "te") {
                r = (13 === data.users[pi].policy);
                break;
            }
        }
    }

    if (!r) {
        if (t == "cl") {
            var hasTeamAccess = false;
            for (var pi = 0; pi < data.users.length; pi++) {
                if (data.users[pi].filter == "cl" && data.users[pi].code == code) { // preset for class & student profiles
                    r = true;// can access only own class schedule
                    break;
                } else if (data.users[pi].profile == "student" && data.users[pi].classCode == code) {
                    r = true;// can access only own class schedule
                    break;
                } else if (["teammaster", "team"].indexOf(data.users[pi].profile) != -1) {
                    hasTeamAccess = true;
                }
            }

            if (!r && hasTeamAccess) {
                var k = arrayLookup(data.result.classes, code, "code");
                if (k >= 0 && data.result.classes[k]._allow)
                    r = true; // team can access only team classes (those are marked)
            }
        } else if (t == "ro") {
            for (var pi = 0; pi < data.users.length; pi++) {
                if (["teammaster", "team"].indexOf(data.users[pi].profile) != -1) {
                    var k = arrayLookup(data.result.rooms, code, "code");
                    if (k >= 0 && data.result.rooms[k]._allow)
                        r = true; // team can access only team rooms (those are marked)

                    break;
                }
            }
        } else if (t == "te") {
            var hasTeamAccess = false;
            for (var pi = 0; pi < data.users.length; pi++) {
                if (data.users[pi].filter == "te" && data.users[pi].code == code) { // preset for teacher & team & teammaster profiles
                    r = true;// can access self schedule
                    break;
                } else if (["teammaster", "team"].indexOf(data.users[pi].profile) != -1) {
                    hasTeamAccess = true;
                }
            }

            if (!r && hasTeamAccess) {
                var k = arrayLookup(data.result.teachers, code, "code");
                if (k >= 0 && data.result.teachers[k]._allow)
                    r = true; // team can access only teachers classes (those are marked)
            }
        }
    }

    return r;
}

function filterProfileData(d) {

    // validate and build user/users profile objects
    if (typeof d.user === "object") {
        // build users from user
        if (typeof d.users !== "object") {
            d.users = [];
            d.users.push(d.user);
        }
    } else {
        // extract user object as first users item 
        if (typeof d.users === "object" && d.users.length > 0) {
            d.user = d.users[0];
        } else {
            // otherwise dummy
            d.user = {
                profile: "default",
            };
            d.users = [];
            d.users.push(d.user);
        }
    }
    // mark lessons items (not) used for profile
    for (var pi = 0; pi < d.users.length; pi++) 
        filterProfileItemData(d, pi);
    
    with (d.result.displaySchedule) {
        if (typeof lessonTimes === "object") {
            for (var i = lessonTimes.length - 1; i >= 0; i--) {
                if (typeof lessonTimes[i]._blockInProfile === "object" && lessonTimes[i]._blockInProfile.length == d.users.length) {
                    // blocked in all profiles - remove
                    lessonTimes.splice(i, 1);
                }
            }
        }
    }
}

function filterProfileItemData(d, pi) {

    if (d.users[pi].profile == "class") {
        if (d.users[pi].homeType.toLowerCase() == "class" && typeof d.users[pi].homeId === "string") {
            // show only given class
            var homeCode = "";
            var k = arrayLookup(d.result.classes, d.users[pi].homeId, "id");
            if (k >= 0) {
                homeCode = d.result.classes[k].code;
                d.result.classes[k]._allow = true;

                with (d.result.displaySchedule) {
                    if (typeof lessonTimes === "object") {
                        for (var i = lessonTimes.length - 1; i >= 0; i--) {
                            if (typeof lessonTimes[i].classCodes == "object" && lessonTimes[i].classCodes.length > 0 && lessonTimes[i].classCodes.indexOf(homeCode) == -1) {
                                if (typeof lessonTimes[i]._blockInProfile !== "object")
                                    lessonTimes[i]._blockInProfile = [];
                                lessonTimes[i]._blockInProfile.push(pi);
                            }
                        }
                    }
                }
            }
        }
    } else if (d.users[pi].profile == "student") {
        if (d.users[pi].homeType.toLowerCase() == "student" && typeof d.users[pi].homeId === "string") {
            d.users[pi].name = (d.users[pi].firstName || "") + " " + (d.users[pi].lastName || "");

            // show selected student (via courses)

            var studentCourseRefs = [];
            var classCourseRefs = [];
            if (typeof d.result.courses === "object") {
                for (var k = 0; k < d.result.courses.length; k++) {
                    if (typeof d.result.courses[k].studentRefs === "object") {
                        if (d.result.courses[k].studentRefs.indexOf(d.users[pi].homeId) >= 0) {
                            // course is bound to this student
                            studentCourseRefs.push(d.result.courses[k].id);
                        } else if (d.result.courses[k].studentRefs.length == 0) {
                            // course is not bound to any student (empty list)
                            classCourseRefs.push(d.result.courses[k].id);
                        }
                    } else {
                        // course is not bound student at all (no list)
                        classCourseRefs.push(d.result.courses[k].id);
                    }
                }
            }

            with (d.result.displaySchedule) {
                if (typeof lessonTimes === "object") {
                    for (var i = lessonTimes.length - 1; i >= 0; i--) {
                        if (studentCourseRefs.indexOf(lessonTimes[i].courseRef) >= 0) {
                            // student's course
                        } else if (
                            (typeof lessonTimes[i].studentRefs === "object" && lessonTimes[i].studentRefs.indexOf(d.users[pi].homeId) >= 0)
                            ||
                            (
                                typeof lessonTimes[i].classCodes === "object" &&
                                lessonTimes[i].classCodes.indexOf(d.users[pi].classCode) >= 0 &&
                                (
                                    lessonTimes[i].courseRef === undefined ||
                                    classCourseRefs.indexOf(lessonTimes[i].courseRef) >= 0
                                )
                            )
                        ) {
                            // class's lesson, not bound to student's course
                        } else {
                            // neither

                            if (typeof lessonTimes[i]._blockInProfile !== "object")
                                lessonTimes[i]._blockInProfile = [];
                            lessonTimes[i]._blockInProfile.push(pi);
                        }
                    }
                }
            }
        }
        
    } else if ((d.users[pi].profile == "team") || (d.users[pi].profile == "teammaster")) {
        if (d.users[pi].homeType.toLowerCase() == "teacher" && typeof d.users[pi].homeId === "string") {
            // show only given teacher
            // + teamRef
            
            var teamRefs = [];
            var k = arrayLookup(d.result.teachers, d.users[pi].homeId, "id");
            if(k >= 0)
                teamRefs = (d.result.teachers[k].teamRefs || []);

            if (teamRefs.length > 0) {

                var teamClassCodes = [];
                var teamTeacherCodes = [];
                var teamRoomCodes = [];


                for (var k = d.result.classes.length - 1; k >= 0; k--) {
                    if (areArraysIntersected(teamRefs, d.result.classes[k].teamRefs)) {
                        teamClassCodes.push(d.result.classes[k].code);
                        d.result.classes[k]._allow = true;
                    }
                }

                for (var k = d.result.teachers.length - 1; k >= 0; k--) {
                    if (areArraysIntersected(teamRefs, d.result.teachers[k].teamRefs)) {
                        teamTeacherCodes.push(d.result.teachers[k].code);
                        if (d.users[pi].profile == "teammaster")
                            d.result.teachers[k]._allow = true;
                    }
                }

                for (var k = d.result.rooms.length - 1; k >= 0; k--) {
                    if (areArraysIntersected(teamRefs, d.result.rooms[k].teamRefs)) {
                        teamRoomCodes.push(d.result.rooms[k].code);
                        d.result.rooms[k]._allow = true;
                    }
                }

                with (d.result.displaySchedule) {
                    if (typeof lessonTimes === "object") {
                        for (var i = lessonTimes.length - 1; i >= 0; i--) {
                            if (!(
                                areArraysIntersected(teamClassCodes, lessonTimes[i].classCodes) ||
                                areArraysIntersected(teamTeacherCodes, lessonTimes[i].teacherCodes) ||
                                areArraysIntersected(teamRoomCodes, lessonTimes[i].roomCodes)
                            )) {
                                if (typeof lessonTimes[i]._blockInProfile !== "object")
                                    lessonTimes[i]._blockInProfile = [];
                                lessonTimes[i]._blockInProfile.push(pi);
                            }
                        }
                    }
                }
            }
        }
    } else {
        for (var k = d.result.classes.length - 1; k >= 0; k--) 
            d.result.classes[k]._allow = true;
        
        for (var k = d.result.rooms.length - 1; k >= 0; k--) 
            d.result.rooms[k]._allow = true;

        if (d.users[pi].profile == "master" || d.users[pi].profile == "default")
            for (var k = d.result.teachers.length - 1; k >= 0; k--)
                d.result.teachers[k]._allow = true;
    }
}

function areArraysIntersected(a1, a2) {
    if(typeof a2 === "object") {
        for (var i = 0; i < a1.length; i++) {
            if (a2.indexOf(a1[i]) >= 0)
                return true;
        }
    }
    return false;
}

function buildHelperData(d) {
    var teacherTeamRef = (currentProfile.data.teamRef.indexOf("teachers") >= 0);
    var classTeamRef = (currentProfile.data.teamRef.indexOf("classes") >= 0);
    var roomTeamRef = (currentProfile.data.teamRef.indexOf("rooms") >= 0);

    function _normalizeProfileReference() {
        // extend profile reference - filter type and code
        for (var i = 0; i < d.users.length; i++) {
            if (d.users[i].homeType == "teacher") {
                var index = arrayLookup(d.result.teachers, d.users[i].homeId, "id");
                if (index >= 0) {
                    d.users[i].filter = "te";
                    d.users[i].code = d.result.teachers[index].code;
                }
            } else if (d.users[i].homeType == "class") {
                var index = arrayLookup(d.result.classes, d.users[i].homeId, "id");
                if (index >= 0) {
                    d.users[i].filter = "cl";
                    d.users[i].code = d.result.classes[index].code;
                }
            }
        }
    }
    _normalizeProfileReference();

    function _buildTimeframeIndex() {
        [d.result.classes, d.result.teachers, d.result.rooms].forEach(function (e) {
            for (var i = 0; i < e.length; i++) {
                if (typeof e[i].timeframeCode === "string")
                    e[i]._timeframeIndex = arrayLookup(d.result.timeframes, e[i].timeframeCode, "code");
                else
                    e[i]._timeframeIndex = 0;
            }
        });
    }
    _buildTimeframeIndex();

    function _normalizeTeacherAbsences() {
        if (typeof d.result.teacherAbsences === "object") {
            d.result.teacherAbsences.forEach(function (e) {
                var i = arrayLookup(d.result.teachers, e.teacherRef, "id");
                if (i >= 0) {
                    e.teacherCodes = [d.result.teachers[i].code];
                    e._teacherCodesIndex = [i];
                }
                i = arrayLookup(d.result.teacherAbsenceReasons, e.reasonRef, "id");
                if (i >= 0) {
                    e._reasonRefIndex = i;
                    e._reasonRefTarget = "teacherAbsenceReasons";
                }

                resolveTimeframeTimeslots(e, d);

                e.dates = [];
                if (e.startDate.localeCompare(e.endDate)) {
                    var startDate = ONTIME.Date.parse(e.startDate);
                    while (startDate.format("YYYYMMDD").localeCompare(e.endDate) <= 0) {
                        var wd = startDate.getDay();
                        if (
                            wd >= d.result.displaySchedule.weekspan.weekdayStart ||
                            wd <= (d.result.displaySchedule.weekspan.weekdayEnd || 7)
                        ) {
                            e.dates.push(startDate.format("YYYYMMDD"));
                        }
                        startDate.offset(1);
                    }
                }
                if (e.dates.length == 0) {
                    e.dates.push(e.startDate);
                }
            });
        }
    }
    _normalizeTeacherAbsences();

    function _normalizeClassAbsences() {
        if (typeof d.result.classAbsences === "object") {
            d.result.classAbsences.forEach(function (e) {
                var i = arrayLookup(d.result.classes, e.classRef, "id");
                if (i >= 0) {
                    e.classCodes = [d.result.classes[i].code];
                    e._classCodesIndex = [i];
                }
                i = arrayLookup(d.result.classAbsenceReasons, e.reasonRef, "id");
                if (i >= 0) {
                    e._reasonRefIndex = i;
                    e._reasonRefTarget = "classAbsenceReasons";
                }

                resolveTimeframeTimeslots(e, d);

                e.dates = [];
                if (e.startDate.localeCompare(e.endDate)) {
                    var startDate = ONTIME.Date.parse(e.startDate);
                    while (startDate.format("YYYYMMDD").localeCompare(e.endDate) <= 0) {
                        var wd = startDate.getDay();
                        if (
                            wd >= d.result.displaySchedule.weekspan.weekdayStart ||
                            wd <= (d.result.displaySchedule.weekspan.weekdayEnd || 7)
                        ) {
                            e.dates.push(startDate.format("YYYYMMDD"));
                        }
                        startDate.offset(1);
                    }
                }
                if (e.dates.length == 0) {
                    e.dates.push(e.startDate);
                }
            });
        }
    }
    _normalizeClassAbsences();

    function _normalizeRoomAbsences() {
        if (typeof d.result.roomAbsences === "object") {
            d.result.roomAbsences.forEach(function (e) {
                var i = arrayLookup(d.result.rooms, e.roomRef, "id");
                if (i >= 0) {
                    e.roomCodes = [d.result.rooms[i].code];
                    e._roomCodesIndex = [i];
                }
                i = arrayLookup(d.result.roomAbsenceReasons, e.reasonRef, "id");
                if (i >= 0) {
                    e._reasonRefIndex = i;
                    e._reasonRefTarget = "roomAbsenceReasons";
                }

                resolveTimeframeTimeslots(e, d);

                e.dates = [];
                if (e.startDate.localeCompare(e.endDate)) {
                    var startDate = ONTIME.Date.parse(e.startDate);
                    while (startDate.format("YYYYMMDD").localeCompare(e.endDate) <= 0) {
                        var wd = startDate.getDay();
                        if (
                            wd >= d.result.displaySchedule.weekspan.weekdayStart ||
                            wd <= (d.result.displaySchedule.weekspan.weekdayEnd || 7)
                        ) {
                            e.dates.push(startDate.format("YYYYMMDD"));
                        }
                        startDate.offset(1);
                    }
                }
                if (e.dates.length == 0) {
                    e.dates.push(e.startDate);
                }
            });
        }
    }
    _normalizeRoomAbsences();
    
    function _normalizeLessonTimes() {
        with (d.result.displaySchedule) {
            if (typeof lessonTimes === "object") {
                for (var i = 0; i < lessonTimes.length; i++) {
                    // key
                    lessonTimes[i]._i = i;

                    // temporary patching, remove later
                    if (typeof lessonTimes[i].buildingCodes === "string")
                        lessonTimes[i].buildingCodes = [lessonTimes[i].buildingCodes];

                    // build teamRefs
                    lessonTimes[i]._teamRefs = [];

                    // optimize teacher lookup
                    if (typeof lessonTimes[i]._teacherCodesIndex !== "object" && typeof lessonTimes[i].teacherCodes === "object") {
                        lessonTimes[i]._teacherCodesIndex = [];
                        for (var j = 0; j < lessonTimes[i].teacherCodes.length; j++) {
                            var k = arrayLookup(d.result.teachers, lessonTimes[i].teacherCodes[j], "code");
                            if (k != -1) {
                                lessonTimes[i]._teacherCodesIndex[j] = k;

                                if (teacherTeamRef && typeof d.result.teachers[k].teamRefs === "object")
                                    Array.prototype.push.apply(lessonTimes[i]._teamRefs, d.result.teachers[k].teamRefs);
                            }
                        }
                    }

                    // optimize class lookup
                    if (typeof lessonTimes[i]._classCodesIndex !== "object" && typeof lessonTimes[i].classCodes === "object") {
                        lessonTimes[i]._classCodesIndex = [];
                        for (var j = 0; j < lessonTimes[i].classCodes.length; j++) {
                            var k = arrayLookup(d.result.classes, lessonTimes[i].classCodes[j], "code");
                            if (k != -1) {
                                lessonTimes[i]._classCodesIndex[j] = k;

                                if (classTeamRef && typeof d.result.classes[k].teamRefs === "object")
                                    Array.prototype.push.apply(lessonTimes[i]._teamRefs, d.result.classes[k].teamRefs);
                            }
                        }
                    }

                    // optimize room lookup
                    if (typeof lessonTimes[i]._roomCodesIndex !== "object" && typeof lessonTimes[i].roomCodes === "object") {
                        lessonTimes[i]._roomCodesIndex = [];
                        for (var j = 0; j < lessonTimes[i].roomCodes.length; j++) {
                            var k = arrayLookup(d.result.rooms, lessonTimes[i].roomCodes[j], "code");
                            if (k != -1) {
                                lessonTimes[i]._roomCodesIndex[j] = k;

                                if (roomTeamRef && typeof d.result.rooms[k].teamRefs === "object")
                                    Array.prototype.push.apply(lessonTimes[i]._teamRefs, d.result.rooms[k].teamRefs);
                            }
                        }
                    }

                    // optimize subject lookup
                    if (typeof lessonTimes[i]._subjectCodesIndex !== "number" && typeof lessonTimes[i].subjectCode === "string") {
                        lessonTimes[i]._subjectCodesIndex = [];
                        var k = arrayLookup(d.result.subjects, lessonTimes[i].subjectCode, "code");
                        if (k != -1) {
                            lessonTimes[i]._subjectCodesIndex[0] = k;

                            if (currentProfile.data.teamRef.indexOf("subject") >= 0 && typeof d.result.subjects[k].teamRefs === "object")
                                Array.prototype.push.apply(lessonTimes[i]._teamRefs, d.result.subjects[k].teamRefs);
                        }
                    }

                    // optimize course lookup
                    if (typeof lessonTimes[i]._courseIndex !== "number" && typeof lessonTimes[i].courseRef === "string") {
                        var k = arrayLookup(d.result.courses, lessonTimes[i].courseRef, "id");
                        if (k != -1) {
                            lessonTimes[i]._courseIndex = k;
                        }
                    }

                    // optimize building lookup
                    if (typeof lessonTimes[i]._buildingCodesIndex !== "object" && typeof lessonTimes[i].buildingCodes === "object") {
                        lessonTimes[i]._buildingCodesIndex = [];
                        for (var j = 0; j < lessonTimes[i].buildingCodes.length; j++) {
                            var k = arrayLookup(d.result.buildings, lessonTimes[i].buildingCodes[j], "code");
                            if (k != -1) {
                                lessonTimes[i]._buildingCodesIndex[j] = k;
                            }
                        }
                    }

                    // optimize team lookup
                    if (lessonTimes[i]._teamRefs.length > 0) {

                        lessonTimes[i].teamCodes = [];

                        // make unique
                        if (lessonTimes[i]._teamRefs.length > 1) {
                            lessonTimes[i]._teamRefs.sort();
                            for (var j = lessonTimes[i]._teamRefs.length - 1; j >= 1; j--) {
                                if (lessonTimes[i]._teamRefs[j] == lessonTimes[i]._teamRefs[j - 1])
                                    lessonTimes[i]._teamRefs.splice(j, 1)
                            }
                        }

                        // lookup/resolve
                        for (var j = 0; j < lessonTimes[i]._teamRefs.length; j++) {
                            var k = arrayLookup(d.result.teams, lessonTimes[i]._teamRefs[j], "id");
                            if (k != -1)
                                lessonTimes[i].teamCodes.push(d.result.teams[k].code);
                        }
                    }

                    resolveTimeframeTimeslots(lessonTimes[i], d);
                }
            }
        }
    }
    _normalizeLessonTimes();

    function _normalizeEventTimes() {
        if (typeof d.result.displaySchedule.eventTimes === "object") {
            d.result.displaySchedule.eventTimes.forEach(function (e, i) {
                if (e.participants !== undefined) {
                    if (d.result.classes !== undefined) {
                        var cl = d.result.classes
                            .filter(function (ee) {
                                return e.participants.includes(ee.id);
                            });

                        if (cl.length) {
                            cl.forEach(function (ee) {
                                if (ee._ev === undefined)
                                    ee._ev = [i];
                                else
                                    ee._ev.push(i);
                            });

                            e._cl = cl.map(function (ee) {
                                return ee.code;
                            });
                        }
                    }

                    if (d.result.teachers !== undefined) {
                        var te = d.result.teachers
                            .filter(function (ee) {
                                return e.participants.includes(ee.id);
                            });

                        if (te.length) {
                            te.forEach(function (ee) {
                                if (ee._ev === undefined)
                                    ee._ev = [i];
                                else
                                    ee._ev.push(i);
                            });

                            e._te = te.map(function (ee) {
                                return ee.code;
                            });
                        }
                    }
                    
                }
            });

            
        }
    }
    _normalizeEventTimes();

    function _markOverlapLessonTimesAndAbsences() {
        with (d.result.displaySchedule) {
            if (typeof lessonTimes === "object") {
                // marks lessons overlapping absences
                for (var i = 0; i < lessonTimes.length; i++) {
                    if (
                        lessonTimes[i].dates !== undefined &&
                        lessonTimes[i].dates.length > 0
                    ) {
                        for (var k = 0; k < d.result.classAbsences.length; k++) {
                            var ac = intersectArrays(lessonTimes[i]._classCodesIndex, d.result.classAbsences[k]._classCodesIndex);
                            if (ac.length > 0) {
                                // some of lesson's classes are absent
                                for (var j = 0; j < lessonTimes[i].dates.length; j++) {
                                    if (
                                        (lessonTimes[i].dates[j] + lessonTimes[i].startTime) <= (d.result.classAbsences[k].endDate + d.result.classAbsences[k].endTime) &&
                                        (lessonTimes[i].dates[j] + lessonTimes[i].endTime) >= (d.result.classAbsences[k].startDate + d.result.classAbsences[k].startTime)
                                    ) {
                                        // lesson and absence overlap detected

                                        // make lesson with serial date as a separate copy
                                        // change current lesson to single date 
                                        if (lessonTimes[i].dates.length > 1) {
                                            var lessonRest = $.extend(true, {}, lessonTimes[i]);
                                            lessonRest.dates.splice(j, 1);
                                            lessonTimes.splice(i + 1, 0, lessonRest);

                                            lessonTimes[i].dates = [lessonTimes[i].dates[j]];
                                        }

                                        $.extend(true, lessonTimes[i], {
                                            "changes": {
                                                "absentClassCodes": ac.map(function (e) {
                                                    return d.result.classes[e].code;
                                                }),
                                                "reasonType": "classAbsence",
                                                "caption": "Klasse fehlt",
                                                "changeType": 8,
                                            }
                                        })
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    //_markOverlapLessonTimesAndAbsences();

    function _normalizeSupervisionTimes() {
        with (d.result.displaySchedule) {
            if (typeof supervisionTimes === "object") {
                for (var i = 0; i < supervisionTimes.length; i++) {
                    // key
                    supervisionTimes[i]._i = i;

                    // build teamRefs
                    supervisionTimes[i]._teamRefs = [];

                    // optimize teacher lookup
                    if (typeof supervisionTimes[i]._teacherCodesIndex !== "object" && typeof supervisionTimes[i].teacherCodes === "object") {
                        supervisionTimes[i]._teacherCodesIndex = [];
                        for (var j = 0; j < supervisionTimes[i].teacherCodes.length; j++) {
                            var k = arrayLookup(d.result.teachers, supervisionTimes[i].teacherCodes[j], "code");
                            if (k != -1) {
                                supervisionTimes[i]._teacherCodesIndex[j] = k;

                                if (currentProfile.data.teamRef.indexOf("teachers") >= 0 && typeof d.result.teachers[k].teamRefs === "object")
                                    Array.prototype.push.apply(supervisionTimes[i]._teamRefs, d.result.teachers[k].teamRefs);
                            }
                        }
                    }

                    // optimize team lookup
                    if (supervisionTimes[i]._teamRefs.length > 0) {

                        supervisionTimes[i].teamCodes = [];

                        // make unique
                        if (supervisionTimes[i]._teamRefs.length > 1) {
                            supervisionTimes[i]._teamRefs.sort();
                            for (var j = supervisionTimes[i]._teamRefs.length - 1; j >= 1; j--) {
                                if (supervisionTimes[i]._teamRefs[j] == supervisionTimes[i]._teamRefs[j - 1])
                                    supervisionTimes[i]._teamRefs.splice(j, 1)
                            }
                        }

                        // lookup/resolve
                        for (var j = 0; j < supervisionTimes[i]._teamRefs.length; j++) {
                            var k = arrayLookup(d.result.teams, supervisionTimes[i]._teamRefs[j], "id");
                            if (k != -1)
                                supervisionTimes[i].teamCodes.push(d.result.teams[k].code);
                        }
                    }

                    resolveTimeframeTimeslots(supervisionTimes[i], d);
                }
            }
        }
    }
    _normalizeSupervisionTimes();

    function _buildLessonTimesChanges() {
        d.result.displaySchedule._lessonTimesChanges = [];
        with (d.result.displaySchedule) {
            if (typeof lessonTimes === "object") {
                for (var i = 0; i < lessonTimes.length; i++) {
                    if (
                        typeof lessonTimes[i].changes === "object" &&
                        typeof lessonTimes[i].dates === "object" &&
                        lessonTimes[i].dates.length > 0
                    ) {
                        if (
                            (lessonTimes[i].changes.changeType === 6) ||
                            (lessonTimes[i].changes.changeType === 7)
                        ) {
                            // skip
                        } else {
                            _lessonTimesChanges.push(i);
                        }
                    }
                }
            }
        }
    }
    _buildLessonTimesChanges();

    function _resolveChangeReasonDescription() {
        d.result.displaySchedule._lessonTimesChanges.forEach(function (e) {
            if (d.result.displaySchedule.lessonTimes[e].changes.reasonType === "classAbsence" && d.result.displaySchedule.lessonTimes[e].changes.reasonCode !== undefined) {
                var k = arrayLookup(d.result.classAbsenceReasons, d.result.displaySchedule.lessonTimes[e].changes.reasonCode, "code");
                if (k !== -1) {
                    d.result.displaySchedule.lessonTimes[e].changes.reasonDescription = d.result.classAbsenceReasons[k].description;
                }
            }
        });
    }
    _resolveChangeReasonDescription();

    function _buildSupervisionTimesChanges() {
        d.result.displaySchedule._supervisionTimes = [];
        with (d.result.displaySchedule) {
            if (typeof supervisionTimes === "object") {
                for (var i = 0; i < supervisionTimes.length; i++) {
                    if (
                        typeof supervisionTimes[i].changes === "object" &&
                        typeof supervisionTimes[i].dates === "object" &&
                        supervisionTimes[i].dates.length > 0
                    ) {
                        _supervisionTimes.push(i);
                    }
                }
            }
        }
    }
    _buildSupervisionTimesChanges();
}

function intersectArrays(a1, a2) {
    return (a1||[]).filter(function (e1) {
        return (a2||[]).includes(e1);
    });
}

function resolveTimeframeTimeslots(o, d) {
    // lookup timeframe index
    o._timeframeIndex = lookupTimeframeIndex(o, d);

    // lookup timeslots indexes
    o._timeslots = [];

    var b = 0;
    if (o.startTime !== "0000")
        b = lookupTimeslotIndex(o.startTime, o._timeframeIndex, true, false, d.result.timeframes);

    var e = d.result.timeframes[o._timeframeIndex].timeslots.length ? d.result.timeframes[o._timeframeIndex].timeslots.length - 1 : 0;
    if (o.endTime != "0000")
        e = lookupTimeslotIndex(o.endTime, o._timeframeIndex, false, true, d.result.timeframes);

    if (b <= e) {
        for (var j = b; j <= e; j++) {
            o._timeslots.push(j);
        }
    }
    else
        o._timeslots.push(b||0);
    o._timeslotIndex = o._timeslots[0];

}


function davinciLessonItemsCompare(i1, i2) {
    var r = 0;

    // TODO:
    /*
    1.       Time
    2.       Level
    3.       Class
    4.       Subject
    5.       Teacher
    6.       Room
    7.       periodCode
    */

    // lessons with changes to head
    r = (i1.domElement.classList.contains("has-changes") ? 0 : 1) - (i2.domElement.classList.contains("has-changes") ? 0 : 1)
    if (r != 0)
        return r;

    r = i1.i - i2.i;
    if (r != 0)
        return r;
    
    r = i1.yindex - i2.yindex;
    if (r != 0)
        return r;

    // keep order detemrined
    r = i1.id - i2.id;
    if (r != 0)
        return r;

    return r;
}