﻿var floorPlan;

var floorPlanViews = [];

var davinciFloorplanCallbacks = $.Callbacks("unique memory");

function getFloorplanFolder() {
    if (typeof currentProfile.data.floorplanFolder === "string")
        return currentProfile.data.floorplanFolder;
    else if (typeof currentProfile.data.dataUrlHost === "string") {
        if (currentProfile.data.useSSL === "true" || currentProfile.data.useSSL === true)
            return "https://" + currentProfile.data.dataUrlHost + "/";
        else {
            var protocolCandidate = "http:";
            if (location.protocol === "https:") {
                protocolCandidate = location.protocol;
            }

            return (protocolCandidate + "//") + currentProfile.data.dataUrlHost + "/";
        }
    }
    else if (typeof currentProfile.data.school === "string")
        return (currentProfile.data.school + "/");
    else
        return "/";
}

function parseMetadataCsv(csv) {
    var r = $.csv.toObjects(csv, { separator: ';' });
    return r;
}

function requestDavinciFloorplan(floorplanUrlPrefix, floorplanUrl) {
    var r = $.ajax({
        url: (floorplanUrlPrefix + floorplanUrl),
        dataType: "json",
    });

    r.done(function (response) {
        $.when.apply(this,
            response.
                map(function (e) {
                    var d = $.Deferred();

                    if (e.metadataUrl) {
                        $.ajax({
                            url: (floorplanUrlPrefix + e.metadataUrl),
                        }).then(
                            (function done(dd, ee, responseMetadata) {
                                ee.metadata = parseMetadataCsv(responseMetadata);
                                dd.resolve(ee);
                            }).bind(this, d, e),

                            (function fail(dd, ee ) {
                                dd.resolve(ee);
                            }).bind(this, d, e)
                        )
                    } else {
                        d.resolve(e);
                    }

                    return d.promise();
                })
        ).done(function () {
            floorPlanViews = arguments;
            davinciFloorplanCallbacks.fire({
                urlPrefix: floorplanUrlPrefix,
                response: response
            });
        })

    });

    return r;
}


function translateRoomItem(item, translatedItem) {
    translatedItem.room = item.roomCodes[0];
    translatedItem.flag = 1;
    translatedItem.text = [
		item.courseTitle,
		(item.classCodes || [""])[0],
        (currentProfile.data.floorplan && currentProfile.data.floorplan.show && typeof currentProfile.data.floorplan.show.indexOf === 'function' && currentProfile.data.floorplan.show.indexOf("teacher") >= 0 && item.teacherCodes !== undefined) 
			? item.teacherCodes.join(", ")
			: undefined, 
    ];
    return true;
}



function ungroupRoomItem(itemParams) {
    var r = [itemParams];

    var coll = [
		//"dates",
		"roomCodes",
    ];

    for (var c = 0; c < coll.length; c++) {
        if ((typeof itemParams[coll[c]] === "object") && (itemParams[coll[c]].length > 1)) {
            var r1 = [];
            for (var i = 0; i < r.length; i++) {
                for (var j = 0; j < itemParams[coll[c]].length; j++) {
                    var o = jQuery.extend(true, {}, r[i]);
                    o[coll[c]] = [itemParams[coll[c]][j]];
                    r1.push(o);
                }
            }
            r = r1;
        }
    }

    return r;
}

function filterRoomItems(item, filterParams, stage) {
    if (typeof item.roomCodes !== "object")
        return false;

    if (stage == 1) {
        if (
            ((typeof item.weekday !== "undefined") && item.weekday == filterParams.profile.data.wd) ||
            ((typeof item.dates === "object") && item.dates.indexOf(filterParams.profile.data.d) >= 0)
		)
            return true;
    }

    if (stage == 2)
        return true;

    if (stage == 3)
        return (filterParams.t >= item.startTime && filterParams.t < item.endTime);

    return false;
}




function onTimeframeChanged() {
    $(".roomInfo").css("display", "none");

    if (typeof floorPlan === "object") {
        if (typeof floorPlan.filterParams === "object")
            floorPlan.filterParams.t = data.result.timeframes[0].timeslots[timeframeIndex].startTime;

        floorPlan.clearGraphics();
        floorPlan.drawGraphics();
    }
}


function getRoomMetadata(e, roomCode) {
    var r = "";

    if (roomCode) {
        var floorMetadata = $(e.delegateTarget).data();
        if (floorMetadata) {
            for (var i = 0; ; i++) {
                if (floorMetadata[i] === undefined)
                    break;
                else if (floorMetadata[i].code === roomCode) {
                    r = floorMetadata[i].data;
                    break;
                }
            }
        }
    }

    return r;
}

function onRoomClick(e) {
    var label = e.target.getAttribute("inkscape:label");
    if (label.search("Room:") >= 0) {
        var roomCode = label.replace("Room:", "");

        var roomMetadata = getRoomMetadata(e, roomCode);

        var o = getRoomInfo(roomCode, roomMetadata);
        if (o.length > 0) {
            showRoomPanel.call(this, e.target, o, e);
        } else {
            $(".roomInfo").css("display", "none");
        }
    }
}

function roomMetadataToHtml(roomMetadata) {
    if (roomMetadata) {
        return roomMetadata.replace(/(?:\r\n|\r|\n)/g, "<br>").replace(/ /g, "&nbsp;");
    } else {
        return "";
    }
}

function getRoomInfo(r, roomMetadata) {
    var o = [];

    var lessons = getRoomItems(r);
    if (lessons.length > 0) {
        if (roomMetadata) {
            o.push(`<tr><td colspan="2">${roomMetadataToHtml(roomMetadata)}</td></tr>`);
        }

        for (var i = 0; i < lessons.length; i++) {
            var c = "room-info-has-lessons";

            if (floorPlan.filterParams.t < lessons[i].endTime && floorPlan.filterParams.t >= lessons[i].startTime)
                c = c + " current";

            o.push('<tr class="' + c + '">' +
                '<td>' +
                    lessons[i].startTime.replace(/(\d\d)(\d\d)/, "$1:$2") +
                    '<br />' +
                    lessons[i].endTime.replace(/(\d\d)(\d\d)/, "$1:$2") +
                    ((typeof lessons[i].changes === "undefined") ? "" : ("<br />" + lessons[i].courseTitle)) +
                '</td>' +
                '<td>' +
                    lessons[i].courseTitle + "<br />" +
                    (lessons[i].classCodes || []).join(",") + "<br />" +
                    (getTeacherDisplayNames(lessons[i].teacherCodes || [])).join(",") +
                "</td>" +
                '</tr>'
            );
        }
    } else {
        if (roomMetadata) {
            o.push(`<tr><td>${roomMetadataToHtml(roomMetadata)}</td></tr>`);
        }

        o.push(
            '<tr class="room-info-no-lessons">' +
            '<td>' +
            '</td>' +
            '</tr>' 
        );
    }
    return o;
}

function getRoomItems(r) {
    var o = [];

    var lessons = floorPlan.items;
    for (var i = 0; i < lessons.length; i++) {
        if (lessons[i].roomCodes.indexOf(r) >= 0) {
            o.push(lessons[i]);
        }
    }

    o.sort(function (a, b) { return a.startTime - b.startTime });

    return o;
}

