﻿var calMonthScale = 2.25;


function createCalendarYear(p, d1, d2, params) {
//    d2 = "20161201";
    if (d1 === "" && d2 === "")
        return; // nothing to do

    var dc1 = (new ONTIME.Date()).getBeginOf("D");
    if (dc1.format() < d1 || currentProfile.data.scopeShowPast == "true")
        dc1 = ONTIME.Date.parse(d1);

    var dc2 = ONTIME.Date.parse(d2);

    var dt = dc1.getBeginOf(currentProfile.data.scopeSnap);
    var de = dc2.getBeginOf(currentProfile.data.scopeSnap).offset(1, currentProfile.data.scopeSnap);

    var currentYear = "";

    p.empty();


    var pager;

    for (var i = 0; dt.format() < de.format(); i++) {
        var o = {
            attr: {
                "id": "c" + dt.format("YYYYMM"),
                "data-m": dt.getMonth(),
                "data-y": dt.getFullYear(),
                "data-c": i+1,
            },

            rangeBegin: dt.getBeginOf("M"),
            rangeEnd: dt.getBeginOf("M").offset(1, "M").offset(-1, "D"),

            setItemContent: function (domItem, item, inRange, today) {
                ONTIME.CalendarMonth.prototype.setItemContent.apply(this, arguments);
                var dtf = item.format();
                if (dtf < data.result.displaySchedule.effectivity.startDate || dtf > data.result.displaySchedule.effectivity.endDate)
                    domItem.attr("data-out-of-scope", "");
            },
        };

        if (currentYear != dt.getFullYear()) 
            o.attr["data-yearchange"] = "";
        

        $.extend(true, o, params);
        var c = ONTIME.CalendarMonth.createRuntime(o);

        if (typeof pager === "undefined" || pager.children().length >= 12 || (currentProfile.data.scopeSnap.toUpperCase() == "Y" && pager.attr("data-y") != dt.getFullYear())) {
            pager = $('<div class="davinci-year-page" data-y="' + dt.getFullYear() + '"></div>');
            pager.appendTo(p);
        }

        $('<div class="davinci-month-page" data-y="' + dt.getFullYear() + '" data-m="' + dt.getMonth() + '" ></div>')
            .append(c.$el)
            .appendTo(pager);

        currentYear = dt.getFullYear();
        dt.offset(1, "M");
    }
    ONTIME.CalendarMonth.markDayAsPastTodayFuture();
}

function updateCalendar() {
    var calendarLessonTimes = {};
    var calendarEventTimes = {};

    ONTIME.CalendarMonth.markDayAsPastTodayFuture();

    if (typeof data.result === "object" && typeof data.result.displaySchedule === "object") {
        with (data.result.displaySchedule) {
            for (var i = 0; i < lessonTimes.length; i++) {
                for (var j = 0; j < lessonTimes[i].dates.length; j++) {
                    if (
                        checkDataItemProperty(lessonTimes[i].classCodes, currentProfile.data.filter.cl, 0) &&
                        checkDataItemProperty(lessonTimes[i].teacherCodes, currentProfile.data.filter.te, 0) &&
                        checkDataItemProperty(lessonTimes[i].roomCodes, currentProfile.data.filter.ro, 0)
                    ) {
                        calendarLessonTimes[lessonTimes[i].dates[j]] = true;
                    }
                }
            }
            for (var i = 0; i < eventTimes.length; i++) {
                var df = eventTimes[i].startDate;
                if (eventTimes.participants === undefined && df != eventTimes[i].endDate) {
                    //var de = ONTIME.Date.parse(eventTimes[i].endDate);
                    var d = ONTIME.Date.parse(eventTimes[i].startDate);

                    do {
                        if (typeof calendarEventTimes[df] !== "object")
                            calendarEventTimes[df] = {
                                "national": false,
                                "local": false,
                                "foreign": false,
                            };
                        calendarEventTimes[df][eventTimes[i].eventType || "local"] = true;

                        d.offset(1, "D");
                        df = d.format();
                    } while (df < eventTimes[i].endDate);
                }
            }
        }

        $('.cal-body .cal-day[data-range="in"][data-date]').each(function () {
            var d = this.getAttribute("data-date");
            if (calendarLessonTimes[d])
                this.classList.add("has-lessons");
            else
                this.classList.remove("has-lessons");

            if (typeof calendarEventTimes[d] === "object") {
                this.classList.add("has-events");

                if (calendarEventTimes[d].national) {
                    this.classList.add("has-events-global");
                } else {
                    this.classList.remove("has-events-global");

                    if (calendarEventTimes[d].local && calendarEventTimes[d].foreign)
                        this.classList.add("has-events-mix");
                    else {
                        this.classList.remove("has-events-mix");

                        if (calendarEventTimes[d].local)
                            this.classList.add("has-events-local");
                        else
                            this.classList.remove("has-events-local");

                        if (calendarEventTimes[d].foreign)
                            this.classList.add("has-events-foreign");
                        else
                            this.classList.remove("has-events-foreign");
                    }
                }
            } else {
                this.classList.remove("has-events-global");
                this.classList.remove("has-events-mix");
                this.classList.remove("has-events-local");
                this.classList.remove("has-events-foreign");
            }
        });
    }
}

function fixCalendarSize($c) {
    var $m = $c.find(".davinci-month-page");
    if ($m.length > 0) {
        var w;
        var h;

        var monthView = $c.parents(".cal-view")[0].hasAttribute("data-mw");
        if (monthView) {
            var p = $c.parents(".calendar-content");
            
            w = $m.width()  * calMonthScale * ($c.hasClass("o-landscape") ? 12 : 1) + (p.width()  - calMonthScale * $m.width() );
            h = $m.height() * calMonthScale * ($c.hasClass("o-portrait")  ? 12 : 1) + (p.height() - calMonthScale * $m.height());
        } else {
            w = $m.width()  * ($c.hasClass("o-landscape") ? 6 : 3);
            h = $m.height() * ($c.hasClass("o-portrait")  ? 4 : 2);
        }

        $c.width(w);
        $c.height(h);

        var ypage = $c.find(".davinci-year-page");
        var yw = ypage.innerWidth();
        var yh = ypage.innerHeight();
        ypage.css("padding", ((yh - h) / 2) + "px " + ((yw - w) / 2) + "px");


    }
}

function onMonthClick_v1(e) {
    var $m = $(e.delegateTarget).parents(".davinci-month-page");
    var $y = $m.parents(".davinci-year-page");
    var $c = $y.parent();
    if (
        $c.parents(".cal-view").attr("data-mw") == ($m.index() + 1) &&
        $c.parents(".cal-view").attr("data-yw") == ($y.index() + 1)
    ) {
        $c.parents(".cal-view")
            .removeAttr("data-mw")
            .removeAttr("data-yw");
    } else {
        $c.parents(".cal-view").attr({
            "data-mw": $m.index() + 1,
            "data-yw": $y.index() + 1
        });
    }
}


function onMonthClick_v2(e) {
    var $m = $(e.delegateTarget).parents(".davinci-month-page");
    var $y = $m.parents(".davinci-year-page");
    var $c = $y.parents(".davinci-calendar-scrollable-content");

    $c
        .animate({
            opacity: 0,
        }, {
            duration: 250,
            easing: "linear",
        })
        .queue(function () {
            if (
                $c.parents(".cal-view").attr("data-mw") == ($m.index() + 1) &&
                $c.parents(".cal-view").attr("data-yw") == ($y.index() + 1)
            ) {
                $c.parents(".cal-view")
                    .removeAttr("data-mw")
                    .removeAttr("data-yw");

                setCalendarViewMode($c);
                fixCalendarSize($c);
                setScrollableOffset($c, $y.index(), $m.index());
            } else {
                $c.parents(".cal-view").attr({
                    "data-mw": $m.index() + 1,
                    "data-yw": $y.index() + 1
                });

                setCalendarViewMode($c);
                fixCalendarSize($c);
                setScrollableOffset($c, $y.index(), $m.index());
            }
            $(this).dequeue();
        })
        .animate({
            opacity: 1,
        }, {
            duration: 250,
            easing: "linear",
        })
    ;

}

function handleCalendarResize($c) {
    if (window.innerWidth > window.innerHeight) {
        $c
            .addClass("o-landscape")
            .removeClass("o-portrait");
        $c.parent() // TODO: optimize
            .addClass("o-landscape")
            .removeClass("o-portrait");
    } else {
        $c
            .addClass("o-portrait")
            .removeClass("o-landscape");
        $c.parent()
            .addClass("o-portrait")
            .removeClass("o-landscape");
    }
    setCalendarViewMode($c);
    fixCalendarSize($c);
    setScrollableOffset($c, 0, 0);
}

function setScrollableOffset(content, y, m) {
    var monthView = content.parents(".cal-view")[0].hasAttribute("data-mw");

    var $m = content.find(".davinci-month-page").first();

    var k = 1;
    var i = y * 12;

    var p = content.parents(".calendar-content");
    var scrollable = p.dxScrollable("instance");
    scrollable.update();

    if (monthView) {
        k = calMonthScale;
        i += m;
    }

    if (content.hasClass("o-portrait")) {
        var pos = getCalendarMonthPosition(monthView, i, 3, 4, content);
        scrollable.scrollTo({ top: (pos.y * k * $m.height()) });

    } else {
        var pos = getCalendarMonthPosition(monthView, i, 6, 2, content);
        scrollable.scrollTo({ left: (pos.x * k * $m.width()) });
    }
}

function setCalendarViewMode(content) {

    var monthView = content.parents(".cal-view")[0].hasAttribute("data-mw");

    var monthWidgets = content.find(".cal-month");
    for (var i = 0; i < monthWidgets.length; i++) {
        monthWidgets.eq(i).css({
            "transform": (monthView ? "scale(" + calMonthScale + ", " + calMonthScale + ")" : "scale(1, 1)"),
            "-webkit-transform": (monthView ? "scale(" + calMonthScale + ", " + calMonthScale + ")" : "scale(1, 1)"),
        });

        var tr = getCalendarMonthTransform(monthView, i, content);
        monthWidgets.eq(i).parent().css({
            "transform": tr,
            "-webkit-transform": tr,
        });

    }
}

function getCalendarMonthTransform(monthView, i, content) {
    var base = 100;

    var pos;
    if (content.hasClass("o-portrait"))
        pos = getCalendarMonthPosition(monthView, i, 3, 4, content);
    else
        pos = getCalendarMonthPosition(monthView, i, 6, 2, content);
    
    if (monthView) {
        var m = content.find(".davinci-month-page").first();
        var p = content.parents(".calendar-content");

        base *= calMonthScale;

        pos.y += ((p.height() - calMonthScale * m.height()) / (calMonthScale * m.height() * 2));
        pos.x += ((p.width()  - calMonthScale * m.width())  / (calMonthScale * m.width()  * 2));
        
    } else {
    }

    var tr = "translate3d(" + ((pos.x) * base) + "%, " + (pos.y * base) + "%, 0)";

    return tr;
}

function getCalendarMonthPosition(monthView, i, cpp, rpp, content) {
    var pageNo = 0
    var rowInPage = 0
    var colInPage = 0;

    if (content.hasClass("o-portrait"))
        rowInPage = i;
    else
        colInPage = i;


    if (!monthView) {
        pageNo = Math.floor(i / (cpp * rpp));

        rowInPage = Math.floor((i % (cpp * rpp)) / cpp);
        colInPage = i % cpp;
    }

    var o = {
        x: colInPage,
        y: rowInPage
    };

    if(content.hasClass("o-portrait"))
        o.y += (pageNo * rpp);
    else
        o.x += (pageNo * cpp);

    return o;
}
