﻿
// ---------------------------------


var davinciDefaultProfileObject = {

    // general params

    // view: initial view (see before): "timetable" | "substitutions" | "floorplan" | "calendar"
    // default: undefined
    view: "timetable",

    // views: array of navigable views: ["timetable", "substitutions", "floorplan", "calendar"] 
    // default: undefined, means array containing value of view
    views: ["timetable", "calendar", "substitutions"],


    // timetable params

    // timetableFormat: render columns as "date" | "teacher" | "class" | "room"
    // default: undefined, means "date"
    timetableFormat: "date",

    // timetableDateFormat: "week", "day" - for date format show week columns or day single column
    // default: "week"
    timetableDateFormat: "week",

    // timetableLock: boolean ()
    // default: undefined, means no lock applied
    timetableLock: "false",

    //maxParallelItems: number, defines max number of items allowed to show in parallel
    // default: 10
    // IMPORTANT: there is implementation limitation to 10 parallel items
    maxParallelItems: 4,


    // substitutions table params

    // substitutionShowExtra: "all" | "page" | "none" | <number>
    // default: undefined, means [implementation dependent] 
    substitutionShowExtra: "all",

    
    // substitutionShowSupervision: "true" | "false" | ""
    // default - not defined
    // defined that supervision entries are shown in substitutions list in time mode
    substitutionShowSupervision: "",


    // floorplan params

    // floor: index in floorplan (floors) collection
    // default: 0
    floor: 0,

    // floorplan scale applied as transform scale(floorplanScale, floorplanScale) style 
    //floorplanScale: 1,

    // showFloorSelector: show bottom panel to select floorplan level
    //showFloorSelector: "false"

    // date / time
    // date reference YYYYMMDD
    // default: undefined (means today)
    //date: "20151231",

    // dateOffset: relative reference date (days)
    // default: 0
    dateOffset: 0,

    weekdayStart: 1,
    weekdayEnd: 7,

    eventTimes: [],

    // time reference HHMM
    // default: undefined (means now)
    //time: "2359",

    // timeOffset: relative reference time (mi)
    // default: 0
    timeOffset: 0,


    // filter - defines filter criteria by key-value(s) pair (s)
    // default: {}, means show everything
    filter: {
        te: null,
        cl: null,
        ro: null,
    },

    profileFilter: {
        te: null,
        cl: null,
        ro: null,
    },

    interactive: "label",

    // handle account for json authorisation
    // account type: "public" | "private" | "auto". if "public", connection made without username/password
    account: "auto",
    username: "",
    password: "",

    //dataUrlHost: "",
    useSSL: "false",
    //school: "",
    //dataUrl: "",
    //floorplanFolder: "",


    // color scheme
    // schemeClass: "scheme-light" | "scheme-dark" | ...

    // language
    // lang: "en" | "de" | ...
    lang: "de",

    // calendar scope
    // scopeShowPast - controls visibility of past scope
    scopeShowPast: "false",

    // scopeSnap - "W"eek, "Q"uartal, "M"onth, "Y"ear
    scopeSnap: "m",

    nowView: "classes",
	nowScope: "actual",

    /*

    teacherDisplayName: [
        "firstName",
        "middleName",
        "lastName",
        "namePrefix",
        "nameSuffix",
        "nickName",
        "maidenName"
    ],

    */

    refreshInterval: 5*60*1000,
    flipInterval: 5000,

    userCss: "",

    substCols: [],
    //substCols: ["date", "weekDay", "pos", "time", "teacher", "subject", "room", "class", "steacher", "caption", "info", "message"],

    substHeader: [],
    //substHeader: ["teacher", "class"],

	teamRef: ["classes", "teachers", "rooms"],
	
	requestMethod: "GET",

	floorplanRoomColor: 0,

    // floorplanTextScale: 1,
};

var dataProcessingLayerObject = {
    getOffsetDate: function (_date, _offset, _weekdayStart, _weekdayEnd, _eventTimes) {
        var specifiedDate = new ONTIME.Date();
        specifiedDate.setTime(_date.getTime());
        
        var step = 0;
        var offset = parseInt(_offset);
        if (offset < 0) {
            step = -1;
        } else if (offset > 0) {
            step = 1;
        }

        for (var i = 0; i != offset; i += step) {
            // do step
            specifiedDate.setDate(specifiedDate.getDate() + step);

            // skip weekend day
            while (true) {
                var wd = specifiedDate.getDay();
                if (wd == 0) wd = 7;

                if (wd >= _weekdayStart && wd <= _weekdayEnd && !_eventTimes.some(function (e) {
                        var f = specifiedDate.format();
                        return e.startDate <= f && f < e.endDate;
                    })
                )
                    break;

                specifiedDate.setDate(specifiedDate.getDate() + step);
            }
        }

        return specifiedDate;
    },

    refDate: function () {
        var specifiedDate;

        if(typeof this.date === "string")
            specifiedDate = ONTIME.Date.parse(this.date);
        else
            specifiedDate = new ONTIME.Date();
        
        // find next closest working day after specified one
        while (this.weekdayStart != this.weekdayEnd) {
            var wd = specifiedDate.getDay();
            if (wd == 0) wd = 7;

            if (wd >= this.weekdayStart && wd <= this.weekdayEnd && !this.eventTimes.some(function (e) {
                    var f = specifiedDate.format();
                    return e.startDate <= f && f < e.endDate;
                })
            )
                break;

            specifiedDate.setDate(specifiedDate.getDate() + 1);
        }

        return this.getOffsetDate(specifiedDate, this.dateOffset || 0, this.weekdayStart, this.weekdayEnd, this.eventTimes);
    },

    refTime: function () {
        return (((typeof this.time === "string")
            ? ONTIME.Date.parse(this.time, "HHmm")
            : new ONTIME.Date()).offset(parseInt(this.timeOffset), "MI"));
    },
};


var dateSpanFilterObject = {
    dd: null,
    offsetStep: 1,

    offsetDate: function (steps) {
        // +/- 1/7 days
        this.dd.offset(this.offsetStep * steps);

        this._p._build();
    },

    _build: function () {
        var rd = this._p.data.refDate();

        if (rd.format() != this.rd) {
            this.dd = null;
            this.rd = rd.format();
        }

        if (this.dd === null)
            this.dd = rd;

        var dd1 = this.dd.getBeginOf("w").offset(this._p.data.weekdayStart - 1);
        var dd2 = this.dd.getBeginOf("w").offset(this._p.data.weekdayEnd - 1);

        return {
            dd: this.dd,

            rd: this.rd,

            d: this.dd.format(),
            wd: this.dd.getDay(),

            d1: dd1.format(),
            wd1: dd1.getDay(),

            d2: dd2.format(),
            wd2: dd2.getDay(),
        };
    }
};

var currentProfile = new ONTIME.Profile();
currentProfile.setOrder([
    "default", "functions", "appSettings", "localStorage", "sessionStorage", "urlParams",
    "runtimeOptions", "objectFilter", "dateFilter", "floorFilter"]);

currentProfile.set("default", davinciDefaultProfileObject);
currentProfile.set("functions", dataProcessingLayerObject);
currentProfile.set("dateFilter", dateSpanFilterObject);






