﻿// TODO: drag-n-drop operation is Scheduler wide, but applied to (lessons) layer. 
// ontime drag-n-drop processing must be layer independent, layer should be defined by application

function initPlanner() {
    k = new ONTIME.SchedulerInteractive({
        el: $(".ontime-scheduler")[0],
        cellBuilderCallback: resolveCell,
        layoutType: currentProfile.data.timetableFormat,
        filterParams: {
            profile: currentProfile,
        },
        dayView: false,
        getDaysCount: function () {
            return (
                (data.result.displaySchedule.weekspan.weekdayEnd || 7) -
                data.result.displaySchedule.weekspan.weekdayStart
                + 1
            );
        },
        onItemMove: handleItemMove,
        onItemAdd: handleItemAdd,
        builtDragGhostItem: builtDragGhostItemSubjectBased,
    });

    k.layers.push(new ONTIME.SchedulerLayer({
        scheduler: k,
        el: k.$el.find('.ontime-scheduler-items-lessons'),
        getItems: function () {
            return data.result.displaySchedule.lessonTimes;
        },
        filterItem: filterDataItems,
        ungroupItem: ungroupDataItem,
        maxParallelItems: parseInt(currentProfile.data.maxParallelItems)
    }));

    defineLayout();
    k.refresh();
}


function initResources() {
    var container = $(".davinci-subject-list");

    container
        .on("touchstart", ".davinci-subject", handleSubjectTouchStart)
        .on("touchmove", ".davinci-subject", handleSubjectTouchMove)
        .on("touchend", ".davinci-subject", handleSubjectTouchEnd)
    ;

    container
        .on("mousedown", ".davinci-subject", handleSubjectTouchStart)
        .on("mousemove", ".davinci-subject", handleSubjectTouchMove)
        .on("mouseup", ".davinci-subject", handleSubjectTouchEnd)
    ;

    container.empty();

    for (var i = 0; i < data.result.subjects.length; i++) {
        var node = $('<div draggable_="true" class="davinci-subject" data-index=' + i + '><span class="subject-code">' + data.result.subjects[i].code + '</span></div>');
        if (data.result.displaySchedule.display.lessonColor == 1) {
            node.css("background-color", data.result.subjects[i].color);

            if (isColorDark(data.result.subjects[i].color))
                node.addClass("item-content-bg-dark");
            if (isColorLight(data.result.subjects[i].color))
                node.addClass("item-content-bg-light");
        }
        container.append(node);
    }
}



function handleSubjectTouchStart(e) {
    e.preventDefault(); 

    var dragStartSubject = $(e.currentTarget);
    dragStartSubject.addClass("dragSubjectItem");
}


function handleSubjectTouchMove(e) {
    k.handleTouchMove(e);
}

function handleSubjectTouchEnd(e) {
    k.handleTouchEnd(e);
}

function handleItemMove(e) {
    var _i = e.item.attr("data-i");
    if (_i >= 0 && _i < data.result.displaySchedule.lessonTimes.length) {
        with (data.result.displaySchedule.lessonTimes[_i]) {
            startTime = this.leftHeader.items[e.y - 1][2].startTime;
            endTime = this.leftHeader.items[e.y - 1][2].endTime;
            dates = [this.topHeader.items[e.x - 1][3]];
        }
        resolveTimeframeTimeslots(data.result.displaySchedule.lessonTimes[_i], data);
    }

    return true;
}

function handleItemAdd(e) {
    var subject = data.result.subjects[e.srcItem.attr("data-index")];

    var o = {
        "_i": data.result.displaySchedule.lessonTimes.length,
        "courseTitle": subject.code,
        "subjectCode": subject.code,

        "startTime": this.leftHeader.items[e.y - 1][2].startTime,
        "endTime": this.leftHeader.items[e.y - 1][2].endTime,
        "dates": [
            this.topHeader.items[e.x - 1][3]
        ],

    };

    if (typeof currentProfile.data.filter.cl !== "undefined")
        o.classCodes = [currentProfile.data.filter.cl]; 

    resolveTimeframeTimeslots(o, data);
    data.result.displaySchedule.lessonTimes.push(o);

    return true;
}

function builtDragGhostItemSubjectBased(itemNode) {
    var dragStartSubject = $(".dragSubjectItem");

    if (dragStartSubject.length > 0) {
        var sIndex = dragStartSubject.attr("data-index");
        var subject = data.result.subjects[sIndex];

        var o = {
            "subjectCode": subject.code,
            "courseTitle": subject.code,
        };

        if (typeof currentProfile.data.filter.cl !== "undefined")
            o.classCodes = [currentProfile.data.filter.cl];

        this.layers[0].buildItem(o, itemNode);

        return true;
    }

    return false;
}