var data = {};

getInitialDavinciData = function () {
    return {
        about: {
            serverTimeStamp: "",
            server: "",
            serverVersion: "",
            eTag: "0",
        },
        result: {
            subjects: [],

            classes: [],
            teachers: [],
            rooms: [],

            classAbsences: [],
            teacherAbsences: [],
            roomAbsences: [],

            displaySchedule: {
                display: {},
                lessonTimes: [],
                eventTimes: [],
                weekspan: {
                    weekdayStart: 1,
                    weekdayEnd: 5,
                },
                effectivity: {
                    startDate: "",
                    endDate: "",
                },
            },

            timeframes: [{
                timeslots: [{
                    startTime: "",
                    endTime: "",
                }],
            }],
        },
        user: {},
        users: [{}]
    };
}

// TBD: using of raw objects/names vs specially designed notifier
var davinciDataRequestCallbacks = $.Callbacks("unique memory");
var davinciDataCallbacks = $.Callbacks("unique memory");

function requestDavinciData(dataUrl, dataFilter, method) {
    
    var requestObj = {
        dataType: "json",
        cache: false,
    };

    if (method === "POST") {
        var dataRequestParts = dataUrl.split("?");
        jQuery.extend(requestObj, {
            url: dataRequestParts[0],

            method: "POST",
            contentType: 'text/plain; charset=UTF-8',
            data: dataRequestParts[1],
        });
        
    } else {
        jQuery.extend(requestObj, {
            url: dataUrl,
        });
    }

    var r = $.ajax(requestObj);

	var dfd = new jQuery.Deferred();

    r.done(function (response, textStatus, jqXHR) {
            if (jqXHR.status == 200) {
                if (typeof response === "object" && typeof response.about === "object") {
                    var validAndActual = false;

                    //validAndActual = (typeof data === "object" && typeof data.about === "object");
                    //if (validAndActual)
                    //    validAndActual = (data.about.eTag == response.about.eTag)

                    if (!validAndActual) {
                        if (typeof dataFilter === "function") 
                            data = dataFilter(response);
                        else
                            data = response;

                        davinciDataCallbacks.fire();
                    }
                }
            }
            dfd.resolve(response, textStatus, jqXHR);
            davinciDataRequestCallbacks.fire(jqXHR);
        })
        .fail(function (jqXHR, textStatus, errorThrown) {
            dfd.reject(jqXHR, textStatus, errorThrown);
            davinciDataRequestCallbacks.fire(jqXHR);
            //console.log(textStatus);
	    });

    return dfd.promise();
}

function resetDavinciData() {
    pushDavinciData(getInitialDavinciData());
}

function pushDavinciData(o) {
    if (typeof o === "object") {
        data = o;
        davinciDataCallbacks.fire();
	}
}


function buildConnectionUrls(s) {
    /*
        demo-davinci.stueber.de
        demo-davinci.stueber.de:80
        demo-davinci.stueber.de/
        demo-davinci.stueber.de:80/
        ==>
        http://demo-davinci.stueber.de/davinciIS.dll?param=value
        http://demo-davinci.stueber.de/floorplan.json
        http://demo-davinci.stueber.de/demo-floorplan.svg
    
        demo-davinci.stueber.de/berlin/
        ==>
        http://demo-davinci.stueber.de/berlin/davinciIS.dll?param=value
        http://demo-davinci.stueber.de/berlin/floorplan.json
        http://demo-davinci.stueber.de/berlin/demo-floorplan.svg
    
        demo-davinci.stueber.de/berlin/davinciIS.dll
        ==>
        http://demo-davinci.stueber.de/berlin/davinciIS.dll?param=value
        http://demo-davinci.stueber.de/berlin/floorplan.json
        http://demo-davinci.stueber.de/berlin/demo-floorplan.svg
    */

    var protocolCandidate = "http:";
    if (location.protocol === "https:") {
        protocolCandidate = location.protocol;
    }
        

    if (typeof s === "string" && s != "") {
        var protocolPosition = s.indexOf("://");
        var prependProtocol = ((protocolPosition === -1) ? (protocolCandidate + "//") : "");
        var lastSlashPosition = s.lastIndexOf("/");
        if (protocolPosition > 0 && lastSlashPosition < (protocolPosition + 3))
            lastSlashPosition = -1; // do not count slash in protocol notation


        if (lastSlashPosition === -1) {
            // no slash found
            // => use as folder, put missing slash at the end
            return {
                dataUrl: prependProtocol + s + "/daVinciIS.dll",
                floorplanFolder: prependProtocol + s + "/",
            };

        } else if (lastSlashPosition === (s.length - 1)) {
            // slash at the end 
            // => use as folder
            return {
                dataUrl: prependProtocol + s + "daVinciIS.dll",
                floorplanFolder: prependProtocol + s,
            };

        } else {
            // 1+ slashes found, but not at the end
            // => use given as davinci data url, calculate floorplan by replacing last element with flooplan.json
            return {
                dataUrl: prependProtocol + s,
                floorplanFolder: prependProtocol + s.substring(0, lastSlashPosition + 1),
            };
        }
    } else {
        return {
            dataUrl: "daVinciIS.dll",
            floorplanFolder: "/",
        };
    }
}

function getDataUrl(currentProfileData, currentData) {
    if (currentProfileData === undefined) {
        currentProfileData = currentProfile.data;
    }

    if (currentData === undefined) {
        currentData = data;
    }

    var r = "";

    // base url
    if (typeof currentProfileData.dataUrl === "string") {
        r = currentProfileData.dataUrl;

        if (r.indexOf("content=json") === -1) {
            r = r + ((r.indexOf("?") >= 0) ? "&" : "?") + "content=json";
        }

    } else if (typeof currentProfileData.dataUrlHost === "string") {
        if (currentProfileData.useSSL === "true" || currentProfileData.useSSL === true)
            r = "https://" + currentProfileData.dataUrlHost + "/" + "daVinciIS.dll?content=json";
        else {
            var protocolCandidate = "http:";
            if (location.protocol === "https:") {
                protocolCandidate = location.protocol;
            }

            r = (protocolCandidate + "//") + currentProfileData.dataUrlHost + "/" + "daVinciIS.dll?content=json";
        }
    }
    else if (typeof currentProfileData.school === "string")
        r = (currentProfileData.school + "/" + "daVinciIS.dll?content=json");
    else
        r = "daVinciIS.dll?content=json";

    // extend url - account
    if (true || currentProfileData.account !== "public") {
        if (typeof currentProfileData.username === "string" && currentProfileData.username != "") {
            r = r + ((r.indexOf("?")>=0) ? "&" : "?") + "username=" + encodeURIComponent(currentProfileData.username);

            if (typeof currentProfileData.key === "string" && currentProfileData.key != "") {
                r = r + "&key=" + currentProfileData.key;
            } else if (typeof currentProfileData.password === "string" && currentProfileData.password != "") {
                r = r + "&password=" + currentProfileData.password;
            }
        }
    }

    // clientVersion
    if (typeof currentProfileData.clientBuild === "string" && currentProfileData.clientBuild != "") {
        r = r + ((r.indexOf("?") >= 0) ? "&" : "?") + "clientBuild=" + currentProfileData.clientBuild;
    }

    // extend url - eTag
    if (typeof currentData === "object" && typeof currentData.about === "object" && typeof currentData.about.eTag === "string" && currentData.about.eTag.length > 0) {
        r = r + ((r.indexOf("?") >= 0) ? "&" : "?") + "etag=" + currentData.about.eTag;
    }

    return r;
}




