/*!
 	DAVINCI APP v1.0.0 
 	Copyright (c) 2014 STÜBER SYSTEMS GmbH, http://www.stueber.de
	
	Filter and handler
*/



$(document).on("scripts_ready", function () {
    $("#versionNr").text(WebBox.build);

    initDavinciAppComponents();


    initScheduler();
    davinciDataCallbacks.add(function(){
        var tbody = $("#table-subst").find("tbody")[0];
        tbody.previousElementSibling.innerHTML =
            "<tr>" +
            fnGetSubstitutionsColumns.get(currentProfile.data.substKey)().map(function (e) {
                if ((e == "message") && (data.result.displaySchedule.display.publishSubstMessage !== true))
                    return '';
                else
                    return '<th data-c="' + e + '"></th>';
            }).join("") +
            "</tr>";

        initScrollableTable();

        initAppInfo();

        showSidebar(false);
        $(".onside-menu-slider").attr("data-level", 0);
        $(".onside-menu-slider").children(".onside-menu-page:not(:first-child)").remove();
        fixSidebarHeight($(".onside-menu-slider"));

        currentProfile.clear("localStorage");
        currentProfile.set("localStorage", {
            filter: getProfileFilter(),
            profileFilter: getProfileFilter(),
        });

        currentProfile.set("functions", {
            weekdayStart: data.result.displaySchedule.weekspan.weekdayStart,
            weekdayEnd: (data.result.displaySchedule.weekspan.weekdayEnd || 7),
            eventTimes: (data.result.displaySchedule.eventTimes || []).filter(function (e) { return (e.noLessons && e.wholeDay && e.participants === undefined); })
        });

        currentProfile.clear("objectFilter"); // myplan
        currentProfile.set("dateFilter", {
            dd: null,
        });


        fillDavinciSidebar();

        //useColorsFromServer();

        // force initial "all classes" view for certain profiles and when homeType/homeId is missing
        if (typeof k === "object" && k !== null && typeof data.result === "object") {

            if (typeof data.user === "object" && (
                data.user.profile == "guest" ||
                (data.user.profile == "master" || data.user.profile == "default") && (typeof data.user.homeType !== "string" || typeof data.user.homeId !== "string")
            )) {
                currentProfile.set("dateFilter", {
                    offsetStep: 1,
                });
                if (data.user.profile == "master") {
                    if (currentProfile.data.timetableFormat == "teacher") {
                        k.layoutType = currentProfile.data.timetableFormat;
                        $("#appTitle").attr("data-title", "allteachers").text("");
                    }
                    else if (currentProfile.data.timetableFormat == "room") {
                        k.layoutType = currentProfile.data.timetableFormat;
                        $("#appTitle").attr("data-title", "allrooms").text("");
                    }
                    else {
                        k.layoutType = "class";
                        $("#appTitle").attr("data-title", "allclasses").text("");
                    }
                } else if (data.user.profile == "guest") {
                    if ([2, 11].indexOf(data.user.policy) >= 0) {
                        // rooms only
                        k.layoutType = "room";
                        $("#appTitle").attr("data-title", "allrooms").text("");
                    } else if ([12, 13].indexOf(data.user.policy) >= 0 && currentProfile.data.timetableFormat == "room") {
                        k.layoutType = "room";
                        $("#appTitle").attr("data-title", "allrooms").text("");
                    } else if ([12, 13].indexOf(data.user.policy) >= 0 && currentProfile.data.timetableFormat == "class") {
                        k.layoutType = "class";
                        $("#appTitle").attr("data-title", "allclasses").text("");
                    } else if ([13].indexOf(data.user.policy) >= 0 && currentProfile.data.timetableFormat == "teacher") {
                        k.layoutType = "teacher";
                        $("#appTitle").attr("data-title", "allteachers").text("");
                    } else {
                        // fallback
                        k.layoutType = "class";
                        $("#appTitle").attr("data-title", "allclasses").text("");
                    }
                } else {
                    k.layoutType = "class";
                    $("#appTitle").attr("data-title", "allclasses").text("");
                }
            } else {
                //currentProfile.clear("objectFilter"); // myplan
                k.layoutType = currentProfile.data.timetableFormat;
                
                if (typeof currentProfile.data.home === "string" && currentProfile.data.home != "")
                    $("#appTitle").attr("data-title", "").text(currentProfile.data.home);
                else
                    $("#appTitle").attr("data-title", "myplan").text("");
            }
        }

        if (!goCurrentTimePeriod()) {
            defineLayout();
            k.refresh();
        }

        k.linkClick = onLinkClick;
        k.linkEnter = onLinkEnter;
        setTimeout(function () {
            k.resizeAction();
        }, 100);



        if ($("#table-subst").parents('[data-view="substitutions"]').length > 0) {
            $("#btn-subst-filter > button").removeClass("subst-all").addClass("subst-my");

            if (
                (data.user.profile == "teammaster") ||
                (data.user.profile == "teacher" && data.user.policy == 14) ||
                (data.user.profile == "master" && typeof data.user.homeType === "string" && typeof data.user.homeId === "string")
            ) {
                $("#btn-subst-filter").css("display", "block");
            } else {
                $("#btn-subst-filter").css("display", "none");
            }

            currentProfile.set("objectFilter", {
                filterSubst: "my",
            });
            // triggers fillSubstitutionsTable

//            fillSubstitutionsTable($("#table-subst").find("tbody")[0], 0);
//		    setTimeout(syncHeaders, 100);
		}
    });

	currentProfile.callbacks.add(
		function () {
		    if ($("#table-subst").parents('[data-view="substitutions"]').length > 0 && currentProfile.data.view == "substitutions") {
		        fillSubstitutionsTable($("#table-subst").find("tbody")[0], 0);
		        setTimeout(syncHeaders, 100);
		    }
		}
    );

});

function initDavinciAppComponents() {
    initSidebar();
    $(".sidebar-toggle").on("click", showSidebar);

	$(".btn-davinci-view button").click(onDavinciViewButtonClick);


	/* info/stats panel */
	$(".info-icon").click(showInfoPanel);
	$(".refresh-icon").click(reloadData);

	$(".davinci-logout").click(davinciResetAccount);

	$(".blackout").click(hideInfoPanel); 
	$(".msgbox").click(hideInfoPanel); 
	$(".popupPanel").click(hideInfoPanel); 

	/* date navigation */  
	$(".go-prev").on("click", goPrevTimePeriod);
	$(".go-next").on("click", goNextTimePeriod);
	$(".go-current").on("click", goCurrentTimePeriod);

	currentProfile.callbacks.add(function () {
	    $("#appDateTitle .DD").text(currentProfile.data.dd.format("DD"));
	    $("#appDateTitle .MM").text(currentProfile.data.dd.format("MM"));
	    $("#appDateTitle .W").text(currentProfile.data.dd.format("W"));
	    $("#appDateTitle .YYYY").text(currentProfile.data.dd.format("YYYY"));
	    $("#appDateTitle .WYYY").text(currentProfile.data.dd.format("WYYY"));

	    if (currentProfile.data.offsetStep == 1) {
	        $("#appDateTitle").addClass("date-day").removeClass("date-week");
        } else {
	        $("#appDateTitle").addClass("date-week").removeClass("date-day");
        }
        
	});

	$(".onside-menu").on("onside-menu", function(e, edata){
		if(edata.eventType == "item") {
		    var p = edata.node.parent();
			
		    $("#davinci-container").attr("data-view", "timetable");
		    // TODO: control availability with css
		    $("#btn-timeframe").css("display", "none");
		    $("#btn-floor").css("display", "none");
		    $("#btn-subst-filter").css("display", "none");
		    $("#appTitle").show();

			if(p[0].id == "dv-myplan") {
				// myplan
				currentProfile.clear("objectFilter");
				k.layoutType = currentProfile.data.timetableFormat;
				currentProfile.set("dateFilter", {
				    offsetStep: (k.dayView ? 1 : 7),
				});
				defineLayout();

				if (typeof currentProfile.data.home === "string" && currentProfile.data.home != "")
				    
				    $("#appTitle").attr("data-title", "").text(currentProfile.data.home);
				else
				    $("#appTitle").attr("data-title", "myplan").text("");
			} else if (p.hasClass("profile-extraplan")) {
			    var i = parseInt(p.attr("data-i"), 10);
			    if (typeof data.users === "object" && data.users.length > 1 &&
                    i > 0 && i < data.users.length
                    ) {
			        currentProfile.clear("objectFilter"); // clear filter

			        currentProfile.set("dateFilter", {
			            offsetStep: (k.dayView ? 1 : 7),
			        });

			        if (
                        typeof data.users[i].code === "string" && data.users[i].code != "" &&
                        typeof data.users[i].filter === "string" && data.users[i].filter != ""
                    ) {
			            applySchedulerFilter(data.users[i].filter, data.users[i].code); // sets object filter
			            currentProfile.set("objectFilter", {
			                filter: {
			                    profileIndex: i,
			                },
			            }); // secondary profile
			        } else {
			            // student profile
			            currentProfile.set("objectFilter", {
			                filter: {
			                    profileIndex: i,
			                    cl: null,
			                    te: null,
			                    ro: null,
			                },
			            }); // secondary profile
			        }

			        if (k.layoutType != "date") {
			            k.layoutType = "date";
			            defineLayout();
			        } else {
			            // header/layout should be invalidated event when layout is not changed - classes can have own timeframe
			            defineLayout();
			        }

			        var title = i;
			        if (typeof data.users[i].code === "string" && data.users[i].code != "")
			            title = data.users[i].code;
			        else if (data.users[i].homeType == "student")
			            title = (data.users[i].name || "");
			        
			        $("#appTitle").attr("data-title", "").text(title);
			    }
			} else {
			    if (edata.node.attr("data-label") == "all") {
				    if (p.parent().attr("data-filter") == "cl") {
				        // -> class
				        k.layoutType = "class";
				        $("#appTitle").attr("data-title", "allclasses").text("");
				    } else if (p.parent().attr("data-filter") == "te") {
				        // -> teacher
				        k.layoutType = "teacher";
				        $("#appTitle").attr("data-title", "allteachers").text("");
				    } else if (p.parent().attr("data-filter") == "ro") {
				        // -> room
				        k.layoutType = "room";
				        $("#appTitle").attr("data-title", "allrooms").text("");
				    }
				    currentProfile.set("dateFilter", {
				        offsetStep: 1,
				    });
				    currentProfile.set("objectFilter", {
				        filter: {
				            te: null,
				            cl: null,
				            ro: null
				        }
				    });
				    defineLayout();
				    //$("#appTitle").text(edata.node.text());
				} else {
				    // -> date, week/day
				    currentProfile.set("dateFilter", {
				        offsetStep: (k.dayView ? 1 : 7),
				    });

				    applySchedulerFilter(p.parent().attr("data-filter"), edata.node.text());

				    if (k.layoutType != "date") {
				        k.layoutType = "date";
				        defineLayout();
				    } else {
                        // header/layout should be invalidated event when layout is not changed - classes can have own timeframe
				        defineLayout();
				    }
				    $("#appTitle").attr("data-title", "").text(edata.node.text());
				}
            }
			k.refresh();
            
			showSidebar(false);
        }
    });		

	
}

function onLinkEnter(e) {
    var t = $(e.currentTarget);
    var a = "";

    if (t.parents(".ontime-scheduler-topheader").length > 0) {
        // top header click
        if (this.layoutType == "date") {
            // granted
            t.addClass("davinci-link");
        } else if (this.layoutType == "class") {
            if (checkProfileRights("cl", t.attr("data-linkparam"))) {
                // granted
                t.addClass("davinci-link");
            }
        } else if (this.layoutType == "teacher") {
            if (checkProfileRights("te", t.attr("data-linkparam"))) {
                // granted
                t.addClass("davinci-link");
            }
        } else if (this.layoutType == "room") {
            if (checkProfileRights("ro", t.attr("data-linkparam"))) {
                // granted
                t.addClass("davinci-link");
            }
        }
    } else {
        if (currentProfile.data.interactive == "url") {
            if (t.hasClass("ontime-scheduler-itemcontentdata")) {
                // granted
                t.addClass("davinci-link");
            }
        } else if (currentProfile.data.interactive == "label") {
            // content click
            if (t.hasClass("aTeacher") || t.parents(".aTeacher").length > 0)
                a = "te";
            else if (t.hasClass("aClass") || t.parents(".aClass").length > 0)
                a = "cl";
            else if (t.hasClass("aRoom") || t.parents(".aRoom").length > 0)
                a = "ro";

            // TODO: execute checkProfileRights() in onEnter mouse event handler. if access granted, add class which makes the node clickable (bound mouse cursor and underline on hover to class, not to data-linkparam) 
            if (a != "") {
                if (checkProfileRights(a, t.attr("data-linkparam"))) {
                    // granted
                    t.addClass("davinci-link");
                }
            }
        }
    }
}

function onLinkClick(e) {
    var t = $(e.currentTarget);
    var a = "";

    if (t.parents(".ontime-scheduler-topheader").length > 0) {
        // top header click
        if (this.layoutType == "date") {
            // day-week mode switch
            set1Day(!this.dayView, ONTIME.Date.parse(t.attr("data-linkparam"), "YYYYMMDD"));

            currentProfile.set("dateFilter", {
                offsetStep: (k.dayView ? 1 : 7),
            });

            currentProfile.set("objectFilter", {
                timetableLock: (this.dayView ? "true" : "false"),
            });

            defineLayout();
            k.refresh();
        } else if (this.layoutType == "class") {
            if (checkProfileRights("cl", t.attr("data-linkparam"))) {
                k.layoutType = "date";
                currentProfile.set("dateFilter", {
                    offsetStep: (k.dayView ? 1 : 7),
                });
                applySchedulerFilter("cl", t.attr("data-linkparam"));

                defineLayout();

                $("#appTitle").attr("data-title", "").text(t.attr("data-linkparam"));
                k.refresh();
            }
        } else if (this.layoutType == "teacher") {
            if (checkProfileRights("te", t.attr("data-linkparam"))) {
                k.layoutType = "date";
                currentProfile.set("dateFilter", {
                    offsetStep: (k.dayView ? 1 : 7),
                });
                applySchedulerFilter("te", t.attr("data-linkparam"));

                defineLayout();

                $("#appTitle").attr("data-title", "").text(t.attr("data-linkparam"));
                k.refresh();
            }
        } else if (this.layoutType == "room") {
            if (checkProfileRights("ro", t.attr("data-linkparam"))) {
                k.layoutType = "date";
                currentProfile.set("dateFilter", {
                    offsetStep: (k.dayView ? 1 : 7),
                });
                applySchedulerFilter("ro", t.attr("data-linkparam"));

                defineLayout();

                $("#appTitle").attr("data-title", "").text(t.attr("data-linkparam"));
                k.refresh();
            }
        }
    } else {
        if (currentProfile.data.interactive == "url") {
            if (t.hasClass("ontime-scheduler-itemcontentdata")) {
                window.open(t.attr("data-linkparam"), '_blank');
            }
        } else if (currentProfile.data.interactive == "label") {
            // content click
            if (t.hasClass("aTeacher") || t.parents(".aTeacher").length > 0)
                a = "te";
            else if (t.hasClass("aClass") || t.parents(".aClass").length > 0)
                a = "cl";
            else if (t.hasClass("aRoom") || t.parents(".aRoom").length > 0)
                a = "ro";

            // TODO: execute checkProfileRights() in onEnter mouse event handler. if access granted, add class which makes the node clickable (bound mouse cursor and underline on hover to class, not to data-linkparam) 
            if (a != "") {
                if (checkProfileRights(a, t.attr("data-linkparam"))) {

                    if (k.layoutType != "date") {
                        k.layoutType = "date";
                        currentProfile.set("dateFilter", {
                            offsetStep: (k.dayView ? 1 : 7),
                        });
                        applySchedulerFilter(a, t.attr("data-linkparam"));
                        defineLayout();
                    } else {
                        applySchedulerFilter(a, t.attr("data-linkparam"));
                        defineLayout();
                    }
                    $("#appTitle").attr("data-title", "").text(t.attr("data-linkparam"));

                    k.refresh();
                } else {
                    //t[0].removeAttribute("data-linkparam");
                    //t.parents(".ontime-scheduler-itemcontentdata").addClass("linkparam-access-denied");
                }
            }
        }
    }
    //TODO: find related item in sidebar and mark it as selected
}


function initAppInfo() {
    if (document.body.classList.contains("private-account") || data.user.logbutton || data.user.profile !== "guest")
        $(".davinci-logout").css("display", "block");
    else
        $(".davinci-logout").css("display", "none");

    
  $("#appSubTitle").text(data.about.ownerDisplayname);
  
  $("#boxGenerator").text(data.about.server + " " + data.about.serverVersion);
  $("#boxETag").text(data.about.eTag);

  $("#boxOwnerName").text(data.about.ownerName || data.about.ownerDisplayname);
  $("#boxOwnerLocation").text(data.about.ownerLocation || "");

  var teamCodes = [];
  if (typeof data.user === "object" && typeof data.about === "object" && typeof data.result === "object") {
      if (
          ((data.user.profile == "team") || (data.user.profile == "teammaster")) &&
          data.user.homeType == "teacher" &&
          typeof data.user.homeId === "string" &&
          data.user.homeId != ""
      ) {
          var teamRefs = [];
          for (var k = 0; k < data.result.teachers.length; k++) {
              if (data.user.homeId == data.result.teachers[k].id) {
                  teamRefs = (data.result.teachers[k].teamRefs || []);
                  break;
              }
          }

          for (var i = 0; i < teamRefs.length; i++) {
              for (var j = 0; j < data.result.teams.length; j++) {
                  if (data.result.teams[j].id == teamRefs[i]) {
                      teamCodes.push(data.result.teams[j].code);
                      break;
                  }
              }
          }
      }
  }

  $("#boxProfile").text((data.user.profile || "default") + " " + teamCodes.join(","));

    
  $(".stat-data").each(function () {
    if (typeof data.result[$(this).attr("data-src")] !== "undefined")
        $(this).text(data.result[$(this).attr("data-src")].length);
    else if (typeof data.result.displaySchedule[$(this).attr("data-src")] !== "undefined")
        $(this).text(data.result.displaySchedule[$(this).attr("data-src")].length);
	else     
        $(this).text("-");
  });

  var serverTimeStamp = ONTIME.Date.parse(data.about.serverTimeStamp.replace(" ", ""), "YYYYMMDDHHMM")
  $("#appFooter .DD").text(serverTimeStamp.format("DD"));
  $("#appFooter .MM").text(serverTimeStamp.format("MM"));
  $("#appFooter .YYYY").text(serverTimeStamp.format("YYYY"));
  $("#appFooter .HHMM").text(serverTimeStamp.format("HH:mm"));


  setDavinciViewType(((["timetable", "substitutions", "floorplan", "calendar"].indexOf(currentProfile.data.view) >= 0) ? currentProfile.data.view : "timetable"));
}


function hideInfoPanel(){
	$(".blackout").css("display", "none");
	$(".msgbox").css("display", "none");
}
function showInfoPanel(){
	$(".msgbox").css("display", "block");
	$(".blackout").css("display", "block");
}



function reloadData() {
    if (!$("body").hasClass("web-icon-refresh-animate")) {
        $("body").addClass("web-icon-refresh-animate");
        
        //if (typeof data === "object" && typeof data.about === "object")
        //    data.about.eTag = "0";

        requestDavinciData(
            getDataUrl(), davinciDataPreprocess, currentProfile.data.requestMethod
        ).always(function () {
            $("body").removeClass("web-icon-refresh-animate");
        });
    }
}

function initLoginForm() {
    document.getElementById("davinci-login-username").value = currentProfile.data.username;
    document.getElementById("davinci-login-password").value = "";
}


function davinciResetAccount() {
    resetDavinciData();

    if (document.body.classList.contains("public-account") || currentProfile.data.account === "private") {
        // public -> private
        document.body.classList.remove("private-account");

        initLoginForm();
        document.getElementById("davinci-login-username").value = "";

        document.body.setAttribute("data-active-page", "login");
        document.body.classList.remove("enableContent");
        setDavinciViewType(((["timetable", "substitutions", "floorplan", "calendar"].indexOf(currentProfile.data.view) >= 0) ? currentProfile.data.view : "timetable"));
    } else {
        // private -> public
        document.body.classList.remove("public-account");
        onFormLoginPublic(false);

        document.body.setAttribute("data-active-page", "login");
        document.body.classList.remove("enableContent");
        setDavinciViewType(((["timetable", "substitutions", "floorplan", "calendar"].indexOf(currentProfile.data.view) >= 0) ? currentProfile.data.view : "timetable"));
    }
}


function onDavinciViewButtonClick() {
    var item = $(this);
    var view = item.attr("data-view");

    currentProfile.set("runtimeOptions", {
        "view": view
    });
    

    var currentView = $("#davinci-container").attr("data-view");
    if (currentView != view) {
        $(".btn-davinci-view").children(".btn").removeClass("btn-primary");
        item.parents(".btn-davinci-view").children(".btn").addClass("btn-primary");

        setDavinciViewType(view);
        if (view == "timetable") {
            if (!goCurrentTimePeriod()) {
                defineLayout();
                k.refresh();
            }
        }
    }
}

function setDavinciViewType(view) {
    // TODO: use parent container, so view attribute can be used to style toolbars 
    $("#davinci-container").attr("data-view", view);

    // TODO: control availability with css
    $("#btn-timeframe").css("display", view == "floorplan" ? "block" : "none");
    $("#btn-floor").css("display", view == "floorplan" ? "block" : "none");

    $("#btn-subst-filter").css("display",
        view == "substitutions"
        ? (
            (
                (data.user.profile == "teammaster") ||
                (data.user.profile == "teacher" && data.user.policy == 14) ||
                (data.user.profile == "master" && typeof data.user.homeType === "string" && typeof data.user.homeId === "string")
            )
                ? "block"
                : "none"
          )
        : "none");

    if (view == "substitutions") {
        $("#btn-subst-filter > button").removeClass("subst-all").addClass("subst-my");
        currentProfile.set("objectFilter", {
            filterSubst: (data.users.length > 1) ?"followFilter":"my",
        });

        $("#appTitle").hide();
        currentProfile.set("dateFilter", {
            offsetStep: 1, // changing in profile triggers fillSubstitutionsTable(...);
        });
    } else if (view == "calendar") {
        $("#appTitle").show();
        updateCalendar();
    } else if (view == "floorplan") {
        $("#appTitle").hide();
        currentProfile.set("dateFilter", {
            offsetStep: 1,
        });
        updateFloorplan();
    } else if (view == "timetable") {
        $("#appTitle").show();

        //k.layoutType = item.attr("data-scheduler-view");
        //k.layoutType = "date";
        //k.$el.attr("data-layouttype", k.layoutType);

        if (k.layoutType == "date") {
            currentProfile.set("dateFilter", {
                offsetStep: ((k.dayView) ? 1 : 7),
            });
        } else {
            // "teacher", "class", "room"
            currentProfile.set("objectFilter", {
                filter: {
                    te: null,
                    cl: null,
                    ro: null,
                }
            });
            currentProfile.set("dateFilter", {
                offsetStep: 1,
            });
        } 
    }
}

$(document).ready(function () {
    $(".xfr-progress").on("set-value", function (e, p) {
    });
});