﻿function onSubstFilterClick() {
    if ($(this).hasClass("subst-my")) {
        $("#btn-subst-filter > button").removeClass("subst-all subst-my").addClass("subst-my");
        currentProfile.set("objectFilter", {
            filterSubst: "my",
        });
    } else if ($(this).hasClass("subst-all")) {
        $("#btn-subst-filter > button").removeClass("subst-all subst-my").addClass("subst-all");
        currentProfile.set("objectFilter", {
            filterSubst: "all",
        });
    }

    fillSubstitutionsTable($("#table-subst").find("tbody")[0], 0);
    setTimeout(syncHeaders, 100);
}

$(document).on("scripts_ready", function () {
    $("#btn-subst-filter > ul").on("click", "li", onSubstFilterClick);
});


function fillSubstitutionsTable(tbody, pageSize) {
    
    var dataChanges = getSubstitutionsData(
        currentProfile.data.d,
        currentProfile.data.refTime().format("HHmm"),
        ("page" === currentProfile.data.substitutionShowExtra),
        (("all" === currentProfile.data.substitutionShowExtra) || (parseInt(currentProfile.data.substitutionShowExtra) > 0)),
        (
            (parseInt(currentProfile.data.substitutionShowExtra) > 0)
            ? currentProfile.data.getOffsetDate(
                currentProfile.data.dd,
                parseInt(currentProfile.data.substitutionShowExtra),
                currentProfile.data.weekdayStart,
                currentProfile.data.weekdayEnd || 7,
                (data.result.displaySchedule.eventTimes || []).filter(function (e) { return (e.noLessons && e.wholeDay && e.participants === undefined); })
                ).format("YYYYMMDD")
            : undefined
        ),
        pageSize
    );

    var r = [];
    var j = 0;
    var lastDate = "";

    var dateTodayStr = (new ONTIME.Date()).format();

    for (var i = 0; i < dataChanges.length; i++) {
        var content = dataChanges[i].changes.caption || "";

        var information = dataChanges[i].changes.information || "";
        if (information != "" && information != content) {
            if (content != "") content = content + ", ";
            content = content + information;
        }

        var _teacher = "";
        if (typeof dataChanges[i].changes === "object") {
            if (typeof dataChanges[i].changes.absentTeacherCodes === "object") {
                _teacher = '<span class="aAbsItem">' + getTeacherDisplayNames(dataChanges[i].changes.absentTeacherCodes).join(", ") + '</span>';
            }
        }
        if ((_teacher.length == 0) && (typeof dataChanges[i].teacherCodes === "object")) {
            _teacher = '<span>' + getTeacherDisplayNames(dataChanges[i].teacherCodes).join(", ") + '</span>';
        }

        var _steacher = "";
        if (typeof dataChanges[i].changes === "object") {
            if ((typeof dataChanges[i].changes.newTeacherCodes === "undefined") && (dataChanges[i].changes.changeType == 3)) {
                _steacher = getTeacherDisplayNames(dataChanges[i].teacherCodes);
            } else {
                _steacher = getTeacherDisplayNames(dataChanges[i].changes.newTeacherCodes);
            }
        }

        var o = {
            "sameDay": (lastDate == dataChanges[i].dates[0]),
            "pageTop": (pageSize != 0 && (j % pageSize == 0)),

            "date": ONTIME.Date.parse(dataChanges[i].dates[0]).format("DD.MM.YYYY"),
            "date_dd": ONTIME.Date.parse(dataChanges[i].dates[0]).format("DD"),
            "date_mm": ONTIME.Date.parse(dataChanges[i].dates[0]).format("MM"),
            "date_yyyy": ONTIME.Date.parse(dataChanges[i].dates[0]).format("YYYY"),

            "weekDay": ONTIME.Date.parse(dataChanges[i].dates[0]).getDay(),

            "isMessage": (dataChanges[i].changes.changeType == 4),
            "isMessageDay": (dataChanges[i].changes.changeType == 4 && dataChanges[i].startTime == "0000" && dataChanges[i].endTime == "0000"),

            "pos": getLessonPos(dataChanges[i], dataChanges[i]._timeslotIndex),
            "time": getLessonTime(dataChanges[i], dataChanges[i]._timeslotIndex),

            //"teacher": _teacher,
            "teacher": buildChangeItem(dataChanges[i], "teacherCodes", "newTeacherCodes", "absentTeacherCodes"),


            "subject": dataChanges[i].courseTitle || (dataChanges[i].subjectCode || ""),
            "room": dataChanges[i].areaCode || buildChangeItem(dataChanges[i], "roomCodes", "newRoomCodes", "absentRoomCodes"),
            "class": buildChangeItem(dataChanges[i], "classCodes", "newClassCodes", "absentClassCodes"),
            "steacher": _steacher,

            "rteacher": dataChanges[i]._rteacherCode || "",

            "content": content,
            "caption": dataChanges[i].changes.caption || "",
            "info": dataChanges[i].changes.information || "",
            "message": dataChanges[i].changes.message || "",  
        };

        var rowMarks = ["newDate", "newStartTime", "oldDate", "oldStartTime", "newTeacherCodes", "absentTeacherCodes", "newRoomCodes", "absentRoomCodes", "newClassCodes", "absentClassCodes", "newSubjectCode"]
        .filter(function (attr) {
            return (dataChanges[i].changes[attr] != undefined);
        });

        if (dataChanges[i].dates[0] == dateTodayStr)
            rowMarks.push("isToday");
        if (dataChanges[i].changes.changeType == 3)
            rowMarks.push("newLesson");
        if (dataChanges[i].changes.changeType == 4)
            rowMarks.push("newMessage");

        r.push(
            '<tr' +
            ' data-i="' + dataChanges[i]._i + '"' + 
            ' class="' + rowMarks.join(" ") + '"' + 
            ((typeof dataChanges[i].supervisionTitle !== "undefined") ? ' data-change-defaultsupervisioncaption' : '') +
            '>' +
            fnMapSubstitutionsColumns.get(currentProfile.data.substKey)(
                fnGetSubstitutionsColumns.get(currentProfile.data.substKey)(),
                o
            ) +
            '</tr>'
        );

        lastDate = dataChanges[i].dates[0];
        j++;
    }

    var mdays = false;
    if (dataChanges.length >= 2 && dataChanges[0].dates[0] !== dataChanges[dataChanges.length - 1].dates[0])
        mdays = true;
    if (dataChanges.length >= 1 && dataChanges[0].dates[0] !== currentProfile.data.d)
        mdays = true;

    tbody.parentNode.setAttribute("data-multiple-days", mdays ? "true" : "false");

    if (dataChanges.length > 0)
        tbody.parentNode.classList.remove("no-content");
    else
        tbody.parentNode.classList.add("no-content");

    tbody.innerHTML = r.join("");
}


function fillSubstitutionsHeader(node) {
    var refDate = currentProfile.data.refDate().format();

    var r1 = "";
    var r2 = "";
    var r3 = "";

    if (fnGetSubstitutionsHeaderParts.get(currentProfile.data.substKey)().indexOf("teacher") != -1 && typeof data.result.teacherAbsences === "object") {
        r1 = data.result.teacherAbsences
            .filter(function (e) {
                return (e.startDate <= refDate && (e.endTime !== "0000" && refDate <= e.endDate || refDate < e.endDate));
            })
            .map(function (e) {
                if (typeof e._teacherCodesIndex === "object" && e._teacherCodesIndex.length > 0) {
                    var t = "";
                    var a = ""

                    if ((e.startTime == "0000" || e.startDate < refDate) && (e.endTime == "0000" || refDate < e.endDate))
                        a = 'data-whole-day="1"';
                    else {
                        if (typeof e._timeslots === "object" && typeof e._timeframeIndex === "number")
                            t = " (" +
                                e._timeslots
                                .filter(function (ee, ii, aa) {
                                    return (ii == 0 || ii == (aa.length - 1)); // first & last
                                })
                                .map(function (ee) {
                                    with (data.result.timeframes[e._timeframeIndex].timeslots[ee]) {
                                        return ((typeof label === "string") ? label : (startTime.replace(/(\d\d)(\d\d)/, "$1:$2") + " - " + endTime.replace(/(\d\d)(\d\d)/, "$1:$2")));
                                    }
                                })
                                .join("-") +
                            ")";
                        else
                            t = " (" + e.startTime.replace(/(\d\d)(\d\d)/, "$1:$2") + " - " + e.endTime.replace(/(\d\d)(\d\d)/, "$1:$2") + ")";
                    }

                    return '<span ' + a + '>' + (data.result.teachers[e._teacherCodesIndex[0]].code + t) + '</span>';
                }

                return null;
            }).join(", ");
    }

    if (fnGetSubstitutionsHeaderParts.get(currentProfile.data.substKey)().indexOf("class") != -1 && typeof data.result.classAbsences === "object") {
        r2 = data.result.classAbsences
            .filter(function (e) {
                return (e.startDate <= refDate && (e.endTime !== "0000" && refDate <= e.endDate || refDate < e.endDate));
            })
            .map(function (e) {
                if (typeof e._classCodesIndex === "object" && e._classCodesIndex.length > 0) {
                    var t = "";
                    var a = ""

                    if ((e.startTime == "0000" || e.startDate < refDate) && (e.endTime == "0000" || refDate < e.endDate))
                        a = 'data-whole-day="1"';
                    else {
                        if (typeof e._timeslots === "object" && typeof e._timeframeIndex === "number")
                            t = " (" +
                                e._timeslots
                                .filter(function (ee, ii, aa) {
                                    return (ii == 0 || ii == (aa.length - 1)); // first & last
                                })
                                .map(function (ee) {
                                    with (data.result.timeframes[e._timeframeIndex].timeslots[ee]) {
                                        return ((typeof label === "string")?label:(startTime.replace(/(\d\d)(\d\d)/, "$1:$2") + " - " + endTime.replace(/(\d\d)(\d\d)/, "$1:$2")));
                                    }
                                })
                                .join("-") +
                            ")";
                        else
                            t = " (" + e.startTime.replace(/(\d\d)(\d\d)/, "$1:$2") + " - " + e.endTime.replace(/(\d\d)(\d\d)/, "$1:$2") + ")";
                    }

                    return '<span ' + a + '>' + (data.result.classes[e._classCodesIndex].code + t) + '</span>';
                }

                return null;
            }).join(", ");
    }

    if (typeof data.result.displaySchedule === "object" && typeof data.result.displaySchedule.lessonTimes === "object") {
        r3 = data.result.displaySchedule.lessonTimes
            .filter(function (e) {
                return (e.dates[0] == refDate && typeof e.changes === "object" && e.changes.changeType == 4 && e.startTime == "0000" && e.endTime == "0000");
            })
            .map(function (e) {
                return e.changes.information;
            }).join(", ");
    }

    var r = [];

    if (r1 != "")
        r.push('<div class="teacherAbsences">' + r1 + '</div>');

    if (r2 != "")
        r.push('<div class="classAbsences">' + r2 + '</div>');

    if (r3 != "")
        r.push('<div class="dayMessages">' + r3 + '</div>');

    node.innerHTML = r.join("");
}
