﻿/*!
 	DAVINCI APP v1.0.0 
 	Copyright (c) 2014 STÜBER SYSTEMS GmbH, http://www.stueber.de
	
	Filter and handler
*/

var k;


function initScheduler() {
    k = new ONTIME.Scheduler({
        el: $(".ontime-scheduler")[0],
        cellBuilderCallback: resolveCell,
        layoutType: currentProfile.data.timetableFormat,
        filterParams: {
            profile: currentProfile,
        },
        dayView: currentProfile.data.timetableDateFormat === "day",
        drawHeaders: function () {
            ONTIME.Scheduler.prototype.drawHeaders.call(this);
            markCurrentTimeslot(this);
        },
        handleResize: function () {
            if (!this.dayView && currentProfile.data.timetableLock !== "true" && this.$el.width() < 775) {
                // shrink filter = single day
                set1Day(true);
            } else if (this.dayView && currentProfile.data.timetableLock !== "true" && this.$el.width() > 825) {
                // expand filter to the whole week containing the day
                set1Day(false);
            } else {
                ONTIME.Scheduler.prototype.handleResize.call(this);
            }
        },
        getDaysCount: function () {
            if (this.layoutType == "class" || this.layoutType == "teacher" || this.layoutType == "room" || this.dayView)
                return 1;
            else
                return (
                    (data.result.displaySchedule.weekspan.weekdayEnd||7) -
                    data.result.displaySchedule.weekspan.weekdayStart
                    + 1
                );
        },
    });


    k.layers.push(new ONTIME.SchedulerLayer({
        scheduler: k,
        el: k.$el.find('.ontime-scheduler-items-lessons'),
        getItems: function () {
            return data.result.displaySchedule.lessonTimes;
        },
        filterItem: filterDataItems,
        ungroupItem: ungroupDataItem,
        maxParallelItems: parseInt(currentProfile.data.maxParallelItems),
        getMaxParallelItems: function () {
            return ((this.scheduler.dayView && this.scheduler.layoutType == "date") ? 10 : this.maxParallelItems);
        },
        itemsCompare: davinciLessonItemsCompare,
        refresh3: function (p) {
            ONTIME.SchedulerLayer.prototype.refresh3.call(this, p);

            var waiLayer = k.$el.find('.ontime-scheduler-items-wai');
            if (waiLayer.length > 0 && currentProfile.data.wai) {
                waiLayer.empty();

                var topHeader = this.scheduler.topHeader;
                var leftHeader = this.scheduler.leftHeader;

                var columnHeader = $('<div role="row" class="row" id="columnheader"></div>');
                columnHeader.append(
                    '<div role="columnheader" id="hour_col">Stunden</div>',
                    topHeader.items.map(function (e) {
                        // depends on table mode
                        return ('<div role="columnheader" id="wai-col-' + e[0] + '">' + e[2] + '</div>');
                    })
                );
                    
                var lessonItems = ([].concat(this.r1, this.r2)).map(function (e) {
                    var e1 = $("<div></div>");
                    ["data-xi", "data-yi", "data-i", "style", "class"].forEach(function (o) {
                        e1.attr(o, e.attr(o));
                    });

                    e1.attr({
                        "id": "wai-node-" + e.attr("id"),
                        "role": "gridcell",
                        "aria-labelledby":
                            "wai-row-" + e1.attr("data-yi") +
                            " " +
                            "wai-col-" + e1.attr("data-xi")
                    });

                    var i = parseInt(e1.attr("data-i"));
                    var o = data.result.displaySchedule.lessonTimes[i];

                    var out = [];

                    if (o.courseTitle)
                        out.push('<abbr title="Fach: ' + o.courseTitle + '">' + o.courseTitle + '</abbr>');

                    if (o.classCodes)
                        out.push('<abbr title="Klassen: ' + o.classCodes.join(", ") + '">' + o.classCodes.join(", ") + '</abbr>');

                    if (o.teacherCodes)
                        out.push('<abbr title="Lehrer: ' + o._teacherCodesIndex.map(function (e) { return [data.result.teachers[e].firstName, data.result.teachers[e].lastName].join(" "); }).join(", ") + '">' + o.teacherCodes.join(", ") + '</abbr>');

                    if (o.roomCodes)
                        out.push('<abbr title="Räume: ' + o.roomCodes.join(", ") + '">' + o.roomCodes.join(", ") + '</abbr>');

                    e1.append(out.join(", "))
                    return e1;
                });

                var rowsContent = leftHeader.items.map(function (row) {
                    var rowContent = $('<div role="row" class="row"></div>');
                    var rowHeader = $('<div role="rowheader" id="wai-row-' + row[0] + '" class="rowheader">' +
                        //leftHeader.items[i][2].label + ": " +
                        row[2].startTime.replace(/(\d\d)(\d\d)/, "$1:$2") +
                        ' - ' +
                        row[2].endTime.replace(/(\d\d)(\d\d)/, "$1:$2") + '</div>');

                    rowContent.append(rowHeader);
                    $.prototype.append.apply(rowContent, topHeader.items.map(function (col) {
                        var cellLessonItems = lessonItems.filter(function (e) {
                            return (e.attr("data-xi") == col[0] && e.attr("data-yi") == row[0]);
                        });

                        var items = (cellLessonItems.length == 0)
                            ? [$('<div role="gridcell"></div>')
                                .attr({
                                    "role": "gridcell",
                                    "aria-labelledby":
                                        "wai-row-" + row[0] +
                                        " " +
                                        "wai-col-" + col[0]
                                })]
                            : cellLessonItems
                        ;

                        return items;
                    }));

                    return rowContent;
                });

                waiLayer.append(columnHeader, rowsContent);
            }
        },
    }));

    k.layers.push(new ONTIME.SchedulerLayer({
        scheduler: k,
        el: k.$el.find('.ontime-scheduler-items-events'),
        getItems: function () {
            return data.result.displaySchedule.eventTimes;
        },
        filterItem: filterEventItems,
    }));

    k.layers.push(new ONTIME.SchedulerLayer({
        scheduler: k,
        el: k.$el.find('.ontime-scheduler-items-supervision'),
        getItems: function () {
            return data.result.displaySchedule.supervisionTimes;
        },
        filterItem: filterSupervisionItems,
        ungroupItem: ungroupSupervisionItem,
    }));


    var absencesLayer = k.$el.find('.ontime-scheduler-items-absences');
    if (absencesLayer.length > 0) {
        k.layers.push(new ONTIME.SchedulerLayer({
            scheduler: k,
            el: k.$el.find('.ontime-scheduler-items-absences'),
            getItems: function () {
                return Array.prototype.concat.call([], data.result.classAbsences, data.result.teacherAbsences, data.result.roomAbsences);
            },
            filterItem: filterAbsenceItems,
            ungroupItem: ungroupAbsenceItem,
        }));
    }

    k.$el.attr("data-itemclick", currentProfile.data.interactive);

    currentProfile.set("dateFilter", {
        offsetStep: ((k.layoutType == "date" && !k.dayView) ? 7 : 1),
    });
}

function getLessonEntriesByTime(p) {
	var r = {
		rooms: [],
		roomStates: [],
		displaySchedule: {
			lessonTimes: []
		}
		
	};

	var dt = new ONTIME.Date(p);
	var dtd = dt.format("YYYYMMDD");
	var dtt = dt.format("HHmm");

	var filterParams = {
		profile: currentProfile,
	};
	
	
	if(typeof data.result === "object") {
		for(var i=0; i < data.result.displaySchedule.lessonTimes.length; i++) {
			if(
				data.result.displaySchedule.lessonTimes[i].startTime <= dtt && data.result.displaySchedule.lessonTimes[i].endTime > dtt 
				&&
				(data.result.displaySchedule.lessonTimes[i].dates || []).indexOf(dtd) >=0
			) {
				if(filterDataItems(data.result.displaySchedule.lessonTimes[i], filterParams, 1)) {
					var uItems = ungroupDataItem(data.result.displaySchedule.lessonTimes[i]);
					for(var j=0; j<uItems.length; j++) {
						if(uItems.length == 1 || filterDataItems(uItems[j], filterParams, 2)) {
							r.displaySchedule.lessonTimes.push(uItems[j]);
						}
					}
				}
			}
		}
		[].push.apply(r.rooms, data.result.rooms);
		[].push.apply(r.roomStates, data.result.roomStates);
	}

	return r;
}

function registerDocumentCallback() {
	$(document).on.apply($(document), arguments);
}