﻿
function fillNowTable(tbody, pageSize) {

	var refTime = currentProfile.data.refTime().format("HHmm");
	var refDate = currentProfile.data.d;

    var dataChanges = getNowData(
        currentProfile.data.d,
        refTime,
        currentProfile.data.nowView,
        pageSize
    );

    var r = [];
    var j = 0;
    var lastDate = "";
    var lastLessonBlock = "";

	
    for (var i = 0; i < dataChanges.length; i++) {
        if (typeof dataChanges[i].changes !== "object")
            dataChanges[i].changes = {};

        var caption = dataChanges[i].changes.caption || "";
        var information = dataChanges[i].changes.information || "";

        var cmi = caption;
        if (information != "" && information != caption) {
            if (cmi != "") cmi = cmi + ", ";
            cmi = cmi + information;
        }

        var _teacher = "";
        if (typeof dataChanges[i].changes === "object") {
            if (typeof dataChanges[i].changes.absentTeacherCodes === "object") {
                _teacher = '<span class="aAbsItem">' + getTeacherDisplayNames(dataChanges[i].changes.absentTeacherCodes).join(", ") + '</span>';
            }
        }
        if ((_teacher.length == 0) && (typeof dataChanges[i].teacherCodes === "object")) {
            _teacher = '<span>' + getTeacherDisplayNames(dataChanges[i].teacherCodes).join(", ") + '</span>';
        }

        var o = {
            "sameDay": (lastDate == refDate),
            "pageTop": (pageSize != 0 && (j % pageSize == 0)),

            "date": ONTIME.Date.parse(refDate).format("DD.MM.YYYY"),
            "date_dd": ONTIME.Date.parse(refDate).format("DD"),
            "date_mm": ONTIME.Date.parse(refDate).format("MM"),
            "date_yyyy": ONTIME.Date.parse(refDate).format("YYYY"),

            "weekDay": ONTIME.Date.parse(refDate).getDay(),

            "isMessage": (dataChanges[i].changes.changeType == 4),
            "isMessageDay": (dataChanges[i].changes.changeType == 4 && dataChanges[i].startTime == "0000" && dataChanges[i].endTime == "0000"),

            "pos": getLessonPos(dataChanges[i], dataChanges[i]._timeslotIndex),
            "time": getLessonTime(dataChanges[i], dataChanges[i]._timeslotIndex),
            "lessonStartTime": dataChanges[i].startTime,
            "lessonEndTime": dataChanges[i].endTime,

            "lessonBlock": (dataChanges[i].lessonBlock || ""),

            "sameLessonBlock": ((typeof dataChanges[i].lessonBlock === "string") && (dataChanges[i].lessonBlock == lastLessonBlock)),

            "lessonTime": (
				"<span>" + dataChanges[i].startTime.replace(/(\d\d)(\d\d)/, "$1:$2").replace(/(.)/g, "<span>$1</span>") + "</span>"+
				"<span>" + dataChanges[i].endTime.replace(/(\d\d)(\d\d)/, "$1:$2").replace(/(.)/g, "<span>$1</span>") + "</span>"
			),
			
			"time-fit-mark": (currentProfile.data.nowScope !== "actual" && dataChanges[i].dates.indexOf(currentProfile.data.d) != -1 && refTime.localeCompare(dataChanges[i].startTime) >=0 && refTime.localeCompare(dataChanges[i].endTime) <=0),

            //"teacher": buildChangeItem(dataChanges[i], "teacherCodes", "-newTeacherCodes", "absentTeacherCodes"),

			"lessonCourseDescription": dataChanges[i].courseDescription,
			"courseRemarks": (function (ref) {
			    // courses: [{"id":"FD42814D-373B-4DF8-A4DD-B1195D5EA929","title":"LMK","description":"Mit Herz und Verstand ausbilden","subjectRef":"652290F1-E343-4841-9986-61B26F74BBD4","courseTypeRef":"E4168C73-8238-487D-9484-46D3AB50344B","remarks":"0900-1630"}]
			    //"courseRef":"FD42814D-373B-4DF8-A4DD-B1195D5EA929"
			    var r = "";

			    var k = arrayLookup(data.result.courses, ref, "id");
			    if (k >= 0)
			        r = data.result.courses[k].remarks;

			    return r;
			})(dataChanges[i].courseRef),

			"classDescription": (dataChanges[i]._classCodesIndex || []).map(function (e) {
			    return data.result.classes[e].description
			}).join(", "),

            "teacher": _teacher,

            "subject": dataChanges[i].courseTitle || (dataChanges[i].subjectCode || ""),
            "room": dataChanges[i].areaCode || buildChangeItem(dataChanges[i], "roomCodes", "newRoomCodes", "absentRoomCodes"),
            "building": dataChanges[i].buildingCodes ? dataChanges[i].buildingCodes.join(", ") : "",
            "buildingDescription": (dataChanges[i]._buildingCodesIndex || []).map(function (e) {
                return data.result.buildings[e].description
            }).join(", "),

            "class": buildChangeItem(dataChanges[i], "classCodes", "newClassCodes", "absentClassCodes"),
            "steacher": (
                (typeof dataChanges[i].changes.newTeacherCodes === "undefined")
                    ? (
                        (dataChanges[i].changes.changeType == 3)
                            ? dataChanges[i].teacherCodes
                            : ""
                    )
                    : dataChanges[i].changes.newTeacherCodes
            ),

            "content": cmi,
            "caption": dataChanges[i].changes.caption || "",
            "info": dataChanges[i].changes.information || "",
            "message": dataChanges[i].changes.message || "",
        };

        r.push(
            '<tr class="' + (o["time-fit-mark"]?"time-fit-mark":"") + '">' +
            fnMapSubstitutionsColumns.get(currentProfile.data.substKey)(
                fnGetSubstitutionsColumns.get(currentProfile.data.substKey)(),
                o
            ) +
            '</tr>'
        );

        lastDate = refDate;
        lastLessonBlock = (dataChanges[i].lessonBlock || "");
        j++;
    }

    //tbody.parentNode.setAttribute("data-multiple-days", (dataChanges.length >= 2 && dataChanges[0].dates[0] !== dataChanges[dataChanges.length - 1].dates[0]) ? "true" : "false");
    tbody.parentNode.setAttribute("data-multiple-days", "false");

    if (dataChanges.length > 0)
        tbody.parentNode.classList.remove("no-content");
    else
        tbody.parentNode.classList.add("no-content");

    tbody.innerHTML = r.join("");
}

function fillNowMatrix(tflex, pageSize) {

    var dataChanges = getNowData(
        currentProfile.data.d,
        currentProfile.data.refTime().format("HHmm"),
        currentProfile.data.nowView,
        pageSize
    );

    var r = [];
    var j = 0;
    var lastDate = "";

    for (var i = 0; i < dataChanges.length; i++) {
        if (typeof dataChanges[i].changes !== "object")
            dataChanges[i].changes = {};

        var caption = dataChanges[i].changes.caption || "";
        var information = dataChanges[i].changes.information || "";

        var cmi = caption;
        if (information != "" && information != caption) {
            if (cmi != "") cmi = cmi + ", ";
            cmi = cmi + information;
        }

        var o = {
            "sameDay": (lastDate == dataChanges[i].dates[0]),
            "pageTop": (pageSize != 0 && (j % pageSize == 0)),

            "date": ONTIME.Date.parse(dataChanges[i].dates[0]).format("DD.MM.YYYY"),
            "date_dd": ONTIME.Date.parse(dataChanges[i].dates[0]).format("DD"),
            "date_mm": ONTIME.Date.parse(dataChanges[i].dates[0]).format("MM"),
            "date_yyyy": ONTIME.Date.parse(dataChanges[i].dates[0]).format("YYYY"),

            "weekDay": ONTIME.Date.parse(dataChanges[i].dates[0]).getDay(),

            "isMessage": (dataChanges[i].changes.changeType == 4),
            "isMessageDay": (dataChanges[i].changes.changeType == 4 && dataChanges[i].startTime == "0000" && dataChanges[i].endTime == "0000"),

            "pos": getLessonPos(dataChanges[i], dataChanges[i]._timeslotIndex),
            "time": getLessonTime(dataChanges[i], dataChanges[i]._timeslotIndex),

            "teacher": buildChangeItem(dataChanges[i], "teacherCodes", "newTeacherCodes", "absentTeacherCodes"),
            "subject": dataChanges[i].courseTitle || (dataChanges[i].subjectCode || ""),
            "room": dataChanges[i].areaCode || buildChangeItem(dataChanges[i], "roomCodes", "newRoomCodes", "absentRoomCodes"),
            "class": buildChangeItem(dataChanges[i], "classCodes", "newClassCodes", "absentClassCodes"),
            "steacher": (
                (typeof dataChanges[i].changes.newTeacherCodes === "undefined")
                    ? (
                        (dataChanges[i].changes.changeType == 3)
                            ? dataChanges[i].teacherCodes
                            : ""
                    )
                    : dataChanges[i].changes.newTeacherCodes
            ),

            "content": cmi,
            "caption": dataChanges[i].changes.caption || "",
            "info": dataChanges[i].changes.information || "",
            "message": dataChanges[i].changes.message || "",
        };

        var bgClass = "";
        var bgStyle = "";

        if (data.result.displaySchedule.display.lessonGradient != 0) {
            var refCollectionProperty = ["", "subjects", "classes", "teachers", "rooms"];
            var refParamProperty = ["", "subjectCode", "classCodes", "teacherCodes", "roomCodes"];

            if (data.result.displaySchedule.display.lessonColor > 0 && data.result.displaySchedule.display.lessonColor <= 4) {
                var refCollection = data.result[refCollectionProperty[data.result.displaySchedule.display.lessonColor]];

                var params = dataChanges[i];

                // TODO: optimize lookup performance
                if (typeof params[refParamProperty[data.result.displaySchedule.display.lessonColor]] !== "undefined") {
                    for (var j = 0; j < refCollection.length; j++) {
                        if (
                            data.result.displaySchedule.display.lessonColor == 1
                                ? (params[refParamProperty[data.result.displaySchedule.display.lessonColor]] === refCollection[j].code)
                                : (params[refParamProperty[data.result.displaySchedule.display.lessonColor]].indexOf(refCollection[j].code) >= 0)
                        ) {
                            if (refCollection[j].color !== undefined) {
                                if (data.result.displaySchedule.display.lessonGradient == 1) {
                                    bgStyle = bgStyle + " background-image: linear-gradient(" + refCollection[j].color + ", " + refCollection[j].color + "), linear-gradient(rgba(0,0,0,0), rgba(0,0,0,0)); ";

                                } else if (data.result.displaySchedule.display.lessonGradient == 2) {
                                    bgStyle = bgStyle + " background-image: none; background-color: " + refCollection[j].color + "; ";
                                }

                                if (typeof params.changes === "object" && typeof params.changes.cancelled !== "undefined") {
                                    //bgClass = bgClass + " bgHatch ";
                                }

                                if (isColorDark(refCollection[j].color))
                                    bgClass = bgClass + " item-content-bg-dark ";
                                if (isColorLight(refCollection[j].color))
                                    bgClass = bgClass + " item-content-bg-light ";
                            }
                            break;
                        }
                    }
                }
            }
        }

        r.push(
            '<div data-i="' + i + '" class="' + bgClass + '" style="' + bgStyle + '">' +
			    '<div>' +
                    '<div class="aTime"><span>' + o["pos"] + '</span>' + '<span>' + o['time'] + '</span></div>' +
                '</div>' +

			    '<div>' + 
				    '<span class="aSubject">' + o['subject'] + '</span>' + '<span class="aTeacher">' + o['teacher'] + '</span>' +
			    '</div>' +

			    '<div>' + 
				    '<span class="aClass">' + o['class'] + '</span>' + '<span class="aRoom">' + o['room'] + '</span>' +
			    '</div>' +
            '</div>'
        );

        lastDate = dataChanges[i].dates[0];
        j++;
    }

    tflex.setAttribute("data-multiple-days", (dataChanges.length >= 2 && dataChanges[0].dates[0] !== dataChanges[dataChanges.length - 1].dates[0]) ? "true" : "false");

    if (dataChanges.length > 0)
        tflex.classList.remove("no-content");
    else
        tflex.classList.add("no-content");

    tflex.innerHTML = (r.length
        ? r.join("")
        : '<div style="display: block; visibility: hidden;"><div><div><span class="aPos"></span><span class="aTime"></span></div></div><div><span class="aSubject"></span><span class="aTeacher"><span></span></span></div><div><span class="aClass"><span></span></span><span class="aRoom"><span></span></span></div></div>'
    );
}


function getFlexPageSize(tflex) {
    var r = 0;

    var rh = 0;
    var rw = 0;

    var oHeight = tflex.parentElement.clientHeight;
    var oWidth = tflex.parentElement.clientWidth;

    var eHeight = tflex.firstElementChild.offsetHeight;
    var eWidth = tflex.firstElementChild.offsetWidth;

    if (eHeight > 0 && oHeight > eHeight) {
        rh = Math.floor(oHeight / eHeight);
    }

    if (eWidth > 0 && oWidth > eWidth) {
        rw = Math.floor(oWidth / eWidth);
    }

    r = rh * rw;
    if (r < 1)
        r = 1;

    return r;
}
