﻿function inflateDavinciData(prefix, template) {
    $.support.cors = true;

    var r = $.ajax({
        url: prefix + template,
        dataType: "html",
    });

    r.done(function (response) {
        var
            headB = response.indexOf("<head>"),
            headE = response.indexOf("</head>"),
            bodyB = response.indexOf("<body>"),
            bodyE = response.indexOf("</body>"),
            extraB = response.indexOf("</body>"),
            extraE = response.indexOf("</html>");

        var headInflate = response.slice(headB + 6, headE);
        var bodyInflate = response.slice(bodyB + 6, bodyE);
        var extraInflate = response.slice(extraB + 7, extraE);

        // -------------------------------------------

        // document.head.innerHTML = headInflate;
        var headInflateDom = $(headInflate);
        headInflateDom.each(function () {
            if (typeof this.hasAttribute==="function" && this.hasAttribute("href")) {
                var href = this.getAttribute("href");
                if (href.length > 0) {
                    this.href = prefix + href;
                }
            }
        });
        $("head").append(headInflateDom);


        document.body.innerHTML = bodyInflate;

        //$("body").after(extraInflate);
        var extraInfalteDom = $(extraInflate).filter("script");
        var deferreds = [];

        extraInfalteDom.each(function () {
            if (this.hasAttribute("src")) {
                var src = this.getAttribute("src");
                if (!this.hasAttribute("data-noinflate") && src.length > 0) {
                    var deferred = new $.Deferred();
                    var n = document.createElement("script");
                    n.type = this.type;
                    n.src = prefix + src;
                    n.onload = $.proxy(function (d) {
                        d.resolve();
                    }, window, deferred);
                    deferreds.push(deferred);
                    document.head.appendChild(n); // TBD: where to append? head or the original place of appearence
                }
            } else {
                //$("html").append(this);
                // console.log("------------------------" + this.innerHTML + "------------------------");
                eval(this.innerHTML);
            }
        });


        if (deferreds.length > 0) {
            $.when.apply(window, deferreds).then(function () {
                $(document).trigger("scripts_ready", { inflated: true });
                //cb();
            });
        } else {
            $(document).trigger("scripts_ready", { inflated: true });
            //cb();
        }

        

        /*
        // TODO: omit using jQuery
        var extraNodes = document.createDocumentFragment();
        extraNodes.innerHTML = extraInflate;
        document.insertBefore(extraNodes, null);
        */

        
    })
    .fail(function (jqXHR, textStatus, errorThrown) {
//        console.log(textStatus);
    })
    ;
}


