


$(document).on("scripts_ready", function(){
	$(".roomInfo .close").click(function(){
		$(".roomInfo").css("display", "none");
	});
	
	$("#btn-floor > ul").on("click", "li", onFloorClick);
	
	currentProfile.callbacks.add(function () {
	    $(".roomInfo").css("display", "none");
	    updateFloorplan();
	});

	davinciFloorplanCallbacks.add(
		function (arg) {
			$('.btn-davinci-view button[data-view="floorplan"]').parent().css("display", "inline");
			
			// fill floor index 
			for(var i=0; i<floorPlanViews.length; i++) 
			    $("#btn-floor > ul").append('<li><a href="#"><span>' + floorPlanViews[i].title + '</span><span>' + floorPlanViews[i].buildings.join(",") + '</span></a></li>');
			
			updateFloorTitle();
			initFloorplan(arg);

			$(".ontime-floorplan-svg-object").eq(currentProfile.data.floor).addClass("active-floor");
		}
	);
});



function initFloorplan(arg) {
	floorPlan = new ONTIME.Floorplan({
        filterItem: filterRoomItems,
        filterParams: {
            //t: new ONTIME.Date().format("HHmm"),
            t: currentProfile.data.refTime().format("HHmm"),
            profile: currentProfile,
        },
        translateItem: translateRoomItem,
        ungroupItem: ungroupRoomItem,
        roomClick: onRoomClick,
	});
	
	$(".ontime-floorplan-svg-object").remove();

	for (var i = floorPlanViews.length - 1; i >= 0 ; i--) {
		var $el = $('<div class="ontime-floorplan-svg-object" data-index="' + i + '"></div>').prependTo($("#davinci-floorplan"));

		if (floorPlanViews[i].metadata)
			$el.data(floorPlanViews[i].metadata);

		floorPlan.floors.push(
			new ONTIME.Floor({
		        plan: floorPlan,
		        index: i,
		        title: floorPlanViews[i].title,
		        definition: floorPlanViews[i],
		        el: $el[0],
		        src: arg.urlPrefix + floorPlanViews[i].url,
		        onLoad: function (data) {

		            ONTIME.Floor.prototype.onLoad.call(this, data);

		            var textScale = parseFloat(currentProfile.data.floorplanTextScale);
		            if (textScale >= 0.1 && textScale <= 10) {
		                $(this.svgDoc).find('text[inkscape\\:label^="Room\\:"] > tspan')
                        .css({
                            "font-size": (textScale * 100) + "%",
                        }).removeAttr("y").attr("dy", "1ex");
		            }

		            this.clearGraphics();

		            this.plan.refresh();
		            this.drawGraphics();

                    if (typeof currentProfile.data.floorplanScale !== "undefined") {
                        var w = parseFloat(this.svgDoc.getAttribute("width")) || 0;
                        var h = parseFloat(this.svgDoc.getAttribute("height")) || 0;
                        var s = parseFloat(currentProfile.data.floorplanScale) || 0;
                        if (w > 0 && h > 0 && s > 0) {
                            this.svgDoc.setAttribute("width", w * s);
                            this.svgDoc.setAttribute("height", h * s);
                            this.svgDoc.style["transform"] = "scale(1, 1)";
                        } else {
                            this.svgDoc.style["transform"] = "scale(" + currentProfile.data.floorplanScale + ", " + currentProfile.data.floorplanScale + ")";
                        }
		            }
		        },
			}));
	}
	
	davinciDataCallbacks.add(function(){
		floorPlan.getItems = function() {
            return data.result.displaySchedule.lessonTimes;
		};
        updateFloorplan();
	});	
}


function onFloorClick() {
	$(".roomInfo").css("display", "none");
	
	currentProfile.set("floorFilter", {
	    floor: $(this).index()
	});
    
	$(".ontime-floorplan-svg-object").removeClass("active-floor");
	$(".ontime-floorplan-svg-object").eq(currentProfile.data.floor).addClass("active-floor");
	
	updateFloorTitle();
}

function updateFloorTitle() {
    $("#btn-floor > button").html(floorPlanViews[currentProfile.data.floor].title);
}




function updateFloorplan() {
    if (typeof floorPlan === "object") {
        floorPlan.clearGraphics();

        if (typeof data === "object" && typeof data.result === "object" && typeof data.result.timeframes === "object" && data.result.timeframes.length > 0 && typeof data.result.timeframes[0].timeslots === "object") {

            if (currentProfile.data.floorplanRoomColor)
                floorPlan.assignFillColor(data.result.rooms);

            var now = floorPlan.filterParams.t;


            for (var i = data.result.timeframes[0].timeslots.length - 1; i >= 0; i--) {
                if (now >= data.result.timeframes[0].timeslots[i].startTime) {
                    timeframeIndex = i;
                    break;
                }
            }

            updateTimeframeTitle();
            floorPlan.filterParams.t = data.result.timeframes[0].timeslots[timeframeIndex].startTime;
        }


        floorPlan.refresh();
        floorPlan.drawGraphics();
    }
}




					
function showRoomPanel(e, o, e1) {
    if ($(".roomInfo").length > 0) {
        var boundingRect = this.el.getBoundingClientRect();

        $(".popupPanel table")
            .empty()
            .append(o.join(""));

        $(".roomInfo")
            .css("left", e1.clientX - boundingRect.left)
            .css("top", e1.clientY - 20 - boundingRect.top)
            .css("display", "block")
            .attr("data-ha", "c")
            .attr("data-va", "b");

        if (($(".roomInfo2").position().top + $(".roomInfo").position().top) < 0) {
            $(".roomInfo")
                .css("top", e1.clientY + 20 - boundingRect.top)
                .attr("data-va", "t");
        }
    }
}
