﻿// ONTIME namespace 
var ONTIME = ONTIME || {};

ONTIME.CalendarMonth = function (params) {
    this.el = null;

    this.rangeBegin = (new ONTIME.Date()).getBeginOf("M");
    this.rangeEnd = this.rangeBegin.clone().offset(1, "M").offset(-1, "D");

    $.extend(this, params);

    this.$el = $(this.el);

    this.drawHeader();
    this.refresh();
};

ONTIME.CalendarMonth.MONTH_TEMPLATE = '<div class="cal-month"><div class="cal-monthheader"></div><div class="cal-weekheader"></div><div class="cal-weekbody"></div></div>';
ONTIME.CalendarMonth.WEEK_TEMPLATE = '<div class="cal-week"></div>';
ONTIME.CalendarMonth.DAY_TEMPLATE = '<span class="cal-day"><span class="cal-day-box"><span><span></span></span></span></span>';

ONTIME.CalendarMonth.createRuntime = function (params) {
    var el = ONTIME.CalendarMonth.generateDomNode();
    el.attr(params.attr);

    var p = {};
    $.extend(true, p, params);
    p.el = el;

    return new ONTIME.CalendarMonth(p);
};

ONTIME.CalendarMonth.generateDomNode = function () {
    return $(ONTIME.CalendarMonth.MONTH_TEMPLATE);
};

ONTIME.CalendarMonth.prototype.drawHeader = function () {
    var wh = this.$el.find('.cal-weekheader');
    wh.empty();
    for (var i = 1; i <= 7; i++) {
        var r = $(ONTIME.CalendarMonth.DAY_TEMPLATE);
        r.addClass("cal-day" + (i == 7 ? 0 : i))

        wh.append(r);
    }
        

    var mh = this.$el.find('.cal-monthheader');
    if (!mh.hasClass("cal-default"))
        mh.text(this.getTitle());
};

ONTIME.CalendarMonth.prototype.clear = function () {
    this.$el.find('.cal-weekbody').empty();
};

ONTIME.CalendarMonth.prototype.refresh = function () {
    this.clear();
    this.processRange();
};

ONTIME.CalendarMonth.prototype.getTitle = function () {
    return this.rangeBegin.format("M 'YYYY")
};

ONTIME.CalendarMonth.prototype.getRange = function () {
    return {
        rangeBegin: this.rangeBegin,
        rangeEnd: this.rangeEnd
    };
};

ONTIME.CalendarMonth.prototype.getExtendedRange = function () {
    var range = this.getRange();

    return {
        rangeBegin: range.rangeBegin.getBeginOf("W"),
        rangeEnd: range.rangeEnd.getBeginOf("W").offset(7, "D")
    };
};

ONTIME.CalendarMonth.prototype.processRange = function (range) {
    var range = this.getRange();
    var extendedRange = this.getExtendedRange();

    var item = extendedRange.rangeBegin;
    var endTime = extendedRange.rangeEnd.getTime();
    
    while (item.getTime() < endTime) {
        var inRange = (item.getTime() >= range.rangeBegin.getTime() && item.getTime() <= range.rangeEnd.getTime());
        this.processRangeItem(item, inRange);
        item.offset(1, "D");
    }
};

ONTIME.CalendarMonth.prototype.processRangeItem = function (item, inRange) {
    this.pushItem(this.buildItem(item, inRange), item);
};

ONTIME.CalendarMonth.prototype.buildItem = function (item, inRange) {
    var r = $(ONTIME.CalendarMonth.DAY_TEMPLATE);

    r
        .addClass("cal-day" + item.getDay())
        .addClass(inRange ? "cal-range-in" : "cal-range-out");

    this.setItemContent(r, item, inRange);

    return r;
};

ONTIME.CalendarMonth.prototype.setItemContent = function (domItem, item, inRange) {
    domItem.find("span span span").text(item.getDate());
}

ONTIME.CalendarMonth.prototype.pushItem = function (domItem, item) {
    var wn = item.format("W")

    var weekNode = this.$el.find('.cal-weekbody .cal-week[data-wn="' + wn + '"]');
    if (weekNode.length > 0)
        weekNode.append(domItem);
    else {
        $(ONTIME.CalendarMonth.WEEK_TEMPLATE)
            .attr("data-wn", wn)
            .append(domItem)
            .appendTo(this.$el.find('.cal-weekbody'));
    }
};